/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.deployer.DeployerException;
import com.android.tools.manifest.parser.components.ManifestAppComponentInfo;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class AppComponent {
    protected final IDevice device;
    protected final String appId;
    protected final ManifestAppComponentInfo info;
    private final long SHELL_TIMEOUT = 15L;
    private final TimeUnit SHELL_TIMEUNIT = TimeUnit.SECONDS;

    protected String getFQEscapedName() {
        return AppComponent.getFQEscapedName(this.appId, this.info.getQualifiedName());
    }

    protected AppComponent(IDevice device, String appId, ManifestAppComponentInfo info) {
        this.device = device;
        this.appId = appId;
        this.info = info;
    }

    public abstract void activate(String var1, Mode var2, IShellOutputReceiver var3) throws DeployerException;

    protected void runShellCommand(String command, IShellOutputReceiver receiver) throws DeployerException {
        try {
            this.device.executeShellCommand(command, receiver, 15L, this.SHELL_TIMEUNIT);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            throw DeployerException.componentActivationException(e.getMessage());
        }
    }

    public static String getFQEscapedName(String appId, String componentFqName) {
        return appId + "/" + componentFqName.replace("$", "\\$");
    }

    public static enum Mode {
        RUN,
        DEBUG;

    }
}

