/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.utils.ILogger;
import java.util.Locale;

public class Activity
extends AppComponent {
    private final ILogger logger;

    public Activity(ManifestActivityInfo info, String appId, IDevice device, ILogger logger) {
        super(device, appId, info);
        this.logger = logger;
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver) throws DeployerException {
        this.validate(extraFlags, activationMode);
        this.logger.info("Activating Activity '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG) && extraFlags.contains(Flags.ENABLE_DEBUGGING.string)) {
            extraFlags = "-D " + extraFlags;
        }
        String command = this.getStartActivityCommand(extraFlags);
        this.logger.info("$ adb shell " + command, new Object[0]);
        this.runShellCommand(command, receiver);
    }

    private void validate(String extraFlags, AppComponent.Mode activationMode) throws DeployerException {
        this.validateFlags(extraFlags, activationMode);
    }

    private void validateFlags(String rawFlags, AppComponent.Mode mode) throws DeployerException {
        if (rawFlags.isEmpty()) {
            return;
        }
        String[] flags = rawFlags.split("\\s+");
        boolean hasArgument = false;
        for (String current : flags) {
            if (hasArgument) {
                hasArgument = false;
                continue;
            }
            try {
                Flags validFlag = Flags.valueOf(current.toUpperCase(Locale.US));
                hasArgument = validFlag.hasArgument;
            }
            catch (Exception e) {
                throw DeployerException.componentActivationException(String.format("Unknown flag '%s'", current));
            }
        }
        if (hasArgument) {
            throw DeployerException.componentActivationException("Invalid flags");
        }
    }

    private String getStartActivityCommand(String extraFlags) {
        return "am start -n " + this.getFQEscapedName() + " -a android.intent.action.MAIN -c android.intent.category.LAUNCHER" + extraFlags;
    }

    private static enum Flags {
        ENABLE_DEBUGGING("-D", false),
        WAIT_FOR_LAUNCH("-W", false),
        REPEAT("-R", true),
        STOP_FORCE("-S", false),
        START_PROFILING_WITH_STOP("-P", true),
        START_PROFILING("--START-PROFILER", true),
        OPENGL_TRACE("--OPENGL-TRACE", false),
        USER("--USER", true);

        public final String string;
        public final boolean hasArgument;

        private Flags(String flag, boolean hasArgument) {
            this.string = flag;
            this.hasArgument = hasArgument;
        }
    }
}

