/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.component.Activity;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.Complication;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.deployer.model.component.Tile;
import com.android.tools.deployer.model.component.WatchFace;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;
import java.util.List;
import java.util.Optional;

public class App {
    static final String NO_FLAGS = "";
    private final List<Apk> apks;
    private final String appId;
    private final IDevice device;
    private final ILogger logger;

    public App(String appId, List<Apk> apks, IDevice device, ILogger logger) {
        this.appId = appId;
        this.apks = apks;
        this.device = device;
        this.logger = logger;
    }

    public void activateComponent(ComponentType type, String componentName, IShellOutputReceiver receiver) throws DeployerException {
        this.activateComponent(type, componentName, NO_FLAGS, AppComponent.Mode.RUN, receiver);
    }

    public void activateComponent(ComponentType type, String componentName, String extraFlags, IShellOutputReceiver receiver) throws DeployerException {
        this.activateComponent(type, componentName, extraFlags, AppComponent.Mode.RUN, receiver);
    }

    public void activateComponent(ComponentType type, String componentName, AppComponent.Mode mode, IShellOutputReceiver receiver) throws DeployerException {
        this.activateComponent(type, componentName, NO_FLAGS, mode, receiver);
    }

    public void activateComponent(ComponentType type, String componentName, String extraFlags, AppComponent.Mode mode, IShellOutputReceiver receiver) throws DeployerException {
        String qualifiedName = componentName.startsWith(".") ? this.appId + componentName : componentName;
        AppComponent component = this.getComponent(type, qualifiedName);
        component.activate(extraFlags, mode, receiver);
    }

    private AppComponent getComponent(ComponentType type, String qualifiedName) throws DeployerException {
        AppComponent component = null;
        switch (type) {
            case ACTIVITY: {
                Optional<ManifestActivityInfo> optionalActivity = this.getActivity(qualifiedName);
                if (!optionalActivity.isPresent()) break;
                component = new Activity(optionalActivity.get(), this.appId, this.device, this.logger);
                break;
            }
            case WATCH_FACE: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new WatchFace(optionalService.get(), this.appId, this.device, this.logger);
                break;
            }
            case TILE: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new Tile(optionalService.get(), this.appId, this.device, this.logger);
                break;
            }
            case COMPLICATION: {
                Optional<ManifestServiceInfo> optionalService = this.getService(qualifiedName);
                if (!optionalService.isPresent()) break;
                component = new Complication(optionalService.get(), this.appId, this.device, this.logger);
                break;
            }
            default: {
                throw DeployerException.componentActivationException("Unsupported app component type " + (Object)((Object)type));
            }
        }
        if (component == null) {
            throw DeployerException.componentActivationException(String.format("'%s' with name '%s' is not found in '%s'", new Object[]{type, qualifiedName, this.appId}));
        }
        return component;
    }

    public void forceStop() {
        this.device.forceStop(this.appId);
    }

    private Optional<ManifestActivityInfo> getActivity(String qualifiedName) {
        for (Apk apk : this.apks) {
            Optional<ManifestActivityInfo> optionalActivity = apk.activities.stream().filter(a -> a.getQualifiedName().equals(qualifiedName)).findAny();
            if (!optionalActivity.isPresent()) continue;
            return optionalActivity;
        }
        return Optional.empty();
    }

    private Optional<ManifestServiceInfo> getService(String qualifiedName) {
        for (Apk apk : this.apks) {
            Optional<ManifestServiceInfo> optionalService = apk.services.stream().filter(a -> a.getQualifiedName().equals(qualifiedName)).findAny();
            if (!optionalService.isPresent()) continue;
            return optionalService;
        }
        return Optional.empty();
    }
}

