/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.r8.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlApkFileDatabase {
    private static final String SQLITE_JDBC_TEMP_DIR_PROPERTY = "org.sqlite.tmpdir";
    public static final int DEFAULT_MAX_DEXFILE_ENTRIES = 200;
    private static final String CURRENT_SCHEMA_VERSION_NUMBER = "1.1";
    private static final String CURRENT_CHECKSUM_TOOL_VERSION = Version.getVersionString();
    private static final String CURRENT_DATABASE_VERSION_STRING = "1.1|" + CURRENT_CHECKSUM_TOOL_VERSION;
    private final String databaseVersion;
    private final File dbFile;
    private final String nativeLibraryTmpDir;
    private boolean initialized;
    private int maxDexFilesEntries;
    private Connection connection;

    public SqlApkFileDatabase(File file, String nativeLibraryTmpDir) {
        this(file, nativeLibraryTmpDir, CURRENT_DATABASE_VERSION_STRING, 200);
    }

    public SqlApkFileDatabase(File file, String nativeLibraryTmpDir, String databaseVersion, int maxDexFileEntries) {
        this.databaseVersion = databaseVersion;
        this.maxDexFilesEntries = maxDexFileEntries;
        this.dbFile = file;
        this.nativeLibraryTmpDir = nativeLibraryTmpDir;
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNeeded() throws DeployerException {
        if (this.initialized) {
            return;
        }
        String previousSqliteTmpdir = System.getProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY);
        try {
            if (this.nativeLibraryTmpDir != null) {
                System.setProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY, this.nativeLibraryTmpDir);
                File tmpDir = new File(this.nativeLibraryTmpDir);
                if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                    throw new RuntimeException("Cannot create temp directory: " + tmpDir.getPath());
                }
            }
            Class.forName("org.sqlite.JDBC");
            boolean newFile = !this.dbFile.exists();
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", this.dbFile.getPath()));
            if (newFile) {
                this.fillTables();
            } else {
                this.dropOldTables();
            }
            this.executeStatements("PRAGMA foreign_keys=ON;");
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            if (e.getMessage().contains("NativeDB") && this.nativeLibraryTmpDir != null) {
                Path dir = Paths.get(this.nativeLibraryTmpDir, new String[0]);
                throw DeployerException.jdbcNativeLibError(dir.toAbsolutePath().toString());
            }
        }
        finally {
            if (this.nativeLibraryTmpDir != null) {
                if (previousSqliteTmpdir == null) {
                    System.clearProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY);
                } else {
                    System.setProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY, previousSqliteTmpdir);
                }
            }
        }
        this.initialized = true;
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void dropOldTables() throws SQLException {
        try (Statement s = this.connection.createStatement();
             ResultSet result = s.executeQuery("SELECT value from metadata WHERE name = \"schema-version\";");){
            String version2;
            if (result.next() && (version2 = result.getString("value")).equals(this.databaseVersion)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeStatements("PRAGMA writable_schema = 1;", "delete from sqlite_master where type in ('table', 'index', 'trigger');", "PRAGMA writable_schema = 0;", "VACUUM;");
        this.fillTables();
    }

    private void fillTables() throws SQLException {
        this.executeStatements("BEGIN;", "CREATE TABLE metadata (name VARCHAR(255) UNIQUE NOT NULL, value TEXT NOT NULL, PRIMARY KEY (name));", "INSERT INTO metadata (name, value) values (\"schema-version\", \"" + this.databaseVersion + "\");", "CREATE TABLE dexfiles (id INTEGER PRIMARY KEY AUTOINCREMENT, name VARCHAR(255) NOT NULL, checksum LONG NOT NULL);", "CREATE INDEX dexfiles_checksum_index ON dexfiles(checksum);", "CREATE TABLE archives (dexfileId INTEGER, checksum VARCHAR(255), CONSTRAINT fk_archives_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX archives_checksum_index ON archives(checksum);", "CREATE TABLE classes (dexfileId INTEGER, name TEXT, checksum LONG, CONSTRAINT fk_classes_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX classes_dexfileId_name_index ON classes(dexfileId);", "END;");
    }

    private void flushOldCache(int numDexFiles) {
        this.maxDexFilesEntries = Math.max(this.maxDexFilesEntries, numDexFiles * 2);
        try {
            this.executeUpdate("DELETE FROM dexfiles WHERE id < (SELECT * FROM (SELECT id from dexfiles ORDER BY id DESC LIMIT " + this.maxDexFilesEntries + ") ORDER BY id LIMIT 1);");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeStatements(String ... statements) throws SQLException {
        try (Statement s = this.connection.createStatement();){
            if (statements.length == 1) {
                s.execute(statements[0]);
            } else {
                for (String statement : statements) {
                    s.addBatch(statement);
                }
                s.executeBatch();
            }
        }
    }

    private int executeUpdate(String query) throws SQLException {
        try (Statement s = this.connection.createStatement();){
            int n = s.executeUpdate(query);
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    public List<DexClass> getClasses(ApkEntry dex) throws DeployerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addClasses(Collection<DexClass> allClasses) throws DeployerException {
        this.initializeIfNeeded();
        int numDex = 0;
        try {
            HashMap<Apk, Multimap> map = new HashMap<Apk, Multimap>();
            for (DexClass dexClass : allClasses) {
                Multimap multimap = (Multimap)map.get(dexClass.dex.getApk());
                if (multimap == null) {
                    multimap = HashMultimap.create();
                    map.put(dexClass.dex.getApk(), multimap);
                }
                multimap.put((Object)dexClass.dex, (Object)dexClass);
            }
            for (Map.Entry entry : map.entrySet()) {
                Multimap classes = (Multimap)entry.getValue();
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (ApkEntry dex : classes.keySet()) {
                    ++numDex;
                    int id = this.addDexFile(dex.getChecksum(), dex.getName());
                    ids.add(id);
                    this.addClasses(id, classes.get((Object)dex));
                }
                this.addDexFiles(((Apk)entry.getKey()).checksum, ids);
            }
            this.flushOldCache(numDex);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int addDexFile(long checksum, String name) throws SQLException {
        String insert = String.format("INSERT INTO dexfiles(name, checksum) VALUES (\"%s\", %d);", name, checksum);
        try (Statement s = this.connection.createStatement();){
            int n;
            block13: {
                int updated = s.executeUpdate(insert);
                assert (updated == 1);
                ResultSet set = s.executeQuery("SELECT LAST_INSERT_ROWID();");
                try {
                    n = set.getInt(1);
                    if (set == null) break block13;
                }
                catch (Throwable throwable) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set.close();
            }
            return n;
        }
    }

    private void addClasses(int dexId, Collection<DexClass> classes) throws SQLException {
        if (classes.isEmpty()) {
            return;
        }
        String values = classes.stream().map(e -> String.format("(%d, \"%s\", %d)", dexId, e.name, e.checksum)).collect(Collectors.joining(","));
        String insert = String.format("INSERT INTO classes (dexfileId, name, checksum) VALUES %s;", values);
        int updated = this.executeUpdate(insert);
        assert (updated == classes.size());
    }

    private void addDexFiles(String archiveChecksum, List<Integer> files) throws SQLException {
        if (files.isEmpty()) {
            return;
        }
        String values = files.stream().map(e -> String.format("(%d, \"%s\")", e, archiveChecksum)).collect(Collectors.joining(","));
        String insert = String.format("INSERT INTO archives (dexfileId, checksum) VALUES %s;", values);
        int updated = this.executeUpdate(insert);
        assert (updated == files.size());
    }

    @VisibleForTesting
    public List<DexClass> dump() throws DeployerException {
        this.initializeIfNeeded();
        ArrayList<DexClass> classes = new ArrayList<DexClass>();
        for (Apk apk : this.getApks()) {
            for (ApkEntry file : this.getFiles(apk)) {
                classes.addAll(this.getClasses(file));
            }
        }
        classes.sort(Comparator.comparingInt(a -> (int)a.checksum));
        return classes;
    }

    @VisibleForTesting
    public boolean hasDuplicates() throws DeployerException {
        this.initializeIfNeeded();
        for (Apk apk : this.getApks()) {
            ArrayList<DexClass> classes = new ArrayList<DexClass>();
            for (ApkEntry file : this.getFiles(apk)) {
                classes.addAll(this.getClasses(file));
            }
            for (int i = 0; i < classes.size(); ++i) {
                DexClass dexI = (DexClass)classes.get(i);
                for (int j = 0; j < classes.size(); ++j) {
                    if (i == j) continue;
                    DexClass dexJ = (DexClass)classes.get(j);
                    if (!dexI.name.equals(dexJ.name) || dexI.checksum != dexJ.checksum) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ApkEntry> getFiles(Apk apk) {
        try (Statement s = this.connection.createStatement();){
            ArrayList<ApkEntry> arrayList;
            block15: {
                ResultSet result = s.executeQuery("SELECT dexfiles.name as name, dexfiles.checksum as checksum FROM dexfiles  INNER JOIN archives on archives.dexfileId = dexfiles.id  WHERE archives.checksum = \"" + apk.checksum + "\"");
                try {
                    ArrayList<ApkEntry> files = new ArrayList<ApkEntry>();
                    while (result.next()) {
                        files.add(new ApkEntry(result.getString("name"), result.getLong("checksum"), apk));
                    }
                    arrayList = files;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Apk> getApks() {
        try (Statement s = this.connection.createStatement();){
            ArrayList<Apk> arrayList;
            block15: {
                ResultSet result = s.executeQuery("SELECT DISTINCT checksum from archives");
                try {
                    ArrayList<Apk> apks = new ArrayList<Apk>();
                    while (result.next()) {
                        apks.add(Apk.builder().setChecksum(result.getString("checksum")).build());
                    }
                    arrayList = apks;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

