/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.google.common.collect.Lists;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.HashMap;
import java.util.List;

public class JdiBasedClassRedefiner
implements ClassRedefiner {
    private static final String AGENT_LOC_FORMAT = "/data/data/%s/code_cache/.studio/%s.so=irsocket";
    private static final String SUPPORTED_ABIS_FIELD = "SUPPORTED_64_BIT_ABIS";
    private final VirtualMachine vm;
    private final ClassRedefiner.RedefineClassSupportState redefineSupportState;

    public JdiBasedClassRedefiner(VirtualMachine vm, ClassRedefiner.RedefineClassSupportState redefineSupportState) {
        this.vm = vm;
        this.redefineSupportState = redefineSupportState;
    }

    @Override
    public Deploy.SwapResponse redefine(Deploy.SwapRequest request) throws DeployerException {
        HashMap<ReferenceType, byte[]> redefinitionRequest = new HashMap<ReferenceType, byte[]>();
        for (Deploy.ClassDef redefinition : request.getModifiedClassesList()) {
            List<ReferenceType> classes = this.vm.classesByName(redefinition.getName());
            for (ReferenceType classRef : classes) {
                redefinitionRequest.put(classRef, redefinition.getDex().toByteArray());
            }
        }
        Deploy.SwapResponse.Builder response = Deploy.SwapResponse.newBuilder();
        switch (this.redefineSupportState.support) {
            case FULL: {
                try {
                    this.vm.redefineClasses(redefinitionRequest);
                    break;
                }
                catch (Throwable t) {
                    throw DeployerException.jdwpRedefineClassesException(t);
                }
            }
            case MAIN_THREAD_RUNNING: {
                break;
            }
            case NEEDS_AGENT_SERVER: {
                List<ReferenceType> buildList = this.vm.classesByName("android.os.Build");
                ClassType build = (ClassType)buildList.get(0);
                Field abiField = build.fieldByName(SUPPORTED_ABIS_FIELD);
                if (abiField == null) {
                    throw DeployerException.abisFieldNotFound();
                }
                ArrayReference abis = (ArrayReference)build.getValue(abiField);
                String agentLoc = String.format(AGENT_LOC_FORMAT, request.getPackageName(), JdiBasedClassRedefiner.getAgentName(request.getArch(), abis.length() > 0));
                List<ReferenceType> debugList = this.vm.classesByName("dalvik.system.VMDebug");
                ClassType debug = (ClassType)debugList.get(0);
                List<ThreadReference> allThreads = this.vm.allThreads();
                for (ThreadReference thread : allThreads) {
                    if (!thread.name().equals(this.redefineSupportState.targetThread)) continue;
                    Method attachAgentMethod = debug.concreteMethodByName("attachAgent", "(Ljava/lang/String;)V");
                    if (attachAgentMethod == null) {
                        throw DeployerException.attachAgentNotFound();
                    }
                    try {
                        debug.invokeMethod(thread, attachAgentMethod, Lists.newArrayList((Object[])new StringReference[]{this.vm.mirrorOf(agentLoc)}), 1);
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(1000L);
                            debug.invokeMethod(thread, attachAgentMethod, Lists.newArrayList((Object[])new StringReference[]{this.vm.mirrorOf(agentLoc)}), 1);
                        }
                        catch (Exception e1) {
                            throw DeployerException.attachAgentException(e1);
                        }
                    }
                }
                break;
            }
            default: {
                throw DeployerException.jdiInvalidState();
            }
        }
        response.setStatus(Deploy.SwapResponse.Status.OK);
        return response.build();
    }

    @Override
    public Deploy.SwapResponse redefine(Deploy.OverlaySwapRequest request) throws DeployerException {
        HashMap<ReferenceType, byte[]> redefinitionRequest = new HashMap<ReferenceType, byte[]>();
        for (Deploy.ClassDef redefinition : request.getModifiedClassesList()) {
            List<ReferenceType> classes = this.vm.classesByName(redefinition.getName());
            for (ReferenceType classRef : classes) {
                redefinitionRequest.put(classRef, redefinition.getDex().toByteArray());
            }
        }
        try {
            this.vm.redefineClasses(redefinitionRequest);
        }
        catch (Throwable t) {
            throw DeployerException.jdwpRedefineClassesException(t);
        }
        Deploy.SwapResponse.Builder response = Deploy.SwapResponse.newBuilder();
        response.setStatus(Deploy.SwapResponse.Status.OK);
        return response.build();
    }

    @Override
    public ClassRedefiner.RedefineClassSupportState canRedefineClass() {
        return this.redefineSupportState;
    }

    private static String getAgentName(Deploy.Arch appArch, boolean deviceIs64Bit) {
        if (appArch == Deploy.Arch.ARCH_32_BIT && deviceIs64Bit) {
            return "agent-alt";
        }
        return "agent";
    }
}

