/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

class AdbInstallerChannel
implements AutoCloseable {
    private final SocketChannel channel;
    private final Selector readSelector;
    private final SelectionKey readKey;
    private final Selector writeSelector;
    private final SelectionKey writeKey;
    private final ReentrantLock lock = new ReentrantLock(true);
    private static final long PER_WRITE_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);

    AdbInstallerChannel(SocketChannel c) throws IOException {
        this.channel = c;
        this.channel.configureBlocking(false);
        this.readSelector = Selector.open();
        this.readKey = this.channel.register(this.readSelector, 1);
        this.writeSelector = Selector.open();
        this.writeKey = this.channel.register(this.writeSelector, 4);
    }

    void read(ByteBuffer buffer, long timeOutMs) throws IOException {
        this.checkLock();
        long deadline = System.currentTimeMillis() + timeOutMs;
        while (buffer.remaining() != 0) {
            long timeout = Math.max(0L, deadline - System.currentTimeMillis());
            this.readSelector.select(timeout);
            int read2 = this.channel.read(buffer);
            if (read2 == 0 || System.currentTimeMillis() >= deadline) {
                String template = "InstallerChannel.select: Timeout on read after %dms";
                String msg = String.format(Locale.US, template, timeOutMs);
                throw new IOException(msg);
            }
            if (read2 != -1) continue;
            break;
        }
        buffer.rewind();
    }

    void write(ByteBuffer buffer, long timeOutMs) throws IOException, TimeoutException {
        this.checkLock();
        long deadline = System.currentTimeMillis() + timeOutMs;
        while (buffer.remaining() != 0) {
            if (System.currentTimeMillis() >= deadline) {
                throw new TimeoutException("InstallerChannel write timeout");
            }
            long timeout = Math.min(PER_WRITE_TIME_OUT, deadline - System.currentTimeMillis());
            timeout = Math.max(0L, timeout);
            this.writeSelector.select(timeout);
            int written = this.channel.write(buffer);
            if (written != 0) continue;
            throw new TimeoutException("InstallerChannel write timeout");
        }
    }

    @Override
    public void close() throws IOException {
        try (SocketChannel c = this.channel;
             Selector r = this.readSelector;){
            Selector w = this.writeSelector;
            if (w != null) {
                w.close();
            }
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void checkLock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Channel lock must be acquired before read/write");
        }
    }
}

