/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstallerChannel;
import com.android.tools.deployer.AdbInstallerChannelManager;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.Timeouts;
import com.android.tools.deployer.Version;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.CodedOutputStream;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeoutException;

public class AdbInstaller
implements Installer {
    public static final String INSTALLER_BINARY_NAME = "installer";
    public static final String INSTALLER_PATH = "/data/local/tmp/.studio/bin/installer";
    public static final String ANDROID_EXECUTABLE_PATH = "/tools/base/deploy/installer/android-installer";
    private final AdbClient adb;
    private final String installersFolder;
    private final Collection<DeployMetric> metrics;
    private final ILogger logger;
    private static final byte[] MAGIC_NUMBER = new byte[]{-84, -91, -84, -91, -84, -91, -84, -91};
    private final AdbInstallerChannelManager channelsProvider;
    private final Mode mode;

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger) {
        this(installersFolder, adb, metrics, logger, Mode.ONE_SHOT);
    }

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger, Mode mode) {
        this.adb = adb;
        this.installersFolder = installersFolder;
        this.metrics = metrics;
        this.logger = logger;
        this.channelsProvider = new AdbInstallerChannelManager(logger, mode);
        this.mode = mode;
    }

    private void logEvents(List<Deploy.Event> events) {
        for (Deploy.Event event : events) {
            if (event.getType() == Deploy.Event.Type.TRC_END) continue;
            this.logger.info(event.getTimestampNs() / 1000000L + "ms " + event.getType() + " [" + event.getPid() + "][" + event.getTid() + "] : " + event.getText(), new Object[0]);
        }
    }

    @Override
    public Deploy.InstallCoroutineAgentResponse installCoroutineAgent(String packageName, Deploy.Arch arch) throws IOException {
        Deploy.InstallCoroutineAgentRequest.Builder installCoroutineAgentRequestBuilder = Deploy.InstallCoroutineAgentRequest.newBuilder();
        installCoroutineAgentRequestBuilder.setPackageName(packageName).setArch(arch);
        Deploy.InstallerRequest.Builder request = this.buildRequest("installcoroutineagent").setInstallCoroutineAgentRequest(installCoroutineAgentRequestBuilder);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build(), Timeouts.CMD_INSTALL_COROUTINE);
        Deploy.InstallCoroutineAgentResponse response = installerResponse.getInstallCoroutineAgentResponse();
        this.logger.verbose("installer install coroutine agent: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.DumpResponse dump(List<String> packageNames) throws IOException {
        Deploy.DumpRequest.Builder dumpRequestBuilder = Deploy.DumpRequest.newBuilder();
        for (String packageName : packageNames) {
            dumpRequestBuilder.addPackageNames(packageName);
        }
        Deploy.InstallerRequest.Builder req = this.buildRequest("dump").setDumpRequest(dumpRequestBuilder);
        Deploy.InstallerResponse resp = this.sendInstallerRequest(req.build(), Timeouts.CMD_DUMP_MS);
        Deploy.DumpResponse response = resp.getDumpResponse();
        this.logger.verbose("installer dump: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.SwapResponse swap(Deploy.SwapRequest swapRequest) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("swap");
        req.setSwapRequest(swapRequest);
        Deploy.InstallerResponse resp = this.sendInstallerRequest(req.build(), Timeouts.CMD_SWAP_MS);
        Deploy.SwapResponse response = resp.getSwapResponse();
        this.logger.verbose("installer swap: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.SwapResponse overlaySwap(Deploy.OverlaySwapRequest overlaySwapRequest) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("overlayswap");
        req.setOverlaySwapRequest(overlaySwapRequest);
        Deploy.InstallerResponse resp = this.sendInstallerRequest(req.build(), Timeouts.CMD_OSWAP_MS);
        Deploy.SwapResponse response = resp.getSwapResponse();
        this.logger.verbose("installer overlayswap: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.OverlayInstallResponse overlayInstall(Deploy.OverlayInstallRequest overlayInstallRequest) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("overlayinstall");
        req.setOverlayInstall(overlayInstallRequest);
        Deploy.InstallerResponse resp = this.sendInstallerRequest(req.build(), Timeouts.CMD_OINSTALL_MS);
        Deploy.OverlayInstallResponse response = resp.getOverlayInstallResponse();
        this.logger.verbose("installer overlayinstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.OverlayIdPushResponse verifyOverlayId(String packageName, String oid) throws IOException {
        Deploy.OverlayIdPush overlayIdPushRequest = AdbInstaller.createOidPushRequest(packageName, oid, oid, false);
        Deploy.InstallerRequest.Builder req = this.buildRequest("overlayidpush");
        req.setOverlayIdPush(overlayIdPushRequest);
        Deploy.InstallerResponse res = this.sendInstallerRequest(req.build(), Timeouts.CMD_VERIFY_OID_MS);
        Deploy.OverlayIdPushResponse response = res.getOverlayidpushResponse();
        this.logger.verbose("installer overlayidpush: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.NetworkTestResponse networkTest(Deploy.NetworkTestRequest testParams) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("networktest");
        request.setNetworkTestRequest(testParams);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build(), Timeouts.CMD_NETTEST);
        return installerResponse.getNetworkTestResponse();
    }

    private static Deploy.OverlayIdPush createOidPushRequest(String packageName, String prevOid, String nextOid, boolean wipeOverlays) {
        return Deploy.OverlayIdPush.newBuilder().setPackageName(packageName).setPrevOid(prevOid).setNextOid(nextOid).setWipeOverlays(wipeOverlays).build();
    }

    @Override
    public Deploy.DeltaPreinstallResponse deltaPreinstall(Deploy.InstallInfo info) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("deltapreinstall");
        req.setInstallInfoRequest(info);
        Deploy.InstallerResponse res = this.sendInstallerRequest(req.build(), Timeouts.CMD_DELTA_PREINSTALL_MS);
        Deploy.DeltaPreinstallResponse response = res.getDeltapreinstallResponse();
        this.logger.verbose("installer deltapreinstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.DeltaInstallResponse deltaInstall(Deploy.InstallInfo info) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("deltainstall");
        req.setInstallInfoRequest(info);
        Deploy.InstallerResponse res = this.sendInstallerRequest(req.build(), Timeouts.CMD_DELTA_INSTALL_MS);
        Deploy.DeltaInstallResponse response = res.getDeltainstallResponse();
        this.logger.verbose("installer deltainstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.LiveLiteralUpdateResponse updateLiveLiterals(Deploy.LiveLiteralUpdateRequest liveLiterals) throws IOException {
        Deploy.InstallerRequest.Builder req = this.buildRequest("liveliteralupdate");
        req.setLiveLiteralRequest(liveLiterals);
        Deploy.InstallerResponse res = this.sendInstallerRequest(req.build(), Timeouts.CMD_UPDATE_LL);
        Deploy.LiveLiteralUpdateResponse response = res.getLiveLiteralResponse();
        this.logger.verbose("installer liveliteralupdate: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.LiveEditResponse liveEdit(Deploy.LiveEditRequest ler) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("liveedit");
        request.setLeRequest(ler);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build(), Timeouts.CMD_LIVE_EDIT);
        Deploy.LiveEditResponse response = installerResponse.getLeResponse();
        this.logger.verbose("installer liveEdit: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest request, long timeOutMs) throws IOException {
        Trace.begin("./installer " + request.getCommandName());
        long start2 = System.nanoTime();
        Deploy.InstallerResponse response = this.sendInstallerRequest(request, OnFail.RETRY, timeOutMs);
        this.logEvents(response.getEventsList());
        long end2 = System.nanoTime();
        long maxNs = Long.MIN_VALUE;
        long minNs = Long.MAX_VALUE;
        for (Deploy.Event event : response.getEventsList()) {
            maxNs = Math.max(maxNs, event.getTimestampNs());
            minNs = Math.min(minNs, event.getTimestampNs());
        }
        long delta = (maxNs + minNs - (end2 + start2)) / 2L;
        Stack<Deploy.Event> eventStack = new Stack<Deploy.Event>();
        for (Deploy.Event event : response.getEventsList()) {
            switch (event.getType()) {
                case TRC_BEG: 
                case TRC_METRIC: {
                    Trace.begin(event.getPid(), event.getTid(), event.getTimestampNs() - delta, event.getText());
                    eventStack.push(event);
                    break;
                }
                case TRC_END: {
                    Deploy.Event begin;
                    Trace.end(event.getPid(), event.getTid(), event.getTimestampNs() - delta);
                    if (eventStack.empty() || (begin = (Deploy.Event)eventStack.pop()).getType() != Deploy.Event.Type.TRC_METRIC) break;
                    long startMs = begin.getTimestampNs() - delta;
                    long endMs = event.getTimestampNs() - delta;
                    this.metrics.add(new DeployMetric(begin.getText(), startMs, endMs));
                    break;
                }
            }
        }
        Trace.end();
        return response;
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest installerRequest, OnFail onFail, long timeOutMs) throws IOException {
        ByteBuffer request = this.wrap(installerRequest);
        Deploy.InstallerResponse response = null;
        AdbInstallerChannel channel = this.channelsProvider.getChannel(this.adb, this.getVersion());
        channel.lock();
        try {
            if (this.writeRequest(channel, request, timeOutMs)) {
                response = this.readResponse(channel, timeOutMs);
            }
        }
        catch (TimeoutException e) {
            String msg = String.format("Device '%s' timed out", this.adb.getName());
            throw new IOException(msg);
        }
        finally {
            channel.unlock();
        }
        if (response == null) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Invalid installer response");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(installerRequest, OnFail.DO_NO_RETRY, timeOutMs);
        }
        if (response.getStatus() == Deploy.InstallerResponse.Status.ERROR_WRONG_VERSION) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Unrecoverable installer WRONG_VERSION error. Aborting");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(installerRequest, OnFail.DO_NO_RETRY, timeOutMs);
        }
        if (this.mode == Mode.ONE_SHOT) {
            this.channelsProvider.reset(this.adb);
        }
        return response;
    }

    private boolean writeRequest(AdbInstallerChannel channel, ByteBuffer request, long timeOutMs) throws TimeoutException {
        try {
            channel.write(request, timeOutMs);
        }
        catch (IOException e) {
            return false;
        }
        return request.remaining() == 0;
    }

    private Deploy.InstallerResponse readResponse(AdbInstallerChannel channel, long timeOutMs) {
        try {
            ByteBuffer bufferMarker = ByteBuffer.allocate(MAGIC_NUMBER.length);
            channel.read(bufferMarker, timeOutMs);
            if (!Arrays.equals(MAGIC_NUMBER, bufferMarker.array())) {
                String garbage = new String(bufferMarker.array(), Charsets.UTF_8);
                this.logger.info("Read '" + garbage + "' from socket", new Object[0]);
                return null;
            }
            ByteBuffer bufferSize = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(bufferSize, timeOutMs);
            int responseSize = bufferSize.getInt();
            if (responseSize < 0) {
                return null;
            }
            ByteBuffer bufferPayload = ByteBuffer.allocate(responseSize);
            channel.read(bufferPayload, timeOutMs);
            return this.unwrap(bufferPayload);
        }
        catch (IOException e) {
            this.logger.warning("Error while reading InstallerChannel", new Object[0]);
            return null;
        }
    }

    private void prepare() throws IOException {
        File installerFile = null;
        List<String> abis = this.adb.getAbis();
        for (String abi : abis) {
            String installerJarPath = abi + "/" + INSTALLER_BINARY_NAME;
            InputStream inputStream = this.getResource(installerJarPath);
            try {
                if (inputStream == null) continue;
                this.logger.info("Pushed installer '" + installerJarPath + "'", new Object[0]);
                installerFile = File.createTempFile(".studio_installer", abi);
                Files.copy(inputStream, Paths.get(installerFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (installerFile == null) {
            throw new IOException("Unsupported abis: " + Arrays.toString(abis.toArray()));
        }
        this.cleanAndPushInstaller(installerFile);
        installerFile.delete();
    }

    private void cleanAndPushInstaller(File installerFile) throws IOException {
        this.runShell(new String[]{"rm", "-fr", "/data/local/tmp/.studio/bin", "/data/local/tmp/.studio/tmp"}, Timeouts.SHELL_RMFR);
        this.runShell(new String[]{"mkdir", "-p", "/data/local/tmp/.studio/bin", "/data/local/tmp/.studio/tmp"}, Timeouts.SHELL_MKDIR);
        this.adb.push(installerFile.getAbsolutePath(), INSTALLER_PATH);
        this.runShell(new String[]{"chmod", "+x", INSTALLER_PATH}, Timeouts.SHELL_CHMOD);
    }

    private void runShell(String[] cmd, long timeOutMs) throws IOException {
        byte[] response = this.adb.shell(cmd, timeOutMs);
        if (response.length <= 0) {
            return;
        }
        String extraMsg = new String(response, Charsets.UTF_8).trim();
        String error = String.format("Cannot '%s' : '%s'", String.join((CharSequence)" ", cmd), extraMsg);
        this.logger.error(null, error, new Object[0]);
        throw new IOException(error);
    }

    private InputStream getResource(String path2) throws FileNotFoundException {
        InputStream stream = this.installersFolder == null ? Installer.class.getResourceAsStream("/tools/base/deploy/installer/android-installer/" + path2) : new FileInputStream(this.installersFolder + "/" + path2);
        return stream;
    }

    private Deploy.InstallerResponse unwrap(ByteBuffer buffer) {
        buffer.rewind();
        try {
            CodedInputStream cis = CodedInputStream.newInstance((ByteBuffer)buffer);
            return (Deploy.InstallerResponse)Deploy.InstallerResponse.parser().parseFrom(cis);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteBuffer wrap(Deploy.InstallerRequest message2) {
        int messageSize = message2.getSerializedSize();
        int headerSize = MAGIC_NUMBER.length + 4;
        byte[] buffer = new byte[headerSize + messageSize];
        ByteBuffer headerWriter = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
        headerWriter.put(MAGIC_NUMBER);
        headerWriter.putInt(messageSize);
        try {
            CodedOutputStream cos = CodedOutputStream.newInstance((byte[])buffer, (int)headerSize, (int)messageSize);
            message2.writeTo(cos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ByteBuffer.wrap(buffer);
    }

    @VisibleForTesting
    public String getVersion() {
        return Version.hash();
    }

    private Deploy.InstallerRequest.Builder buildRequest(String commandName) {
        Deploy.InstallerRequest.Builder request = Deploy.InstallerRequest.newBuilder().setCommandName(commandName).setVersion(this.getVersion());
        return request;
    }

    public static enum Mode {
        DAEMON,
        ONE_SHOT;

    }

    private static enum OnFail {
        RETRY,
        DO_NO_RETRY;

    }
}

