/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveErrorEntry;
import com.android.tools.apk.analyzer.ArchiveManager;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchivePathEntry;
import com.android.tools.apk.analyzer.ArchiveTreeStream;
import com.android.tools.apk.analyzer.InnerArchiveEntry;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipError;
import javax.swing.tree.MutableTreeNode;

public class ArchiveTreeStructure {
    public static ArchiveNode create(ArchiveContext archiveContext) {
        return ArchiveTreeStructure.createWorker(archiveContext.getArchiveManager(), archiveContext.getArchive(), "");
    }

    private static ArchiveNode createWorker(ArchiveManager archiveManager, Archive archive, String pathPrefix) {
        Path contentRoot = archive.getContentRoot();
        ArchiveTreeNode rootNode = new ArchiveTreeNode(new ArchivePathEntry(archive, contentRoot, pathPrefix));
        Stack<ArchiveTreeNode> stack = new Stack<ArchiveTreeNode>();
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            ArchiveTreeNode node = (ArchiveTreeNode)stack.pop();
            Path path2 = node.getData().getPath();
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path2);
                try {
                    for (Path childPath : stream) {
                        ArchiveTreeNode childNode;
                        Archive innerArchive;
                        try {
                            innerArchive = archiveManager.openInnerArchive(archive, childPath);
                        }
                        catch (IOException | ZipError e) {
                            node.add(ArchiveTreeStructure.createErrorNode(archive, childPath, pathPrefix, e));
                            continue;
                        }
                        if (innerArchive != null) {
                            ArchiveTreeNode newArchiveNode = (ArchiveTreeNode)ArchiveTreeStructure.createWorker(archiveManager, innerArchive, pathPrefix + childPath.toString());
                            childNode = new ArchiveTreeNode(new InnerArchiveEntry(archive, childPath, pathPrefix, innerArchive));
                            for (ArchiveNode archiveNodeChild : newArchiveNode.getChildren()) {
                                childNode.add((MutableTreeNode)((Object)archiveNodeChild));
                            }
                        } else {
                            childNode = new ArchiveTreeNode(new ArchivePathEntry(archive, childPath, pathPrefix));
                            if (Files.isDirectory(childPath, new LinkOption[0])) {
                                stack.push(childNode);
                            }
                        }
                        node.add(childNode);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                node.add(new ArchiveTreeNode(new ArchiveErrorEntry(archive, path2, pathPrefix, e)));
            }
        }
        return rootNode;
    }

    private static ArchiveTreeNode createErrorNode(Archive archive, Path childPath, String pathPrefix, Throwable error) {
        ArchiveTreeNode childNode = new ArchiveTreeNode(new ArchivePathEntry(archive, childPath, pathPrefix));
        childNode.add(new ArchiveTreeNode(new ArchiveErrorEntry(archive, childPath, pathPrefix, error)));
        return childNode;
    }

    public static void updateRawFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> rawFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getRawSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getRawSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long rawFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateRawFileSizes(node, calculator);
            }
            if ((rawFileSize = (Long)rawFileSizes.get(data.getPath().toString())) != null) {
                data.setRawFileSize(rawFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getRawFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getRawFileSize()).reduce(0L, Long::sum);
                data.setRawFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void updateDownloadFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> downloadFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getDownloadSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getDownloadSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long downloadFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateDownloadFileSizes(node, calculator);
            }
            if ((downloadFileSize = (Long)downloadFileSizes.get(data.getPath().toString())) != null) {
                data.setDownloadFileSize(downloadFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getDownloadFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getDownloadFileSize()).reduce(0L, Long::sum);
                data.setDownloadFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void sort(ArchiveNode root, Comparator<ArchiveNode> comparator) {
        assert (root instanceof ArchiveTreeNode);
        ArchiveTreeStructure.sort((ArchiveTreeNode)root, comparator);
    }

    private static void sort(ArchiveTreeNode root, Comparator<ArchiveNode> comparator) {
        ArrayList<ArchiveNode> children = new ArrayList<ArchiveNode>(root.getChildren());
        children.sort(comparator);
        root.removeAllChildren();
        for (ArchiveNode child : children) {
            root.add((ArchiveTreeNode)child);
            ArchiveTreeStructure.sort(child, comparator);
        }
    }
}

