/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.SdkConstants;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.DefaultProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import com.android.utils.LineCollector;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class AaptInvoker {
    private final Path aapt;
    private final DefaultProcessExecutor processExecutor;

    public AaptInvoker(Path aaptPath, ILogger logger) {
        this.aapt = aaptPath;
        this.processExecutor = new DefaultProcessExecutor(logger);
    }

    public AaptInvoker(AndroidSdkHandler sdkHandler, ILogger logger) {
        this(AaptInvoker.getPathToAapt(sdkHandler, logger), logger);
    }

    private List<String> invokeAaptWithParameters(File apkFile, String resource, String ... parameters) throws ProcessException {
        String[] params = Arrays.copyOf(parameters, parameters.length + 2);
        params[params.length - 2] = apkFile.getPath();
        params[params.length - 1] = resource;
        return this.invokeAaptWithParameters(params);
    }

    private List<String> invokeAaptWithParameters(String ... parameters) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.aapt.toFile());
        builder.addArgs(parameters);
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        ProcessResult result = this.processExecutor.execute(builder.createProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
        result.assertNormalExitValue();
        BaseProcessOutputHandler.BaseProcessOutput output = processOutputHandler.getProcessOutput();
        LineCollector lineCollector2 = new LineCollector();
        output.processStandardOutputLines((LineProcessor)lineCollector2);
        return lineCollector2.getResult();
    }

    public List<String> getXmlTree(File apk, String xmlResourcePath) throws ProcessException {
        return this.invokeAaptWithParameters(apk, xmlResourcePath, "dump", "xmltree");
    }

    public List<String> dumpBadging(File apk) throws ProcessException {
        return this.invokeAaptWithParameters("dump", "badging", apk.toString());
    }

    public static Path getPathToAapt(AndroidSdkHandler sdkHandler, ILogger logger) {
        BuildToolInfo latestBuildTool = sdkHandler.getLatestBuildTool((ProgressIndicator)new LoggerProgressIndicatorWrapper(logger), true);
        if (latestBuildTool == null) {
            throw new IllegalStateException("Cannot locate latest build tools");
        }
        return latestBuildTool.getLocation().resolve(SdkConstants.FN_AAPT);
    }
}

