/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicStyleResourceItem
extends BasicValueResourceItemBase
implements StyleResourceValue {
    private static final Logger LOG = Logger.getInstance(BasicStyleResourceItem.class);
    @Nullable
    private final String myParentStyle;
    @NotNull
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public BasicStyleResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String parentStyle, @NotNull Collection<StyleItemResourceValue> styleItems) {
        super(ResourceType.STYLE, name, sourceFile, visibility);
        this.myParentStyle = parentStyle;
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        HashMap<ResourceReference, StyleItemResourceValue> duplicateCheckMap = new HashMap<ResourceReference, StyleItemResourceValue>();
        for (StyleItemResourceValue styleItem : styleItems) {
            ResourceReference attr = styleItem.getAttr();
            if (attr == null) continue;
            StyleItemResourceValue previouslyDefined = duplicateCheckMap.put(attr, styleItem);
            if (previouslyDefined == null) {
                tableBuilder.put((Object)attr.getNamespace(), (Object)attr.getName(), (Object)styleItem);
                continue;
            }
            if (previouslyDefined.equals(styleItem)) continue;
            LOG.warn("Conflicting definitions of \"" + styleItem.getAttrName() + "\" in style \"" + name + "\"");
        }
        this.myStyleItemTable = tableBuilder.build();
    }

    @Nullable
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceNamespace namespace, @NotNull String name) {
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)namespace, (Object)name);
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceReference attr) {
        assert (attr.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)attr.getNamespace(), (Object)attr.getName());
    }

    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.myStyleItemTable.values();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleResourceItem other = (BasicStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myParentStyle);
        stream.writeInt(this.myStyleItemTable.size());
        for (StyleItemResourceValue styleItem : this.myStyleItemTable.values()) {
            stream.writeString(styleItem.getAttrName());
            stream.writeString(styleItem.getValue());
            int index = namespaceResolverIndexes.getInt((Object)styleItem.getNamespaceResolver());
            assert (index >= 0);
            stream.writeInt(index);
        }
    }

    @NotNull
    static BasicStyleResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        LoadableResourceRepository repository2 = sourceFile.getRepository();
        ResourceNamespace namespace = repository2.getNamespace();
        String libraryName = repository2.getLibraryName();
        String parentStyle = stream.readString();
        int n = stream.readInt();
        ArrayList<StyleItemResourceValue> styleItems = n == 0 ? Collections.emptyList() : new ArrayList<StyleItemResourceValue>(n);
        for (int i = 0; i < n; ++i) {
            String attrName = stream.readString();
            if (attrName == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            String value = stream.readString();
            ResourceNamespace.Resolver itemResolver = namespaceResolvers.get(stream.readInt());
            StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(namespace, attrName, value, libraryName);
            styleItem.setNamespaceResolver(itemResolver);
            styleItems.add((StyleItemResourceValue)styleItem);
        }
        BasicStyleResourceItem item = new BasicStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

