/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.aar.AarResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAarResourceRepository
extends AbstractResourceRepository
implements AarResourceRepository {
    @NotNull
    protected final ResourceNamespace myNamespace;
    @NotNull
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    @NotNull
    private final Map<ResourceType, Set<ResourceItem>> myPublicResources = new EnumMap<ResourceType, Set<ResourceItem>>(ResourceType.class);
    @Nullable
    protected final String myLibraryName;

    AbstractAarResourceRepository(@NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
    }

    @NotNull
    protected final ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return ImmutableListMultimap.of();
        }
        return this.myResources.getOrDefault(resourceType, (ListMultimap<String, ResourceItem>)ImmutableListMultimap.of());
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
        return this.myResources.computeIfAbsent(resourceType, type -> ArrayListMultimap.create());
    }

    protected final void addResourceItem(@NotNull ResourceItem item) {
        ListMultimap<String, ResourceItem> multimap = this.getOrCreateMap(item.getType());
        multimap.put((Object)item.getName(), (Object)item);
    }

    protected final void populatePublicResourcesMap() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            ResourceType resourceType = entry.getKey();
            ImmutableSet.Builder setBuilder = null;
            ListMultimap<String, ResourceItem> items = entry.getValue();
            for (ResourceItem item : items.values()) {
                if (((ResourceItemWithVisibility)item).getVisibility() != ResourceVisibility.PUBLIC) continue;
                if (setBuilder == null) {
                    setBuilder = ImmutableSet.builder();
                }
                setBuilder.add((Object)item);
            }
            this.myPublicResources.put(resourceType, (Set<ResourceItem>)(setBuilder == null ? ImmutableSet.of() : setBuilder.build()));
        }
    }

    protected void freezeResources() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            this.myResources.put(entry.getKey(), (ListMultimap<String, ResourceItem>)ImmutableListMultimap.copyOf((Multimap)((Multimap)entry.getValue())));
        }
    }

    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace) && AbstractResourceRepository.acceptByResources(this.myResources, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
            return ResourceVisitor.VisitResult.ABORT;
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @NotNull
    public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        ListMultimap<String, ResourceItem> map = this.getResourcesInternal(namespace, resourceType);
        List items = map.get((Object)resourceName);
        return items == null ? ImmutableList.of() : items;
    }

    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        return this.getResourcesInternal(namespace, resourceType);
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return Collections.emptySet();
        }
        Set<ResourceItem> resourceItems = this.myPublicResources.get(type);
        return resourceItems == null ? Collections.emptySet() : resourceItems;
    }

    @NotNull
    public final ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Override
    @Nullable
    public final String getLibraryName() {
        return this.myLibraryName;
    }

    @Override
    @NotNull
    public final String getDisplayName() {
        return this.myLibraryName == null ? "Android Framework" : this.myLibraryName;
    }

    @Override
    public final boolean containsUserDefinedResources() {
        return false;
    }
}

