/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0002J\u0006\u0010\n\u001a\u00020\u0001J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeV2Decoder;", "", "mBuf", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "hasRemaining", "", "readMap", "", "", "readObject", "readString", "", "Companion", "DecoderException", "android.sdktools.layoutinspector"})
public final class ViewNodeV2Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer mBuf;
    public static final byte SIG_BOOLEAN = 90;
    public static final byte SIG_BYTE = 66;
    public static final byte SIG_SHORT = 83;
    public static final byte SIG_INT = 73;
    public static final byte SIG_LONG = 74;
    public static final byte SIG_FLOAT = 70;
    public static final byte SIG_DOUBLE = 68;
    public static final byte SIG_STRING = 82;
    public static final byte SIG_MAP = 77;
    public static final short SIG_END_MAP = 0;

    public ViewNodeV2Decoder(@NotNull ByteBuffer mBuf) {
        Intrinsics.checkNotNullParameter((Object)mBuf, (String)"mBuf");
        this.mBuf = mBuf;
    }

    public final boolean hasRemaining() {
        return this.mBuf.hasRemaining();
    }

    @NotNull
    public final Object readObject() {
        Object object;
        byte sig = this.mBuf.get();
        byte by = sig;
        if (by == 90) {
            object = this.mBuf.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (by == 66) {
            object = this.mBuf.get();
        } else if (by == 83) {
            object = this.mBuf.getShort();
        } else if (by == 73) {
            object = this.mBuf.getInt();
        } else if (by == 74) {
            object = this.mBuf.getLong();
        } else if (by == 70) {
            object = Float.valueOf(this.mBuf.getFloat());
        } else if (by == 68) {
            object = this.mBuf.getDouble();
        } else if (by == 82) {
            object = this.readString();
        } else if (by == 77) {
            object = this.readMap();
        } else {
            throw new DecoderException(sig, this.mBuf.position() - 1);
        }
        Boolean bl = object;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"when (sig) {\n           \u20261\n            )\n        }");
        return bl;
    }

    private final String readString() {
        short len = this.mBuf.getShort();
        byte[] b = new byte[len];
        this.mBuf.get(b, 0, len);
        Charset charset = Charset.forName("utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"utf-8\")");
        boolean bl = false;
        return new String(b, charset);
    }

    private final Map<Short, Object> readMap() {
        HashMap m = new HashMap();
        while (true) {
            Object o;
            if (!((o = this.readObject()) instanceof Short)) {
                throw new DecoderException(Intrinsics.stringPlus((String)"Expected short key, got ", o.getClass()));
            }
            if (((Number)o).shortValue() == 0) break;
            Map map = m;
            Object object = o;
            Object object2 = this.readObject();
            boolean bl = false;
            map.put(object, object2);
        }
        return m;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeV2Decoder$DecoderException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "seen", "", "pos", "", "(BI)V", "msg", "", "(Ljava/lang/String;)V", "android.sdktools.layoutinspector"})
    public static final class DecoderException
    extends RuntimeException {
        public DecoderException(byte seen, int pos) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Unexpected byte %c seen at position %d";
            Object[] objectArray = new Object[]{Character.valueOf((char)seen), pos};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            super(string2);
        }

        public DecoderException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeV2Decoder$Companion;", "", "()V", "SIG_BOOLEAN", "", "SIG_BYTE", "SIG_DOUBLE", "SIG_END_MAP", "", "SIG_FLOAT", "SIG_INT", "SIG_LONG", "SIG_MAP", "SIG_SHORT", "SIG_STRING", "android.sdktools.layoutinspector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

