/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.layoutinspector.parser.DisplayInfoFactory;
import com.android.layoutinspector.parser.ViewNodeParser;
import com.android.layoutinspector.parser.ViewNodeV2Parser;
import com.android.layoutinspector.parser.ViewPropertyParser;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J,\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J \u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeParser;", "", "()V", "createViewNode", "Lcom/android/layoutinspector/model/ViewNode;", "parent", "data", "", "skippedProperties", "", "loadProperties", "", "node", "parse", "bytes", "", "version", "Lcom/android/layoutinspector/ProtocolVersion;", "parseV1ViewNode", "parseV2ViewNode", "MergeNewLineCollector", "android.sdktools.layoutinspector"})
public final class ViewNodeParser {
    @NotNull
    public static final ViewNodeParser INSTANCE = new ViewNodeParser();

    private ViewNodeParser() {
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes, @NotNull ProtocolVersion version2, @NotNull Collection<String> skippedProperties) throws IOException, StringIndexOutOfBoundsException {
        ViewNode viewNode;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)version2), (String)"version");
        Intrinsics.checkNotNullParameter(skippedProperties, (String)"skippedProperties");
        ProtocolVersion protocolVersion = version2;
        int n = WhenMappings.$EnumSwitchMapping$0[protocolVersion.ordinal()];
        switch (n) {
            case 1: {
                viewNode = INSTANCE.parseV1ViewNode(bytes, skippedProperties);
                break;
            }
            case 2: {
                viewNode = INSTANCE.parseV2ViewNode(bytes);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return viewNode;
    }

    public static /* synthetic */ ViewNode parse$default(byte[] byArray, ProtocolVersion protocolVersion, Collection collection, int n, Object object) throws IOException, StringIndexOutOfBoundsException {
        if ((n & 2) != 0) {
            protocolVersion = ProtocolVersion.Version1;
        }
        if ((n & 4) != 0) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList()");
            collection = list2;
        }
        return ViewNodeParser.parse(byArray, protocolVersion, collection);
    }

    private final ViewNode parseV2ViewNode(byte[] bytes) {
        return new ViewNodeV2Parser().parse(bytes);
    }

    private final ViewNode parseV1ViewNode(byte[] bytes, Collection<String> skippedProperties) {
        String line;
        ViewNode root = null;
        ViewNode lastNode = null;
        int lastWhitespaceCount = Integer.MIN_VALUE;
        Stack<ViewNode> stack = new Stack<ViewNode>();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
        Object object = ((List)input.lines().collect(MergeNewLineCollector.INSTANCE)).iterator();
        while (object.hasNext() && !StringsKt.equals((String)"DONE.", (String)(line = (String)object.next()), (boolean)true)) {
            int count;
            int n;
            int whitespaceCount = 0;
            while (line.charAt(whitespaceCount) == ' ') {
                int n2 = whitespaceCount;
                whitespaceCount = n2 + 1;
            }
            if (lastWhitespaceCount < whitespaceCount) {
                stack.push(lastNode);
            } else if (!stack.isEmpty() && (n = 0) < (count = lastWhitespaceCount - whitespaceCount)) {
                do {
                    int i = n++;
                    stack.pop();
                } while (n < count);
            }
            lastWhitespaceCount = whitespaceCount;
            ViewNode parent = null;
            if (!stack.isEmpty()) {
                parent = (ViewNode)stack.peek();
            }
            String string = line;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            lastNode = this.createViewNode(parent, ((Object)StringsKt.trim((CharSequence)string2)).toString(), skippedProperties);
            if (root != null) continue;
            root = lastNode;
        }
        object = root;
        if (object != null) {
            ((ViewNode)object).updateNodeDrawn(true);
        }
        return root;
    }

    private final ViewNode createViewNode(ViewNode parent, String data, Collection<String> skippedProperties) {
        boolean bl;
        String[] data2 = data;
        int delimIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)data2), (char)'@', (int)0, (boolean)false, (int)6, null);
        if (delimIndex < 0) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid format for ViewNode, missing @: ", (Object)data2));
        }
        String[] stringArray = data2;
        int n = 0;
        int n2 = 0;
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = stringArray.substring(n, delimIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String name = string;
        stringArray = data2;
        n = delimIndex + 1;
        n2 = 0;
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = stringArray.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        data2 = string2;
        delimIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)data2), (char)' ', (int)0, (boolean)false, (int)6, null);
        String[] stringArray2 = data2;
        n2 = 0;
        int n3 = 0;
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = stringArray2.substring(n2, delimIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String hash = string3;
        ViewNode node = new ViewNode(parent, name, hash);
        node.setIndex(parent == null ? 0 : parent.getChildren().size());
        if (data2.length() > delimIndex + 1) {
            String[] stringArray3 = data2;
            n3 = delimIndex + 1;
            bl = false;
            if (stringArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = stringArray3.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            this.loadProperties(node, string4, skippedProperties);
            stringArray3 = new String[]{"id"};
            ViewProperty viewProperty = node.getProperty("mID", stringArray3);
            Intrinsics.checkNotNull((Object)viewProperty);
            node.setId(viewProperty.getValue());
        }
        node.setDisplayInfo(DisplayInfoFactory.INSTANCE.createDisplayInfoFromNode(node));
        ViewNode viewNode = parent;
        if (viewNode != null) {
            ViewNode viewNode2 = viewNode;
            bl = false;
            boolean bl2 = false;
            ViewNode it = viewNode2;
            boolean bl3 = false;
            it.getChildren().add(node);
        }
        return node;
    }

    private final void loadProperties(ViewNode node, String data, Collection<String> skippedProperties) {
        int start2 = 0;
        boolean stop = false;
        do {
            String fullName;
            int index = StringsKt.indexOf$default((CharSequence)data, (char)'=', (int)start2, (boolean)false, (int)4, null);
            String string = data;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(start2, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int index2 = StringsKt.indexOf$default((CharSequence)data, (char)',', (int)(index + 1), (boolean)false, (int)4, null);
            String string3 = data;
            int n = index + 1;
            int n2 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int length = Integer.parseInt(string5);
            start2 = index2 + 1 + length;
            if (!skippedProperties.contains(fullName)) {
                String value;
                String string6 = data;
                n2 = index2 + 1;
                int n3 = index2 + 1 + length;
                boolean bl2 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string7.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ViewProperty property = ViewPropertyParser.INSTANCE.parse(fullName, value);
                node.getProperties().add(property);
                Map<String, ViewProperty> map = node.getNamedProperties();
                String string8 = property.getFullName();
                bl2 = false;
                map.put(string8, property);
                node.addPropertyToGroup(property);
            }
            boolean bl3 = stop = start2 >= data.length();
            if (stop) continue;
            ++start2;
        } while (!stop);
        CollectionsKt.sort(node.getProperties());
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes, @NotNull ProtocolVersion version2) throws IOException, StringIndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)((Object)version2), (String)"version");
        return ViewNodeParser.parse$default(bytes, version2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes) throws IOException, StringIndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ViewNodeParser.parse$default(bytes, null, null, 6, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\fH\u0016J \u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeParser$MergeNewLineCollector;", "Ljava/util/stream/Collector;", "", "", "", "()V", "accumulator", "Ljava/util/function/BiConsumer;", "characteristics", "", "Ljava/util/stream/Collector$Characteristics;", "combiner", "Ljava/util/function/BinaryOperator;", "finisher", "Ljava/util/function/Function;", "supplier", "Ljava/util/function/Supplier;", "android.sdktools.layoutinspector"})
    private static final class MergeNewLineCollector
    implements Collector<String, List<String>, List<? extends String>> {
        @NotNull
        public static final MergeNewLineCollector INSTANCE = new MergeNewLineCollector();

        private MergeNewLineCollector() {
        }

        @Override
        @NotNull
        public Set<Collector.Characteristics> characteristics() {
            return SetsKt.setOf((Object)((Object)Collector.Characteristics.CONCURRENT));
        }

        @Override
        @NotNull
        public Supplier<List<String>> supplier() {
            return supplier.1.INSTANCE;
        }

        @Override
        @NotNull
        public Function<List<String>, List<String>> finisher() {
            return finisher.1.INSTANCE;
        }

        @Override
        @NotNull
        public BinaryOperator<List<String>> combiner() {
            return combiner.1.INSTANCE;
        }

        @Override
        @NotNull
        public BiConsumer<List<String>, String> accumulator() {
            return accumulator.1.INSTANCE;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtocolVersion.values().length];
            nArray[ProtocolVersion.Version1.ordinal()] = 1;
            nArray[ProtocolVersion.Version2.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

