/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/layoutinspector/parser/DisplayInfoFactory;", "", "()V", "createDisplayInfoFromNode", "Lcom/android/layoutinspector/model/DisplayInfo;", "node", "Lcom/android/layoutinspector/model/ViewNode;", "getBoolean", "", "p", "Lcom/android/layoutinspector/model/ViewProperty;", "defaultValue", "getFloat", "", "getInt", "", "android.sdktools.layoutinspector"})
public final class DisplayInfoFactory {
    @NotNull
    public static final DisplayInfoFactory INSTANCE = new DisplayInfoFactory();

    private DisplayInfoFactory() {
    }

    @NotNull
    public final DisplayInfo createDisplayInfoFromNode(@NotNull ViewNode node) {
        String contentDescription;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String[] stringArray = new String[]{"layout:mLeft", "left"};
        int left = this.getInt(node.getProperty("mLeft", stringArray), 0);
        String[] stringArray2 = new String[]{"layout:mTop", "top"};
        int top = this.getInt(node.getProperty("mTop", stringArray2), 0);
        String[] stringArray3 = new String[]{"layout:getWidth()", "width"};
        int width = this.getInt(node.getProperty("getWidth()", stringArray3), 10);
        String[] stringArray4 = new String[]{"layout:getHeight()", "height"};
        int height = this.getInt(node.getProperty("getHeight()", stringArray4), 10);
        String[] stringArray5 = new String[]{"scrolling:mScrollX", "scrollX"};
        int scrollX = this.getInt(node.getProperty("mScrollX", stringArray5), 0);
        String[] stringArray6 = new String[]{"scrolling:mScrollY", "scrollY"};
        int scrollY = this.getInt(node.getProperty("mScrollY", stringArray6), 0);
        String[] stringArray7 = new String[]{"drawing:willNotDraw()", "willNotDraw"};
        boolean willNotDraw = this.getBoolean(node.getProperty("willNotDraw()", stringArray7), false);
        String[] stringArray8 = new String[]{"drawing:getClipChildren()", "clipChildren"};
        boolean clipChildren = this.getBoolean(node.getProperty("getClipChildren()", stringArray8), true);
        String[] stringArray9 = new String[]{"drawing:getTranslationX()", "translationX"};
        float translateX = this.getFloat(node.getProperty("getTranslationX", stringArray9), 0.0f);
        String[] stringArray10 = new String[]{"drawing:getTranslationY()", "translationY"};
        float translateY = this.getFloat(node.getProperty("getTranslationY", stringArray10), 0.0f);
        String[] stringArray11 = new String[]{"drawing:getScaleX()", "scaleX"};
        float scaleX = this.getFloat(node.getProperty("getScaleX()", stringArray11), 1.0f);
        String[] stringArray12 = new String[]{"drawing:getScaleY()", "scaleY"};
        float scaleY = this.getFloat(node.getProperty("getScaleY()", stringArray12), 1.0f);
        String[] stringArray13 = new String[]{"contentDescription"};
        ViewProperty descProp = node.getProperty("accessibility:getContentDescription()", stringArray13);
        String string = contentDescription = descProp != null && !Intrinsics.areEqual((Object)descProp.getValue(), (Object)"null") ? descProp.getValue() : null;
        if (contentDescription == null) {
            descProp = node.getProperty("text:mText", new String[0]);
            contentDescription = descProp != null && !Intrinsics.areEqual((Object)descProp.getValue(), (Object)"null") ? descProp.getValue() : null;
        }
        String[] stringArray14 = new String[]{"misc:getVisibility()", "visibility"};
        ViewProperty visibility = node.getProperty("getVisibility()", stringArray14);
        boolean isVisible = visibility == null || Intrinsics.areEqual((Object)"0", (Object)visibility.getValue()) || Intrinsics.areEqual((Object)"VISIBLE", (Object)visibility.getValue());
        return new DisplayInfo(willNotDraw, isVisible, left, top, width, height, scrollX, scrollY, clipChildren, translateX, translateY, scaleX, scaleY, contentDescription);
    }

    private final boolean getBoolean(ViewProperty p, boolean defaultValue) {
        if (p != null) {
            boolean bl;
            try {
                bl = Boolean.parseBoolean(p.getValue());
            }
            catch (NumberFormatException e) {
                bl = defaultValue;
            }
            return bl;
        }
        return defaultValue;
    }

    private final int getInt(ViewProperty p, int defaultValue) {
        if (p != null) {
            int n;
            try {
                n = Integer.parseInt(p.getValue());
            }
            catch (NumberFormatException e) {
                n = defaultValue;
            }
            return n;
        }
        return defaultValue;
    }

    private final float getFloat(ViewProperty p, float defaultValue) {
        if (p != null) {
            float f;
            try {
                f = Float.parseFloat(p.getValue());
            }
            catch (NumberFormatException e) {
                f = defaultValue;
            }
            return f;
        }
        return defaultValue;
    }
}

