/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.SystemNanoTimeProvider;
import com.android.adblib.utils.SystemNanoTime;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/utils/TimeoutTracker;", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "nanoTimeProvider", "Lcom/android/adblib/SystemNanoTimeProvider;", "timeUnit", "(Lcom/android/adblib/SystemNanoTimeProvider;JLjava/util/concurrent/TimeUnit;)V", "remainingMills", "getRemainingMills", "()J", "remainingNanos", "getRemainingNanos", "remainingTime", "getRemainingTime", "startNanos", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "elapsedNanos", "getElapsedTime", "throwIfElapsed", "", "toString", "", "Companion", "android.sdktools.adblib"})
public final class TimeoutTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemNanoTimeProvider nanoTimeProvider;
    private final long timeout;
    @NotNull
    private final TimeUnit timeUnit;
    private final long startNanos;
    @NotNull
    private static final TimeoutTracker INFINITE = new TimeoutTracker(Long.MAX_VALUE, TimeUnit.NANOSECONDS);

    public TimeoutTracker(@NotNull SystemNanoTimeProvider nanoTimeProvider, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)nanoTimeProvider, (String)"nanoTimeProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.nanoTimeProvider = nanoTimeProvider;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.startNanos = this.elapsedNanos(0L);
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public TimeoutTracker(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this(SystemNanoTime.Companion.getInstance(), timeout, unit);
    }

    public final long getRemainingTime() {
        return this.getRemainingTime(this.timeUnit);
    }

    public final long getRemainingMills() {
        return this.getRemainingTime(TimeUnit.MILLISECONDS);
    }

    public final long getRemainingNanos() {
        return this.timeUnit.toNanos(this.timeout) - this.elapsedNanos(this.startNanos);
    }

    public final long getRemainingTime(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.getRemainingNanos(), TimeUnit.NANOSECONDS);
    }

    public final long getElapsedTime(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.elapsedNanos(this.startNanos), TimeUnit.NANOSECONDS);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%,.1f msec remaining, %,.1f msec elapsed";
        Object[] objectArray = new Object[]{(double)this.getRemainingTime(TimeUnit.MILLISECONDS), (double)this.getElapsedTime(TimeUnit.MILLISECONDS)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public final void throwIfElapsed() throws TimeoutException {
        if (this.getRemainingTime() < 0L) {
            throw new TimeoutException("Operation has timed out");
        }
    }

    private final long elapsedNanos(long startNanos) {
        return this.nanoTimeProvider.nanoTime() - startNanos;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/adblib/utils/TimeoutTracker$Companion;", "", "()V", "INFINITE", "Lcom/android/adblib/utils/TimeoutTracker;", "getINFINITE", "()Lcom/android/adblib/utils/TimeoutTracker;", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeoutTracker getINFINITE() {
            return INFINITE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

