/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/adblib/utils/AdbProtocolUtils;", "", "()V", "ADB_CHARSET", "Ljava/nio/charset/Charset;", "getADB_CHARSET", "()Ljava/nio/charset/Charset;", "ADB_NEW_LINE", "", "bufferToByteDumpString", "status", "Ljava/nio/ByteBuffer;", "byteBufferToString", "buffer", "convertFileTimeToEpochSeconds", "", "fileTime", "Ljava/nio/file/attribute/FileTime;", "copyBufferContents", "srcBuffer", "dstBuffer", "createDecoder", "Ljava/nio/charset/CharsetDecoder;", "is4Letters", "", "letters", "isData", "isDone", "isFail", "isOkay", "android.sdktools.adblib"})
public final class AdbProtocolUtils {
    @NotNull
    public static final AdbProtocolUtils INSTANCE = new AdbProtocolUtils();
    @NotNull
    private static final Charset ADB_CHARSET;
    @NotNull
    public static final String ADB_NEW_LINE = "\n";

    private AdbProtocolUtils() {
    }

    @NotNull
    public final Charset getADB_CHARSET() {
        return ADB_CHARSET;
    }

    public final boolean isOkay(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "OKAY");
    }

    public final boolean isFail(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "FAIL");
    }

    public final boolean isData(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DATA");
    }

    public final boolean isDone(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DONE");
    }

    private final boolean is4Letters(ByteBuffer buffer, String letters) {
        if (buffer.remaining() < letters.length()) {
            return false;
        }
        return buffer.get(0 + buffer.position()) == (byte)letters.charAt(0) && buffer.get(1 + buffer.position()) == (byte)letters.charAt(1) && buffer.get(2 + buffer.position()) == (byte)letters.charAt(2) && buffer.get(3 + buffer.position()) == (byte)letters.charAt(3);
    }

    @NotNull
    public final String byteBufferToString(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position = buffer.position();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        buffer.position(position);
        Charset charset = ADB_CHARSET;
        boolean bl = false;
        return new String(bytes, charset);
    }

    @NotNull
    public final String bufferToByteDumpString(@NotNull ByteBuffer status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int maxCount = 16;
        int position = status.position();
        int n = 0;
        int n2 = status.remaining();
        boolean bl = false;
        int n3 = Math.min(n2, maxCount);
        if (n < n3) {
            do {
                int i = n++;
                byte statusByte = status.get(i + position);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%02X";
                Object[] objectArray = new Object[]{statusByte};
                boolean bl2 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                sb1.append(string2);
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = "%c";
                objectArray = new Object[]{Character.valueOf((char)statusByte)};
                bl2 = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                sb2.append(string3);
            } while (n < n3);
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "0x%s (\"%s\")";
        Object[] objectArray = new Object[]{sb1, sb2};
        bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    @NotNull
    public final CharsetDecoder createDecoder() {
        CharsetDecoder charsetDecoder = ADB_CHARSET.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"ADB_CHARSET.newDecoder()");
        return charsetDecoder;
    }

    /*
     * WARNING - void declaration
     */
    public final int copyBufferContents(@NotNull ByteBuffer srcBuffer, @NotNull ByteBuffer dstBuffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)srcBuffer, (String)"srcBuffer");
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        if (dstBuffer.remaining() > srcBuffer.remaining()) {
            int count = srcBuffer.remaining();
            dstBuffer.put(srcBuffer);
            n = count;
        } else {
            void var3_4;
            int count = dstBuffer.remaining();
            if (count > 0) {
                int savedLimit = srcBuffer.limit();
                srcBuffer.limit(srcBuffer.position() + count);
                dstBuffer.put(srcBuffer);
                srcBuffer.limit(savedLimit);
            }
            n = var3_4;
        }
        return n;
    }

    public final int convertFileTimeToEpochSeconds(@NotNull FileTime fileTime) {
        Intrinsics.checkNotNullParameter((Object)fileTime, (String)"fileTime");
        return (int)(fileTime.toMillis() / (long)1000);
    }

    static {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        ADB_CHARSET = charset;
    }
}

