/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.utils.AdbProtocolUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000fJ,\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000fH\u0002J\u001c\u0010\u0012\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/adblib/utils/AdbBufferDecoder;", "", "bufferCapacity", "", "(I)V", "charBuffer", "Ljava/nio/CharBuffer;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "leftoverBuffer", "Ljava/nio/ByteBuffer;", "decodeBuffer", "", "buffer", "processor", "Lkotlin/Function1;", "decodeLeftoverBuffer", "leftovers", "flushCharBuffer", "android.sdktools.adblib"})
public final class AdbBufferDecoder {
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final CharBuffer charBuffer;
    @Nullable
    private ByteBuffer leftoverBuffer;

    public AdbBufferDecoder(int bufferCapacity) {
        Object object = AdbProtocolUtils.INSTANCE.createDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AdbProtocolUtils.createD\u2026        .replaceWith(\"?\")");
        this.decoder = object;
        object = CharBuffer.allocate(bufferCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocate(bufferCapacity)");
        this.charBuffer = object;
    }

    public /* synthetic */ AdbBufferDecoder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 256;
        }
        this(n);
    }

    public final void decodeBuffer(@NotNull ByteBuffer buffer, @NotNull Function1<? super CharBuffer, Unit> processor) {
        CoderResult result;
        boolean bl;
        boolean bl2;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ByteBuffer byteBuffer2 = this.leftoverBuffer;
        if (byteBuffer2 != null) {
            byteBuffer = byteBuffer2;
            bl2 = false;
            bl = false;
            ByteBuffer $this$decodeBuffer_u24lambda_u2d0 = byteBuffer;
            boolean bl3 = false;
            this.decodeLeftoverBuffer($this$decodeBuffer_u24lambda_u2d0, buffer, processor);
        }
        while (true) {
            result = this.decoder.decode(buffer, this.charBuffer, false);
            if (result.isMalformed() || result.isUnmappable()) continue;
            if (!result.isOverflow()) break;
            this.flushCharBuffer(processor);
        }
        if (result.isUnderflow()) {
            this.flushCharBuffer(processor);
            if (buffer.hasRemaining()) {
                this.leftoverBuffer = ByteBuffer.allocate(10);
                byteBuffer = this.leftoverBuffer;
                if (byteBuffer != null) {
                    byteBuffer.put(buffer);
                }
                boolean bl4 = !buffer.hasRemaining();
                bl2 = false;
                bl = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private final void decodeLeftoverBuffer(ByteBuffer leftovers, ByteBuffer buffer, Function1<? super CharBuffer, Unit> processor) {
        if (leftovers.position() == 0) {
            return;
        }
        this.flushCharBuffer(processor);
        while (buffer.hasRemaining()) {
            boolean bl;
            leftovers.put(buffer.get());
            int count = leftovers.position();
            leftovers.flip();
            CoderResult result = this.decoder.decode(leftovers, this.charBuffer, false);
            if (result.isMalformed()) {
                bl = true;
            } else if (result.isUnmappable()) {
                bl = true;
            } else {
                if (result.isOverflow()) {
                    throw new IllegalStateException();
                }
                if (result.isUnderflow()) {
                    bl = !leftovers.hasRemaining();
                } else {
                    throw new IllegalStateException();
                }
            }
            boolean done = bl;
            if (done) {
                boolean bl2 = !leftovers.hasRemaining();
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                leftovers.clear();
                break;
            }
            leftovers.clear();
            leftovers.position(count);
        }
    }

    private final void flushCharBuffer(Function1<? super CharBuffer, Unit> processor) {
        if (this.charBuffer.position() > 0) {
            this.charBuffer.flip();
            processor.invoke((Object)this.charBuffer);
        }
        this.charBuffer.clear();
    }

    public AdbBufferDecoder() {
        this(0, 1, null);
    }
}

