/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl.channels;

import com.android.adblib.AdbLibHost;
import com.android.adblib.AdbLogger;
import com.android.adblib.impl.channels.AdbSocketChannelImplKt;
import com.android.adblib.utils.TimeoutTracker;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0011\u0010\u0015\u001a\u00020\u0002H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0002J\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H$R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/impl/channels/AsynchronousChannelReadOperation;", "Ljava/nio/channels/CompletionHandler;", "", "Lkotlinx/coroutines/CancellableContinuation;", "host", "Lcom/android/adblib/AdbLibHost;", "timeout", "Lcom/android/adblib/utils/TimeoutTracker;", "(Lcom/android/adblib/AdbLibHost;Lcom/android/adblib/utils/TimeoutTracker;)V", "channel", "Ljava/nio/channels/Channel;", "getChannel", "()Ljava/nio/channels/Channel;", "getHost", "()Lcom/android/adblib/AdbLibHost;", "logger", "Lcom/android/adblib/AdbLogger;", "completed", "", "byteCount", "continuation", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failed", "exc", "", "readAsync", "readChannel", "android.sdktools.adblib"})
public abstract class AsynchronousChannelReadOperation
implements CompletionHandler<Integer, CancellableContinuation<? super Integer>> {
    @NotNull
    private final AdbLibHost host;
    @NotNull
    private final TimeoutTracker timeout;
    @NotNull
    private final AdbLogger logger;

    public AsynchronousChannelReadOperation(@NotNull AdbLibHost host, @NotNull TimeoutTracker timeout) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.host = host;
        this.timeout = timeout;
        AsynchronousChannelReadOperation asynchronousChannelReadOperation = this;
        AdbLibHost host$iv = this.host;
        boolean $i$f$thisLogger = false;
        this.logger = host$iv.getLoggerFactory().createLogger(AsynchronousChannelReadOperation.class);
    }

    @NotNull
    protected final AdbLibHost getHost() {
        return this.host;
    }

    @NotNull
    protected abstract Channel getChannel();

    protected abstract void readChannel(@NotNull TimeoutTracker var1, @NotNull CancellableContinuation<? super Integer> var2);

    @Nullable
    public final Object execute(@NotNull Continuation<? super Integer> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Integer> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        AdbSocketChannelImplKt.closeOnCancel(this.getChannel(), this.getHost(), "read", continuation);
        this.readAsync((CancellableContinuation<? super Integer>)continuation);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void readAsync(CancellableContinuation<? super Integer> continuation) {
        try {
            this.timeout.throwIfElapsed();
            this.readChannel(this.timeout, continuation);
        }
        catch (Throwable t) {
            Continuation continuation2 = (Continuation)continuation;
            boolean bl = false;
            Result.Companion companion = Result.Companion;
            boolean bl2 = false;
            continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void completed(int byteCount, @NotNull CancellableContinuation<? super Integer> continuation) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        AdbLogger this_$iv = this.logger;
        boolean $i$f$verbose = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var9_11 = this_$iv$iv;
            boolean bl = false;
            String string = "readAsync completed successfully (" + byteCount + " bytes)";
            var9_11.log(level, string);
        }
        Continuation continuation2 = (Continuation)continuation;
        Integer n = byteCount;
        boolean bl = false;
        Result.Companion companion = Result.Companion;
        boolean bl2 = false;
        continuation2.resumeWith(Result.constructor-impl((Object)n));
    }

    @Override
    public void failed(@NotNull Throwable exc, @NotNull CancellableContinuation<? super Integer> continuation) {
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        IOException error = new IOException("Error reading data from asynchronous channel", exc);
        Continuation continuation2 = (Continuation)continuation;
        boolean bl = false;
        Result.Companion companion = Result.Companion;
        boolean bl2 = false;
        continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
    }
}

