/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl.channels;

import com.android.adblib.AdbLibHost;
import com.android.adblib.AdbLogger;
import com.android.adblib.impl.channels.AdbSocketChannelImplKt;
import com.android.adblib.utils.TimeoutTracker;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0011\u0010\u0019\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010\u001e\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H$R\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/android/adblib/impl/channels/AsynchronousChannelReadExactlyOperation;", "Ljava/nio/channels/CompletionHandler;", "", "Lkotlinx/coroutines/CancellableContinuation;", "", "host", "Lcom/android/adblib/AdbLibHost;", "timeout", "Lcom/android/adblib/utils/TimeoutTracker;", "(Lcom/android/adblib/AdbLibHost;Lcom/android/adblib/utils/TimeoutTracker;)V", "channel", "Ljava/nio/channels/Channel;", "getChannel", "()Ljava/nio/channels/Channel;", "hasRemaining", "", "getHasRemaining", "()Z", "getHost", "()Lcom/android/adblib/AdbLibHost;", "logger", "Lcom/android/adblib/AdbLogger;", "completed", "result", "continuation", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failed", "exc", "", "readAsync", "readChannel", "android.sdktools.adblib"})
public abstract class AsynchronousChannelReadExactlyOperation
implements CompletionHandler<Integer, CancellableContinuation<? super Unit>> {
    @NotNull
    private final AdbLibHost host;
    @NotNull
    private final TimeoutTracker timeout;
    @NotNull
    private final AdbLogger logger;

    public AsynchronousChannelReadExactlyOperation(@NotNull AdbLibHost host, @NotNull TimeoutTracker timeout) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.host = host;
        this.timeout = timeout;
        AsynchronousChannelReadExactlyOperation asynchronousChannelReadExactlyOperation = this;
        AdbLibHost host$iv = this.host;
        boolean $i$f$thisLogger = false;
        this.logger = host$iv.getLoggerFactory().createLogger(AsynchronousChannelReadExactlyOperation.class);
    }

    @NotNull
    protected final AdbLibHost getHost() {
        return this.host;
    }

    protected abstract boolean getHasRemaining();

    @NotNull
    protected abstract Channel getChannel();

    protected abstract void readChannel(@NotNull TimeoutTracker var1, @NotNull CancellableContinuation<? super Unit> var2);

    @Nullable
    public final Object execute(@NotNull Continuation<? super Unit> $completion) {
        if (!this.getHasRemaining()) {
            return Unit.INSTANCE;
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        AdbSocketChannelImplKt.closeOnCancel(this.getChannel(), this.getHost(), "readExactly", continuation);
        this.readAsync((CancellableContinuation<? super Unit>)continuation);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void readAsync(CancellableContinuation<? super Unit> continuation) {
        try {
            this.timeout.throwIfElapsed();
            this.readChannel(this.timeout, continuation);
        }
        catch (Throwable t) {
            Continuation continuation2 = (Continuation)continuation;
            boolean bl = false;
            Result.Companion companion = Result.Companion;
            boolean bl2 = false;
            continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void completed(int result, @NotNull CancellableContinuation<? super Unit> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        if (result == -1) {
            void this_$iv$iv22;
            boolean bl = this.getHasRemaining();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AsynchronousChannelReadExactlyOperation$completed$22 = false;
                String $i$a$-assert-AsynchronousChannelReadExactlyOperation$completed$22 = "We should not have started a read if the buffer was already full";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AsynchronousChannelReadExactlyOperation$completed$22));
            }
            AdbLogger this_$iv = this.logger;
            boolean $i$f$verbose22 = false;
            AdbLogger $i$a$-assert-AsynchronousChannelReadExactlyOperation$completed$22 = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
            boolean $i$f$logIf = false;
            if (this_$iv$iv22.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var9_22 = this_$iv$iv22;
                boolean bl3 = false;
                String string = "Reached EOF";
                var9_22.log(level, string);
            }
            this_$iv = (Continuation)continuation;
            Throwable $i$f$verbose22 = new EOFException("Unexpected end of asynchronous channel");
            boolean this_$iv$iv22 = false;
            level$iv$iv = Result.Companion;
            $i$f$logIf = false;
            this_$iv.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$verbose22)));
            return;
        }
        AdbLogger this_$iv = this.logger;
        boolean $i$f$verbose = false;
        AdbLogger this_$iv$iv22 = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
        boolean $i$f$logIf = false;
        if (this_$iv$iv22.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            AdbLogger adbLogger = this_$iv$iv22;
            boolean bl = false;
            String string = "readAsync completed successfully (" + result + " bytes)";
            adbLogger.log(level, string);
        }
        if (!this.getHasRemaining()) {
            Continuation continuation2 = (Continuation)continuation;
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            continuation2.resumeWith(Result.constructor-impl((Object)unit));
            return;
        }
        this.readAsync(continuation);
    }

    @Override
    public void failed(@NotNull Throwable exc, @NotNull CancellableContinuation<? super Unit> continuation) {
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        IOException error = new IOException("Error reading data from asynchronous channel", exc);
        Continuation continuation2 = (Continuation)continuation;
        boolean bl = false;
        Result.Companion companion = Result.Companion;
        boolean bl2 = false;
        continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
    }
}

