/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.DeviceAddress;
import com.android.adblib.DeviceErrorInfo;
import com.android.adblib.MdnsServiceInfo;
import com.android.adblib.MdnsServiceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/adblib/impl/MdnsServiceListParser;", "", "()V", "lineRegex", "Lkotlin/text/Regex;", "parse", "Lcom/android/adblib/MdnsServiceList;", "text", "", "android.sdktools.adblib"})
public final class MdnsServiceListParser {
    @NotNull
    private final Regex lineRegex = new Regex("([^\t]+)\\t([^\t]+)\\t([^\t]+)");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MdnsServiceList parse(@NotNull CharSequence text) {
        void $this$forEachIndexed$iv;
        String it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ArrayList<MdnsServiceInfo> services = new ArrayList<MdnsServiceInfo>();
        ArrayList<DeviceErrorInfo> errors = new ArrayList<DeviceErrorInfo>();
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (String)item$iv;
            int lineIndex = n;
            boolean bl4 = false;
            MatchResult matchResult = Regex.find$default((Regex)this.lineRegex, (CharSequence)((CharSequence)line), (int)0, (int)2, null);
            if (matchResult == null) {
                DeviceErrorInfo error = new DeviceErrorInfo("mDNS service entry format not recognized", lineIndex, (String)line);
                errors.add(error);
                continue;
            }
            try {
                String instanceName = (String)matchResult.getGroupValues().get(1);
                String serviceName = (String)matchResult.getGroupValues().get(2);
                DeviceAddress deviceAddress = new DeviceAddress((String)matchResult.getGroupValues().get(3));
                services.add(new MdnsServiceInfo(instanceName, serviceName, deviceAddress));
            }
            catch (Exception ignored) {
                DeviceErrorInfo error = new DeviceErrorInfo("mDNS service entry ignored due do invalid characters", lineIndex, (String)line);
                errors.add(error);
            }
        }
        return new MdnsServiceList((List<MdnsServiceInfo>)services, (List<DeviceErrorInfo>)errors);
    }
}

