/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbHostServices;
import com.android.adblib.DeviceErrorInfo;
import com.android.adblib.DeviceInfo;
import com.android.adblib.DeviceList;
import com.android.adblib.impl.DeviceListParserKt;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/impl/DeviceListParser;", "", "()V", "parse", "Lcom/android/adblib/DeviceList;", "format", "Lcom/android/adblib/AdbHostServices$DeviceInfoFormat;", "responseText", "", "parseOneLongFormatLine", "", "result", "Lcom/android/adblib/impl/DeviceListParser$ParseResult;", "lineIndex", "", "lineText", "parseOneShortFormatLine", "parserWorker", "oneLineParser", "Lcom/android/adblib/impl/DeviceListParser$OneLineParser;", "OneLineParser", "ParseResult", "android.sdktools.adblib"})
public final class DeviceListParser {
    @NotNull
    public final DeviceList parse(@NotNull AdbHostServices.DeviceInfoFormat format, @NotNull CharSequence responseText) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)responseText, (String)"responseText");
        AdbHostServices.DeviceInfoFormat deviceInfoFormat = format;
        int n = WhenMappings.$EnumSwitchMapping$0[deviceInfoFormat.ordinal()];
        switch (n) {
            case 1: {
                kFunction = (KFunction)new Function3<ParseResult, Integer, CharSequence, Unit>((Object)this){

                    public final void invoke(@NotNull ParseResult p0, int p1, @NotNull CharSequence p2) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        DeviceListParser.access$parseOneShortFormatLine((DeviceListParser)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            case 2: {
                kFunction = (KFunction)new Function3<ParseResult, Integer, CharSequence, Unit>((Object)this){

                    public final void invoke(@NotNull ParseResult p0, int p1, @NotNull CharSequence p2) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        DeviceListParser.access$parseOneLongFormatLine((DeviceListParser)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KFunction oneLineParser2 = kFunction;
        return this.parserWorker(responseText, new OneLineParser((Function3)oneLineParser2){
            private final /* synthetic */ Function3 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void call(ParseResult result, int lineIndex, CharSequence lineText) {
                this.function.invoke((Object)result, (Object)lineIndex, (Object)lineText);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OneLineParser ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final DeviceList parserWorker(CharSequence responseText, OneLineParser oneLineParser2) {
        ParseResult result = new ParseResult(null, null, 3, null);
        CharSequence charSequence = responseText;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return result.toDeviceList();
        }
        Object object = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)responseText, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = lines.iterator();
        int n = 0;
        while (object.hasNext()) {
            int lineIndex = n++;
            String line = (String)object.next();
            CharSequence charSequence2 = line;
            boolean bl2 = false;
            if (!(charSequence2.length() > 0)) continue;
            oneLineParser2.call(result, lineIndex, line);
        }
        return result.toDeviceList();
    }

    private final void parseOneShortFormatLine(ParseResult result, int lineIndex, CharSequence lineText) {
        String deviceState;
        String serialNumber;
        block10: {
            block9: {
                Matcher matcher;
                block8: {
                    block7: {
                        matcher = DeviceListParserKt.access$getSHORT_LINE_PATTERN$p().matcher(lineText);
                        if (!matcher.matches()) {
                            result.addError("Device line format is not recognized", lineIndex, ((Object)lineText).toString());
                            return;
                        }
                        serialNumber = matcher.group(1);
                        if (serialNumber == null) break block7;
                        CharSequence charSequence = serialNumber;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block8;
                    }
                    result.addError("Device serial number is empty", lineIndex, lineText);
                    return;
                }
                deviceState = matcher.group(2);
                if (deviceState == null) break block9;
                CharSequence charSequence = deviceState;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block10;
            }
            result.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        result.addDevice(new DeviceInfo(serialNumber, deviceState, CollectionsKt.emptyList()));
    }

    private final void parseOneLongFormatLine(ParseResult result, int lineIndex, CharSequence lineText) {
        String deviceState;
        String serialNumber;
        block11: {
            block10: {
                Matcher matcher;
                block9: {
                    block8: {
                        matcher = DeviceListParserKt.access$getLONG_LINE_PATTERN$p().matcher(lineText);
                        if (!matcher.matches()) {
                            result.addError("Device line format is not recognized", lineIndex, lineText);
                            return;
                        }
                        serialNumber = matcher.group(1);
                        if (serialNumber == null) break block8;
                        CharSequence charSequence = serialNumber;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block9;
                    }
                    result.addError("Device serial number is empty", lineIndex, lineText);
                    return;
                }
                deviceState = matcher.group(2);
                if (deviceState == null) break block10;
                CharSequence charSequence = deviceState;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block11;
            }
            result.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        List moreFields = new ArrayList();
        Matcher matcherFields = DeviceListParserKt.access$getONE_FIELD_PATTERN$p().matcher(lineText);
        while (matcherFields.find()) {
            String name = matcherFields.group(1);
            String value = matcherFields.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            moreFields.add(new DeviceInfo.FieldEntry(name, value));
        }
        result.addDevice(new DeviceInfo(serialNumber, deviceState, moreFields));
    }

    public static final /* synthetic */ void access$parseOneShortFormatLine(DeviceListParser $this, ParseResult result, int lineIndex, CharSequence lineText) {
        $this.parseOneShortFormatLine(result, lineIndex, lineText);
    }

    public static final /* synthetic */ void access$parseOneLongFormatLine(DeviceListParser $this, ParseResult result, int lineIndex, CharSequence lineText) {
        $this.parseOneLongFormatLine(result, lineIndex, lineText);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/android/adblib/impl/DeviceListParser$OneLineParser;", "", "call", "", "result", "Lcom/android/adblib/impl/DeviceListParser$ParseResult;", "lineIndex", "", "lineText", "", "android.sdktools.adblib"})
    public static interface OneLineParser {
        public void call(@NotNull ParseResult var1, int var2, @NotNull CharSequence var3);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/adblib/impl/DeviceListParser$ParseResult;", "", "devices", "", "Lcom/android/adblib/DeviceInfo;", "errors", "Lcom/android/adblib/DeviceErrorInfo;", "(Ljava/util/List;Ljava/util/List;)V", "addDevice", "", "deviceInfo", "addError", "message", "", "lineIndex", "", "rawLineText", "", "toDeviceList", "Lcom/android/adblib/DeviceList;", "android.sdktools.adblib"})
    public static final class ParseResult {
        @NotNull
        private final List<DeviceInfo> devices;
        @NotNull
        private final List<DeviceErrorInfo> errors;

        public ParseResult(@NotNull List<DeviceInfo> devices2, @NotNull List<DeviceErrorInfo> errors) {
            Intrinsics.checkNotNullParameter(devices2, (String)"devices");
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            this.devices = devices2;
            this.errors = errors;
        }

        public /* synthetic */ ParseResult(List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = new ArrayList();
            }
            if ((n & 2) != 0) {
                list3 = new ArrayList();
            }
            this(list2, list3);
        }

        public final void addDevice(@NotNull DeviceInfo deviceInfo) {
            Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
            this.devices.add(deviceInfo);
        }

        public final void addError(@NotNull String message2, int lineIndex, @NotNull CharSequence rawLineText) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)rawLineText, (String)"rawLineText");
            this.errors.add(new DeviceErrorInfo(message2, lineIndex, ((Object)rawLineText).toString()));
        }

        @NotNull
        public final DeviceList toDeviceList() {
            return new DeviceList(this.devices, this.errors);
        }

        public ParseResult() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdbHostServices.DeviceInfoFormat.values().length];
            nArray[AdbHostServices.DeviceInfoFormat.SHORT_FORMAT.ordinal()] = 1;
            nArray[AdbHostServices.DeviceInfoFormat.LONG_FORMAT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

