/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.RemoteFileMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/RemoteFileMode;", "", "modeBits", "", "(I)V", "getModeBits", "()I", "posixPermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getPosixPermissions", "()Ljava/util/Set;", "posixString", "", "getPosixString", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "toString", "Companion", "android.sdktools.adblib"})
public final class RemoteFileMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int modeBits;
    @NotNull
    private static final Lazy<RemoteFileMode> DEFAULT$delegate = LazyKt.lazy((Function0)Companion.DEFAULT.2.INSTANCE);

    private RemoteFileMode(int modeBits) {
        this.modeBits = modeBits;
    }

    public final int getModeBits() {
        return this.modeBits;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RemoteFileMode && this.modeBits == ((RemoteFileMode)other).modeBits;
    }

    public int hashCode() {
        return Integer.hashCode(this.modeBits);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append((Object)this.getClass().getSimpleName()).append('(');
        int n = this.modeBits;
        int n2 = 8;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return stringBuilder.append(string).append(')').toString();
    }

    @NotNull
    public final String getPosixString() {
        String string = PosixFilePermissions.toString(this.getPosixPermissions());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(posixPermissions)");
        return string;
    }

    @NotNull
    public final Set<PosixFilePermission> getPosixPermissions() {
        return RemoteFileMode.Companion.modeBitsToPosixPermissions(this.modeBits);
    }

    public /* synthetic */ RemoteFileMode(int modeBits, DefaultConstructorMarker $constructor_marker) {
        this(modeBits);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u001f\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001d\u0010\u001c\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/android/adblib/RemoteFileMode$Companion;", "", "()V", "DEFAULT", "Lcom/android/adblib/RemoteFileMode;", "getDEFAULT", "()Lcom/android/adblib/RemoteFileMode;", "DEFAULT$delegate", "Lkotlin/Lazy;", "fromModeBits", "modeBits", "", "fromPath", "path", "Ljava/nio/file/Path;", "fromPosixPermissions", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "([Ljava/nio/file/attribute/PosixFilePermission;)Lcom/android/adblib/RemoteFileMode;", "", "fromPosixString", "value", "", "fromUnsupportedFileSystem", "fromUnsupportedFileSystem$android_sdktools_adblib", "modeBitFromPosixFilePermission", "permission", "modeBitsFromPosixPermissions", "posixPermissions", "([Ljava/nio/file/attribute/PosixFilePermission;)I", "modeBitsToPosixPermissions", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteFileMode getDEFAULT() {
            Lazy lazy = DEFAULT$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (RemoteFileMode)lazy.getValue();
        }

        @NotNull
        public final RemoteFileMode fromModeBits(int modeBits) {
            return new RemoteFileMode(modeBits, null);
        }

        @NotNull
        public final RemoteFileMode fromPosixPermissions(PosixFilePermission ... permissions) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return new RemoteFileMode(this.modeBitsFromPosixPermissions(permissions), null);
        }

        @NotNull
        public final RemoteFileMode fromPosixPermissions(@NotNull Set<? extends PosixFilePermission> permissions) {
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            Collection $this$toTypedArray$iv = permissions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PosixFilePermission[] posixFilePermissionArray = thisCollection$iv.toArray(new PosixFilePermission[0]);
            if (posixFilePermissionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PosixFilePermission[] posixFilePermissionArray2 = posixFilePermissionArray;
            return this.fromPosixPermissions(Arrays.copyOf(posixFilePermissionArray2, posixFilePermissionArray2.length));
        }

        @NotNull
        public final RemoteFileMode fromPosixString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(value);
            Intrinsics.checkNotNullExpressionValue(permissions, (String)"permissions");
            Collection $this$toTypedArray$iv = permissions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PosixFilePermission[] posixFilePermissionArray = thisCollection$iv.toArray(new PosixFilePermission[0]);
            if (posixFilePermissionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PosixFilePermission[] posixFilePermissionArray2 = posixFilePermissionArray;
            return this.fromPosixPermissions(Arrays.copyOf(posixFilePermissionArray2, posixFilePermissionArray2.length));
        }

        @Nullable
        public final RemoteFileMode fromPath(@NotNull Path path2) {
            RemoteFileMode remoteFileMode;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path2, new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue(permissions, (String)"permissions");
                remoteFileMode = this.fromPosixPermissions(permissions);
            }
            catch (UnsupportedOperationException e) {
                remoteFileMode = this.fromUnsupportedFileSystem$android_sdktools_adblib(path2);
            }
            catch (Exception e) {
                remoteFileMode = null;
            }
            return remoteFileMode;
        }

        @Nullable
        public final RemoteFileMode fromUnsupportedFileSystem$android_sdktools_adblib(@NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            try {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                if (Files.isReadable(path2)) {
                    permissions.add(PosixFilePermission.OWNER_READ);
                    permissions.add(PosixFilePermission.GROUP_READ);
                    permissions.add(PosixFilePermission.OTHERS_READ);
                }
                if (Files.isWritable(path2)) {
                    permissions.add(PosixFilePermission.OWNER_WRITE);
                }
                if (Files.isExecutable(path2)) {
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                    permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                return permissions.isEmpty() ? (RemoteFileMode)null : this.fromPosixPermissions((Set<? extends PosixFilePermission>)permissions);
            }
            catch (Exception e) {
                return null;
            }
        }

        private final int modeBitsFromPosixPermissions(PosixFilePermission[] posixPermissions) {
            int modeBits = 0;
            PosixFilePermission[] $this$forEach$iv = posixPermissions;
            boolean $i$f$forEach = false;
            PosixFilePermission[] posixFilePermissionArray = $this$forEach$iv;
            int n = posixFilePermissionArray.length;
            for (int i = 0; i < n; ++i) {
                PosixFilePermission element$iv;
                PosixFilePermission permission = element$iv = posixFilePermissionArray[i];
                boolean bl = false;
                modeBits |= Companion.modeBitFromPosixFilePermission(permission);
            }
            return modeBits;
        }

        private final Set<PosixFilePermission> modeBitsToPosixPermissions(int modeBits) {
            HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
            PosixFilePermission[] $this$forEach$iv = PosixFilePermission.values();
            boolean $i$f$forEach = false;
            PosixFilePermission[] posixFilePermissionArray = $this$forEach$iv;
            int n = posixFilePermissionArray.length;
            for (int i = 0; i < n; ++i) {
                PosixFilePermission element$iv;
                PosixFilePermission permission = element$iv = posixFilePermissionArray[i];
                boolean bl = false;
                if ((modeBits & Companion.modeBitFromPosixFilePermission(permission)) == 0) continue;
                result.add(permission);
            }
            return result;
        }

        private final int modeBitFromPosixFilePermission(PosixFilePermission permission) {
            int n;
            PosixFilePermission posixFilePermission = permission;
            int n2 = WhenMappings.$EnumSwitchMapping$0[posixFilePermission.ordinal()];
            switch (n2) {
                case 1: {
                    n = 256;
                    break;
                }
                case 2: {
                    n = 128;
                    break;
                }
                case 3: {
                    n = 64;
                    break;
                }
                case 4: {
                    n = 32;
                    break;
                }
                case 5: {
                    n = 16;
                    break;
                }
                case 6: {
                    n = 8;
                    break;
                }
                case 7: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 2;
                    break;
                }
                case 9: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PosixFilePermission.values().length];
                nArray[PosixFilePermission.OWNER_READ.ordinal()] = 1;
                nArray[PosixFilePermission.OWNER_WRITE.ordinal()] = 2;
                nArray[PosixFilePermission.OWNER_EXECUTE.ordinal()] = 3;
                nArray[PosixFilePermission.GROUP_READ.ordinal()] = 4;
                nArray[PosixFilePermission.GROUP_WRITE.ordinal()] = 5;
                nArray[PosixFilePermission.GROUP_EXECUTE.ordinal()] = 6;
                nArray[PosixFilePermission.OTHERS_READ.ordinal()] = 7;
                nArray[PosixFilePermission.OTHERS_WRITE.ordinal()] = 8;
                nArray[PosixFilePermission.OTHERS_EXECUTE.ordinal()] = 9;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

