/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.DeviceInfo;
import com.android.adblib.DeviceState;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/android/adblib/DeviceInfo;", "", "serialNumber", "", "rawDeviceStateString", "additionalFields", "", "Lcom/android/adblib/DeviceInfo$FieldEntry;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "device", "getDevice", "()Ljava/lang/String;", "deviceState", "Lcom/android/adblib/DeviceState;", "getDeviceState", "()Lcom/android/adblib/DeviceState;", "deviceStateString", "getDeviceStateString", "model", "getModel", "product", "getProduct", "getSerialNumber", "transportId", "getTransportId", "getAdditionalFieldValue", "fieldId", "Lcom/android/adblib/DeviceInfo$FieldId;", "toString", "FieldEntry", "FieldId", "android.sdktools.adblib"})
public final class DeviceInfo {
    @NotNull
    private final String serialNumber;
    @NotNull
    private final List<FieldEntry> additionalFields;
    @NotNull
    private final DeviceState deviceState;
    @NotNull
    private final String deviceStateString;

    public DeviceInfo(@NotNull String serialNumber, @NotNull String rawDeviceStateString, @NotNull List<FieldEntry> additionalFields) {
        String string;
        DeviceState state;
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)rawDeviceStateString, (String)"rawDeviceStateString");
        Intrinsics.checkNotNullParameter(additionalFields, (String)"additionalFields");
        this.serialNumber = serialNumber;
        this.additionalFields = additionalFields;
        DeviceState deviceState = state = DeviceState.Companion.parseStateOrNull(rawDeviceStateString);
        this.deviceState = deviceState == null ? DeviceState.UNKNOWN : deviceState;
        deviceState = state;
        this.deviceStateString = deviceState == null ? rawDeviceStateString : ((string = deviceState.toString()) == null ? rawDeviceStateString : string);
    }

    @NotNull
    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @Nullable
    public final String getTransportId() {
        return this.getAdditionalFieldValue(FieldId.TRANSPORT_ID);
    }

    @NotNull
    public final DeviceState getDeviceState() {
        return this.deviceState;
    }

    @NotNull
    public final String getDeviceStateString() {
        return this.deviceStateString;
    }

    @Nullable
    public final String getProduct() {
        return this.getAdditionalFieldValue(FieldId.PRODUCT);
    }

    @Nullable
    public final String getModel() {
        return this.getAdditionalFieldValue(FieldId.MODEL);
    }

    @Nullable
    public final String getDevice() {
        return this.getAdditionalFieldValue(FieldId.DEVICE);
    }

    private final String getAdditionalFieldValue(FieldId fieldId) {
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.additionalFields), (Function1)((Function1)new Function1<FieldEntry, Boolean>(fieldId){
            final /* synthetic */ FieldId $fieldId;
            {
                this.$fieldId = $fieldId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FieldEntry field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return Intrinsics.areEqual((Object)field.getName(), (Object)this.$fieldId.getText());
            }
        })), (Function1)getAdditionalFieldValue.2.INSTANCE));
    }

    @NotNull
    public String toString() {
        return "Device Serial=" + this.serialNumber + ", State=" + this.deviceStateString;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/DeviceInfo$FieldId;", "", "text", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "PRODUCT", "MODEL", "DEVICE", "TRANSPORT_ID", "android.sdktools.adblib"})
    public static final class FieldId
    extends Enum<FieldId> {
        @NotNull
        private final String text;
        public static final /* enum */ FieldId PRODUCT = new FieldId("product");
        public static final /* enum */ FieldId MODEL = new FieldId("model");
        public static final /* enum */ FieldId DEVICE = new FieldId("device");
        public static final /* enum */ FieldId TRANSPORT_ID = new FieldId("transport_id");
        private static final /* synthetic */ FieldId[] $VALUES;

        private FieldId(String text) {
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static FieldId[] values() {
            return (FieldId[])$VALUES.clone();
        }

        public static FieldId valueOf(String value) {
            return Enum.valueOf(FieldId.class, value);
        }

        static {
            $VALUES = fieldIdArray = new FieldId[]{FieldId.PRODUCT, FieldId.MODEL, FieldId.DEVICE, FieldId.TRANSPORT_ID};
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/adblib/DeviceInfo$FieldEntry;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.adblib"})
    public static final class FieldEntry {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        public FieldEntry(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final FieldEntry copy(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new FieldEntry(name, value);
        }

        public static /* synthetic */ FieldEntry copy$default(FieldEntry fieldEntry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldEntry.name;
            }
            if ((n & 2) != 0) {
                string2 = fieldEntry.value;
            }
            return fieldEntry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FieldEntry(name=" + this.name + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldEntry)) {
                return false;
            }
            FieldEntry fieldEntry = (FieldEntry)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)fieldEntry.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)fieldEntry.value);
        }
    }
}

