/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.AdbChannelFactory;
import com.android.adblib.AdbChannelProvider;
import com.android.adblib.AdbChannelProviderFactory;
import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbHostServices;
import com.android.adblib.AdbLibHost;
import com.android.adblib.AdbLogger;
import com.android.adblib.impl.AdbDeviceServicesImpl;
import com.android.adblib.impl.AdbHostServicesImpl;
import com.android.adblib.impl.channels.AdbChannelFactoryImpl;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002R\u0013\u0010\t\u001a\u00020\n8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/android/adblib/AdbLibSession;", "Ljava/lang/AutoCloseable;", "host", "Lcom/android/adblib/AdbLibHost;", "channelProvider", "Lcom/android/adblib/AdbChannelProvider;", "connectionTimeoutMillis", "", "(Lcom/android/adblib/AdbLibHost;Lcom/android/adblib/AdbChannelProvider;J)V", "channelFactory", "Lcom/android/adblib/AdbChannelFactory;", "getChannelFactory", "()Lcom/android/adblib/AdbChannelFactory;", "getChannelProvider", "()Lcom/android/adblib/AdbChannelProvider;", "closed", "", "getConnectionTimeoutMillis", "()J", "deviceServices", "Lcom/android/adblib/AdbDeviceServices;", "getDeviceServices", "()Lcom/android/adblib/AdbDeviceServices;", "getHost", "()Lcom/android/adblib/AdbLibHost;", "hostServices", "Lcom/android/adblib/AdbHostServices;", "getHostServices", "()Lcom/android/adblib/AdbHostServices;", "close", "", "createDeviceServices", "createHostServices", "throwIfClosed", "android.sdktools.adblib"})
public final class AdbLibSession
implements AutoCloseable {
    @NotNull
    private final AdbLibHost host;
    @NotNull
    private final AdbChannelProvider channelProvider;
    private final long connectionTimeoutMillis;
    private boolean closed;
    @NotNull
    private final AdbChannelFactory channelFactory;
    @NotNull
    private final AdbHostServices hostServices;
    @NotNull
    private final AdbDeviceServices deviceServices;

    public AdbLibSession(@NotNull AdbLibHost host, @NotNull AdbChannelProvider channelProvider2, long connectionTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)channelProvider2, (String)"channelProvider");
        this.host = host;
        this.channelProvider = channelProvider2;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.channelFactory = new AdbChannelFactoryImpl(this.host);
        this.hostServices = this.createHostServices();
        this.deviceServices = this.createDeviceServices();
    }

    public /* synthetic */ AdbLibSession(AdbLibHost adbLibHost, AdbChannelProvider adbChannelProvider, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            adbChannelProvider = AdbChannelProviderFactory.Companion.createOpenLocalHost$default(AdbChannelProviderFactory.Companion, adbLibHost, null, 2, null);
        }
        if ((n & 4) != 0) {
            l = TimeUnit.SECONDS.toMillis(30L);
        }
        this(adbLibHost, adbChannelProvider, l);
    }

    @NotNull
    public final AdbLibHost getHost() {
        return this.host;
    }

    @NotNull
    public final AdbChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @NotNull
    public final AdbChannelFactory getChannelFactory() {
        this.throwIfClosed();
        return this.channelFactory;
    }

    @NotNull
    public final AdbHostServices getHostServices() {
        this.throwIfClosed();
        return this.hostServices;
    }

    @NotNull
    public final AdbDeviceServices getDeviceServices() {
        this.throwIfClosed();
        return this.deviceServices;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void this_$iv$iv;
        AdbLogger this_$iv = this.host.getLogger();
        boolean $i$f$debug = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var7_7 = this_$iv$iv;
            boolean bl = false;
            String string = "Closing session";
            var7_7.log(level, string);
        }
        this.closed = true;
    }

    private final AdbHostServices createHostServices() {
        return new AdbHostServicesImpl(this.host, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private final AdbDeviceServices createDeviceServices() {
        return new AdbDeviceServicesImpl(this.host, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private final void throwIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Session has been closed");
        }
    }
}

