/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.utils.AdbProtocolUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/adblib/AdbFailResponseException;", "Ljava/io/IOException;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "failMessage", "", "(Ljava/lang/String;)V", "getFailMessage", "()Ljava/lang/String;", "message", "getMessage", "toString", "Companion", "android.sdktools.adblib"})
public final class AdbFailResponseException
extends IOException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String failMessage;

    public AdbFailResponseException(@NotNull String failMessage) {
        Intrinsics.checkNotNullParameter((Object)failMessage, (String)"failMessage");
        this.failMessage = failMessage;
    }

    @NotNull
    public final String getFailMessage() {
        return this.failMessage;
    }

    public AdbFailResponseException(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(AdbFailResponseException.Companion.extractMessageFromBuffer(buffer));
    }

    @Override
    @NotNull
    public String getMessage() {
        return Intrinsics.stringPlus((String)"ADB FAIL response: ", (Object)this.failMessage);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getMessage();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/adblib/AdbFailResponseException$Companion;", "", "()V", "extractMessageFromBuffer", "", "buffer", "Ljava/nio/ByteBuffer;", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        private final String extractMessageFromBuffer(ByteBuffer buffer) {
            String string;
            try {
                string = AdbProtocolUtils.INSTANCE.byteBufferToString(buffer);
            }
            catch (Exception e) {
                string = "Error retrieving FAIL message from ADB";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

