/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.intellij.plugins.xsltDebugger.rt.engine.local.OutputEventQueueImpl;

final class TracingOutputter
extends XMLEmitter {
    private final OutputEventQueueImpl myEventQueue;
    private final Emitter myEmitter;

    TracingOutputter(OutputEventQueueImpl queue, Emitter emitter) {
        this.myEmitter = emitter;
        this.myEventQueue = queue;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.myEmitter.setPipelineConfiguration(pipe);
    }

    public void setSystemId(String systemId) {
        this.myEmitter.setSystemId(systemId);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        this.myEmitter.setOutputProperties(details);
    }

    public void setStreamResult(StreamResult result) throws XPathException {
        this.myEmitter.setStreamResult(result);
    }

    public void setWriter(Writer writer) throws XPathException {
        this.myEmitter.setWriter(writer);
    }

    public void setOutputStream(OutputStream stream) throws XPathException {
        this.myEmitter.setOutputStream(stream);
    }

    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.myEmitter.setUnparsedEntity(name, uri, publicId);
    }

    public void open() throws XPathException {
        this.myEmitter.open();
    }

    public void startDocument(int properties) throws XPathException {
        this.myEmitter.startDocument(properties);
    }

    public void endDocument() throws XPathException {
        this.myEmitter.endDocument();
    }

    public void namespace(NamespaceBindingSet namespaceCode, int properties) throws XPathException {
        this.myEmitter.namespace(namespaceCode, properties);
    }

    public void close() throws XPathException {
        this.myEmitter.close();
    }

    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int properties) throws XPathException {
        if (this.myEventQueue.isEnabled()) {
            this.myEventQueue.startElement(nodeName.getPrefix(), nodeName.getLocalPart(), nodeName.getURI());
        }
        this.myEmitter.startElement(nodeName, schemaType, location, properties);
    }

    public void attribute(NodeName nodeName, SimpleType type, CharSequence value, Location location, int properties) throws XPathException {
        if (this.myEventQueue.isEnabled()) {
            this.myEventQueue.attribute(nodeName.getPrefix(), nodeName.getLocalPart(), nodeName.getURI(), value.toString());
        }
        this.myEmitter.attribute(nodeName, type, value, location, properties);
    }

    public void startContent() {
    }

    public void endElement() throws XPathException {
        this.myEventQueue.endElement();
        this.myEmitter.endElement();
    }

    public void characters(CharSequence chars, Location location, int properties) throws XPathException {
        this.myEventQueue.characters(chars.toString());
        this.myEmitter.characters(chars, location, properties);
    }

    public void processingInstruction(String name, CharSequence data, Location location, int properties) throws XPathException {
        this.myEventQueue.pi(name, data.toString());
        this.myEmitter.processingInstruction(name, data, location, properties);
    }

    public void comment(CharSequence content, Location location, int properties) throws XPathException {
        this.myEventQueue.comment(content.toString());
        this.myEmitter.comment(content, location, properties);
    }

    public boolean usesTypeAnnotations() {
        return false;
    }
}

