/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.ide.ApplicationLoadListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/settingsRepository/IcsApplicationLoadListener;", "Lcom/intellij/ide/ApplicationLoadListener;", "()V", "<set-?>", "Lorg/jetbrains/settingsRepository/IcsManager;", "icsManager", "getIcsManager", "()Lorg/jetbrains/settingsRepository/IcsManager;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "configPath", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public final class IcsApplicationLoadListener
implements ApplicationLoadListener {
    @Nullable
    private IcsManager icsManager;

    @Nullable
    public final IcsManager getIcsManager() {
        return this.icsManager;
    }

    public void beforeApplicationLoaded(@NotNull Application application, @NotNull Path configPath) {
        IcsManager icsManager2;
        Path pluginSystemDir;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        if (application.isUnitTestMode()) {
            return;
        }
        String customPath = System.getProperty("ics.settingsRepository");
        Path path = pluginSystemDir = customPath == null ? configPath.resolve("settingsRepository") : Path.of(FileUtil.expandUserHome((String)customPath), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginSystemDir");
        this.icsManager = icsManager2 = new IcsManager(path, (Disposable)application, null, 4, null);
        RepositoryManager repositoryManager = icsManager2.getRepositoryManager();
        if (repositoryManager.isRepositoryExists() && repositoryManager instanceof GitRepositoryManager) {
            String osFolderName = IcsUrlBuilderKt.getOsFolderName();
            boolean migrateSchemes = ((GitRepositoryManager)repositoryManager).renameDirectory(MapsKt.linkedMapOf((Pair[])new Pair[]{new Pair((Object)"$ROOT_CONFIG$", null), new Pair((Object)(osFolderName + "/$ROOT_CONFIG$"), (Object)osFolderName), new Pair((Object)"$APP_CONFIG$", null), new Pair((Object)(osFolderName + "/$APP_CONFIG$"), (Object)osFolderName)}), "Get rid of $ROOT_CONFIG$ and $APP_CONFIG");
            boolean migrateKeyMaps = ((GitRepositoryManager)repositoryManager).renameDirectory(MapsKt.linkedMapOf((Pair[])new Pair[]{new Pair((Object)(osFolderName + "/keymaps"), (Object)"keymaps")}), "Move keymaps to root");
            boolean removeOtherXml = repositoryManager.delete("other.xml");
            if (migrateSchemes || migrateKeyMaps || removeOtherXml) {
                application.invokeLater(new Runnable(icsManager2){
                    final /* synthetic */ IcsManager $icsManager;

                    public final void run() {
                        AutoSyncManager.autoSync$default(this.$icsManager.getAutoSyncManager$intellij_settingsRepository(), false, true, 1, null);
                    }
                    {
                        this.$icsManager = icsManager2;
                    }
                });
            }
        }
        icsManager2.beforeApplicationLoaded(application);
    }
}

