/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.extensions;

import com.intellij.idea.Bombed;
import com.intellij.testFramework.TestFrameworkUtil;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class BombExplodedExtension
implements BeforeEachCallback,
BeforeAllCallback,
ExecutionCondition {
    public void beforeEach(ExtensionContext context) {
        BombExplodedExtension.explodeBomb(context);
    }

    public void beforeAll(ExtensionContext context) {
        BombExplodedExtension.explodeBomb(context);
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), Bombed.class).map(bombed -> TestFrameworkUtil.bombExplodes(bombed) ? ConditionEvaluationResult.enabled((String)"Bomb exploded") : ConditionEvaluationResult.disabled((String)"Bomb not yet exploded")).orElse(ConditionEvaluationResult.enabled((String)"No bomb defined"));
    }

    private static void explodeBomb(ExtensionContext context) {
        AnnotationSupport.findAnnotation((Optional)context.getElement(), Bombed.class).ifPresent(bombed -> {
            if (TestFrameworkUtil.bombExplodes(bombed)) {
                String description = bombed.description().isEmpty() ? "" : " (" + bombed.description() + ")";
                Assertions.fail((String)("Bomb created by " + bombed.user() + description + " now explodes"));
            }
        });
    }
}

