/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class FormatterTestUtils {
    public static final Map<Action, TestFormatAction> ACTIONS = new EnumMap<Action, TestFormatAction>(Action.class);

    public static void testFormatting(@NotNull Project project2, @NotNull String ext, @NotNull String before2, @NotNull String after2, @NotNull Action action2) {
        if (project2 == null) {
            FormatterTestUtils.$$$reportNull$$$0(0);
        }
        if (ext == null) {
            FormatterTestUtils.$$$reportNull$$$0(1);
        }
        if (before2 == null) {
            FormatterTestUtils.$$$reportNull$$$0(2);
        }
        if (after2 == null) {
            FormatterTestUtils.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            FormatterTestUtils.$$$reportNull$$$0(4);
        }
        String fileName = "FTU." + ext;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        FormatData data = FormatterTestUtils.extractFormatData(before2);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, fileType, (CharSequence)data.text, System.currentTimeMillis(), true);
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
        Document document = manager.getDocument(file2);
        if (document == null) {
            throw new IllegalStateException("Document is null");
        }
        TestFormatAction formatAction = ACTIONS.get((Object)action2);
        if (formatAction == null) {
            throw new IllegalStateException("Format action is null");
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> formatAction.run(file2, data.startOffset, data.endOffset));
        Assert.assertEquals((Object)after2, (Object)document.getText());
    }

    private static FormatData extractFormatData(@NotNull String before2) {
        if (before2 == null) {
            FormatterTestUtils.$$$reportNull$$$0(5);
        }
        String SELECTION_START = "<selection>";
        String SELECTION_END = "<selection/>";
        int startOffset = before2.indexOf("<selection>");
        if (startOffset > 0) {
            int endOffset = before2.indexOf("<selection/>") - "<selection>".length();
            String text = before2.replace("<selection>", "").replace("<selection/>", "");
            return new FormatData(text, startOffset, endOffset);
        }
        return new FormatData(before2, 0, before2.length());
    }

    static {
        ACTIONS.put(Action.REFORMAT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatText(psiFile, startOffset, endOffset);
            }
        });
        ACTIONS.put(Action.INDENT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, startOffset);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList ranges = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, (Collection)ranges);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_INSERTED_LINE_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList ranges = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, new ChangedRangesInfo((List)ranges, (List)ranges));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatterTestUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testFormatting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFormatData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FormatData {
        public int startOffset;
        public int endOffset;
        public String text;

        public FormatData(String text, int startOffset, int endOffset) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    public static enum Action {
        REFORMAT,
        INDENT,
        REFORMAT_WITH_CONTEXT,
        REFORMAT_WITH_INSERTED_LINE_CONTEXT;

    }

    public static interface TestFormatAction {
        public void run(PsiFile var1, int var2, int var3);
    }
}

