/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.types;

import com.intellij.util.containers.BidirectionalMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class SMAPInfo {
    @NonNls
    private static final String SMAP_ID = "SMAP";
    @NonNls
    private static final String STRATUM_SECTION_PREFIX = "*S ";
    private final BufferedReader myReader;
    private String myOutputFileName;
    private String myDefaultStratum;
    private final Map<String, StratumInfo> myId2Stratum = new HashMap<String, StratumInfo>();
    @NonNls
    private static final String END_SECTION_HEADER = "*E";
    @NonNls
    private static final String FILE_SECTION_HEADER = "*F";
    @NonNls
    private static final String LINE_SECTION_HEADER = "*L";
    @NonNls
    private static final String OPEN_EMBEDDED_STRATUM_HEADER = "*O";
    @NonNls
    private static final String CLOSE_EMBEDDED_STRATUM_HEADER = "*C";
    private String myLastFileID;

    @Nullable
    public static SMAPInfo parse(Reader SMAPReader) {
        SMAPInfo smapInfo = new SMAPInfo(SMAPReader);
        try {
            smapInfo.doParse();
        }
        catch (Exception e) {
            return null;
        }
        if (smapInfo.myId2Stratum.isEmpty()) {
            return null;
        }
        return smapInfo;
    }

    private SMAPInfo(Reader SMAPReader) {
        this.myReader = new BufferedReader(SMAPReader);
    }

    private void doParse() throws IOException {
        String s = this.myReader.readLine();
        if (!SMAP_ID.equals(s)) {
            return;
        }
        this.myOutputFileName = this.myReader.readLine();
        this.myDefaultStratum = this.myReader.readLine();
        String sectionHeader = this.myReader.readLine();
        StratumInfo currentStratum = null;
        int level = 0;
        while (sectionHeader != null && !END_SECTION_HEADER.equals(sectionHeader)) {
            if (sectionHeader.startsWith(OPEN_EMBEDDED_STRATUM_HEADER)) {
                ++level;
            } else if (sectionHeader.startsWith(CLOSE_EMBEDDED_STRATUM_HEADER)) {
                --level;
            } else if (level == 0) {
                if (sectionHeader.startsWith(STRATUM_SECTION_PREFIX)) {
                    String stratumId = sectionHeader.substring(STRATUM_SECTION_PREFIX.length());
                    currentStratum = new StratumInfo(stratumId);
                    this.myId2Stratum.put(stratumId, currentStratum);
                } else {
                    if (sectionHeader.equals(FILE_SECTION_HEADER)) {
                        String fileInfo = this.myReader.readLine();
                        while (fileInfo != null && !fileInfo.startsWith("*")) {
                            this.parseFileInfo(currentStratum, fileInfo);
                            fileInfo = this.myReader.readLine();
                        }
                        sectionHeader = fileInfo;
                        continue;
                    }
                    if (sectionHeader.equals(LINE_SECTION_HEADER)) {
                        this.myLastFileID = "0";
                        String lineInfo = this.myReader.readLine();
                        while (lineInfo != null && !lineInfo.startsWith("*")) {
                            this.parseLineInfo(currentStratum, lineInfo);
                            lineInfo = this.myReader.readLine();
                        }
                        sectionHeader = lineInfo;
                        continue;
                    }
                }
            }
            sectionHeader = this.myReader.readLine();
        }
    }

    private void parseLineInfo(StratumInfo currentStratum, String lineInfo) {
        int increment;
        String fileId;
        int repeatCount;
        int colonIndex = lineInfo.indexOf(58);
        String inputInfo = lineInfo.substring(0, colonIndex);
        String outputInfo = lineInfo.substring(colonIndex + 1);
        int inputCommaIndex = inputInfo.indexOf(44);
        if (inputCommaIndex != -1) {
            repeatCount = Integer.parseInt(inputInfo.substring(inputCommaIndex + 1));
            inputInfo = inputInfo.substring(0, inputCommaIndex);
        } else {
            repeatCount = 1;
        }
        int sharpIndex = inputInfo.indexOf(35);
        if (sharpIndex != -1) {
            fileId = inputInfo.substring(sharpIndex + 1);
            inputInfo = inputInfo.substring(0, sharpIndex);
        } else {
            fileId = this.myLastFileID;
        }
        int inputStartLine = Integer.parseInt(inputInfo);
        int outputCommaIndex = outputInfo.indexOf(44);
        if (outputCommaIndex != -1) {
            increment = Integer.parseInt(outputInfo.substring(outputCommaIndex + 1));
            outputInfo = outputInfo.substring(0, outputCommaIndex);
        } else {
            increment = 1;
        }
        int outputStartLine = Integer.parseInt(outputInfo);
        FileInfo info = currentStratum.myFileId2Info.get(fileId);
        for (int i = 0; i < repeatCount; ++i) {
            for (int j = i * increment; j < (i + 1) * increment; ++j) {
                info.myOutput2InputLine.put((Object)(outputStartLine + j), (Object)(inputStartLine + i));
            }
        }
    }

    private void parseFileInfo(StratumInfo currentStratum, String fileInfo) throws IOException {
        String filePath = null;
        if (fileInfo.startsWith("+ ")) {
            fileInfo = fileInfo.substring(2);
            filePath = this.myReader.readLine();
        }
        int index = fileInfo.indexOf(32);
        String id = fileInfo.substring(0, index);
        String fileName = fileInfo.substring(index + 1);
        currentStratum.myFileId2Info.put(id, new FileInfo(fileName, filePath));
    }

    public String getOutputFileName() {
        return this.myOutputFileName;
    }

    public StratumInfo getStratum(@Nullable String id) {
        StratumInfo stratumInfo;
        if (id == null) {
            id = this.myDefaultStratum;
        }
        if ((stratumInfo = this.myId2Stratum.get(id)) == null) {
            stratumInfo = this.myId2Stratum.get(this.myDefaultStratum);
        }
        return stratumInfo;
    }

    public static class FileInfo {
        private final String myName;
        private final String myPath;
        private final BidirectionalMap<Integer, Integer> myOutput2InputLine = new BidirectionalMap();

        public FileInfo(String name, String path) {
            this.myName = name;
            this.myPath = path;
        }

        public String getName() {
            return this.myName;
        }

        public String getPath() {
            return this.myPath;
        }

        public List<Integer> getOutputLines(int inputLine) {
            return this.myOutput2InputLine.getKeysByValue((Object)inputLine);
        }

        public int getInputLine(int outputLine) {
            Integer line = (Integer)this.myOutput2InputLine.get((Object)outputLine);
            return line == null ? -1 : line;
        }
    }

    public static class StratumInfo {
        private final String myStratumId;
        private final Map<String, FileInfo> myFileId2Info = new HashMap<String, FileInfo>();

        public StratumInfo(String stratumId) {
            this.myStratumId = stratumId;
        }

        public String getStratumId() {
            return this.myStratumId;
        }

        public FileInfo[] getFileInfos() {
            Collection<FileInfo> infos = this.myFileId2Info.values();
            return infos.toArray(new FileInfo[0]);
        }
    }
}

