/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.members;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockTypeComponent;
import com.intellij.debugger.mockJDI.types.MockType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractMockMethod
extends MockTypeComponent
implements Method {
    public AbstractMockMethod(Member member, MockVirtualMachine virtualMachine) {
        super(member, virtualMachine);
    }

    @Override
    public String signature() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Type type : this.argumentTypes()) {
            builder.append(type.signature());
        }
        builder.append(')');
        builder.append(this.returnType().signature());
        return builder.toString();
    }

    @Override
    public String returnTypeName() {
        return this.returnType().name();
    }

    @Override
    public Type returnType() {
        return MockType.createType(this.myVirtualMachine, this.getReturnType());
    }

    protected abstract Class<?> getReturnType();

    @Override
    public List<String> argumentTypeNames() {
        return this.argumentTypes().stream().map(Type::name).collect(Collectors.toList());
    }

    @Override
    public List<Type> argumentTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Class<?> aClass : this.getParameterTypes()) {
            types.add(MockType.createType(this.myVirtualMachine, aClass));
        }
        return types;
    }

    protected abstract Class<?>[] getParameterTypes();

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.myMember.getModifiers());
    }

    @Override
    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.myMember.getModifiers());
    }

    @Override
    public boolean isNative() {
        return Modifier.isNative(this.myMember.getModifiers());
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isStaticInitializer() {
        return false;
    }

    @Override
    public boolean isObsolete() {
        return false;
    }

    @Override
    public List<Location> allLineLocations() {
        return new ArrayList<Location>();
    }

    @Override
    public List<Location> allLineLocations(String string, String string1) {
        return new ArrayList<Location>();
    }

    @Override
    public List<Location> locationsOfLine(int i) {
        return new ArrayList<Location>();
    }

    @Override
    public List<Location> locationsOfLine(String string, String string1, int i) {
        return new ArrayList<Location>();
    }

    @Override
    public Location locationOfCodeIndex(long l) {
        throw new UnsupportedOperationException("Not implemented: \"locationOfCodeIndex\" in " + this.getClass().getName());
    }

    @Override
    public List<LocalVariable> variables() {
        throw new UnsupportedOperationException("Not implemented: \"variables\" in " + this.getClass().getName());
    }

    @Override
    public List<LocalVariable> variablesByName(String string) {
        throw new UnsupportedOperationException("Not implemented: \"variablesByName\" in " + this.getClass().getName());
    }

    @Override
    public List<LocalVariable> arguments() {
        throw new UnsupportedOperationException("Not implemented: \"arguments\" in " + this.getClass().getName());
    }

    @Override
    public byte[] bytecodes() {
        throw new UnsupportedOperationException("Not implemented: \"bytecodes\" in " + this.getClass().getName());
    }

    @Override
    public Location location() {
        throw new UnsupportedOperationException("Not implemented: \"location\" in " + this.getClass().getName());
    }

    @Override
    public int compareTo(Method o) {
        throw new UnsupportedOperationException("Not implemented: \"compareTo\" in " + this.getClass().getName());
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public boolean isBridge() {
        return false;
    }
}

