/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI;

import com.intellij.debugger.mockJDI.types.MockArrayType;
import com.intellij.debugger.mockJDI.types.MockBooleanType;
import com.intellij.debugger.mockJDI.types.MockClassType;
import com.intellij.debugger.mockJDI.types.MockIntegerType;
import com.intellij.debugger.mockJDI.types.MockInterfaceType;
import com.intellij.debugger.mockJDI.types.MockLongType;
import com.intellij.debugger.mockJDI.types.MockPsiClassType;
import com.intellij.debugger.mockJDI.types.MockPsiInterfaceType;
import com.intellij.debugger.mockJDI.types.MockPsiReferenceType;
import com.intellij.debugger.mockJDI.types.MockReferenceType;
import com.intellij.debugger.mockJDI.types.MockShortType;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.types.MockVoidType;
import com.intellij.debugger.mockJDI.values.MockBooleanValue;
import com.intellij.debugger.mockJDI.values.MockIntegerValue;
import com.intellij.debugger.mockJDI.values.MockStringReference;
import com.intellij.debugger.mockJDI.values.MockThreadReference;
import com.intellij.debugger.mockJDI.values.MockVoidValue;
import com.intellij.psi.PsiClass;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class MockVirtualMachine
implements VirtualMachine {
    private final Map<Class<?>, MockReferenceType> myCachedClasses = new HashMap();
    private final Map<PsiClass, MockPsiReferenceType> myCachedPsiClasses = new HashMap<PsiClass, MockPsiReferenceType>();
    private final List<ReferenceType> myClasses = new ArrayList<ReferenceType>();
    private final MockType myBooleanType = new MockBooleanType(this);
    private final MockType myIntType = new MockIntegerType(this);
    private final MockType myLongType = new MockLongType(this);
    private final MockType myShortType = new MockShortType(this);
    private final MockType myVoidType = new MockVoidType(this);
    private final Map<Class, ClassReader> myClass2Reader = new HashMap<Class, ClassReader>();
    private final List<ThreadReference> myThreads = Collections.singletonList(new MockThreadReference(this, Thread.currentThread()));

    public void addClass(Class aClass, byte @Nullable [] bytes) {
        this.myClasses.add(this.createReferenceType(aClass));
        if (bytes != null) {
            this.myClass2Reader.put(aClass, new ClassReader(bytes));
        }
    }

    public ClassReader getReader(Class aClass) {
        return this.myClass2Reader.get(aClass);
    }

    @Override
    public List<ReferenceType> classesByName(String string) {
        ArrayList<ReferenceType> referenceTypes = new ArrayList<ReferenceType>();
        try {
            Class<?> aClass = Class.forName(string);
            referenceTypes.add(this.createReferenceType(aClass));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return referenceTypes;
    }

    @Override
    public VoidValue mirrorOfVoid() {
        return new MockVoidValue(this);
    }

    @Override
    public List<ReferenceType> allClasses() {
        return this.myClasses;
    }

    public void redefineClasses(Map map) {
        throw new UnsupportedOperationException("Not implemented: \"redefineClasses\" in " + this.getClass().getName());
    }

    @Override
    public List<ThreadReference> allThreads() {
        return this.myThreads;
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException("Not implemented: \"suspend\" in " + this.getClass().getName());
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException("Not implemented: \"resume\" in " + this.getClass().getName());
    }

    @Override
    public List<ThreadGroupReference> topLevelThreadGroups() {
        return Collections.emptyList();
    }

    @Override
    public EventQueue eventQueue() {
        throw new UnsupportedOperationException("Not implemented: \"eventQueue\" in " + this.getClass().getName());
    }

    @Override
    public EventRequestManager eventRequestManager() {
        throw new UnsupportedOperationException("Not implemented: \"eventRequestManager\" in " + this.getClass().getName());
    }

    @Override
    public BooleanValue mirrorOf(boolean b) {
        return new MockBooleanValue(this, b);
    }

    @Override
    public ByteValue mirrorOf(byte b) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public CharValue mirrorOf(char c) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public ShortValue mirrorOf(short i) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public IntegerValue mirrorOf(int i) {
        return new MockIntegerValue(this, i);
    }

    @Override
    public LongValue mirrorOf(long l) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public FloatValue mirrorOf(float v) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public DoubleValue mirrorOf(double v) {
        throw new UnsupportedOperationException("Not implemented: \"mirrorOf\" in " + this.getClass().getName());
    }

    @Override
    public StringReference mirrorOf(String string) {
        return new MockStringReference(this, string);
    }

    @Override
    public Process process() {
        throw new UnsupportedOperationException("Not implemented: \"process\" in " + this.getClass().getName());
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("Not implemented: \"dispose\" in " + this.getClass().getName());
    }

    @Override
    public void exit(int i) {
        throw new UnsupportedOperationException("Not implemented: \"exit\" in " + this.getClass().getName());
    }

    @Override
    public boolean canWatchFieldModification() {
        return false;
    }

    @Override
    public boolean canWatchFieldAccess() {
        throw new UnsupportedOperationException("Not implemented: \"canWatchFieldAccess\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetBytecodes() {
        throw new UnsupportedOperationException("Not implemented: \"canGetBytecodes\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetSyntheticAttribute() {
        throw new UnsupportedOperationException("Not implemented: \"canGetSyntheticAttribute\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetOwnedMonitorInfo() {
        throw new UnsupportedOperationException("Not implemented: \"canGetOwnedMonitorInfo\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetCurrentContendedMonitor() {
        throw new UnsupportedOperationException("Not implemented: \"canGetCurrentContendedMonitor\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetMonitorInfo() {
        throw new UnsupportedOperationException("Not implemented: \"canGetMonitorInfo\" in " + this.getClass().getName());
    }

    @Override
    public boolean canUseInstanceFilters() {
        throw new UnsupportedOperationException("Not implemented: \"canUseInstanceFilters\" in " + this.getClass().getName());
    }

    @Override
    public boolean canRedefineClasses() {
        return false;
    }

    @Override
    public boolean canAddMethod() {
        throw new UnsupportedOperationException("Not implemented: \"canAddMethod\" in " + this.getClass().getName());
    }

    @Override
    public boolean canUnrestrictedlyRedefineClasses() {
        throw new UnsupportedOperationException("Not implemented: \"canUnrestrictedlyRedefineClasses\" in " + this.getClass().getName());
    }

    @Override
    public boolean canPopFrames() {
        return false;
    }

    @Override
    public boolean canGetSourceDebugExtension() {
        throw new UnsupportedOperationException("Not implemented: \"canGetSourceDebugExtension\" in " + this.getClass().getName());
    }

    @Override
    public boolean canRequestVMDeathEvent() {
        throw new UnsupportedOperationException("Not implemented: \"canRequestVMDeathEvent\" in " + this.getClass().getName());
    }

    @Override
    public boolean canBeModified() {
        return true;
    }

    @Override
    public void setDefaultStratum(String string) {
        throw new UnsupportedOperationException("Not implemented: \"setDefaultStratum\" in " + this.getClass().getName());
    }

    @Override
    public String getDefaultStratum() {
        return null;
    }

    @Override
    public String description() {
        throw new UnsupportedOperationException("Not implemented: \"description\" in " + this.getClass().getName());
    }

    @Override
    public String version() {
        return "1.5";
    }

    @Override
    public String name() {
        return "MockVirtualMachine";
    }

    @Override
    public void setDebugTraceMode(int i) {
        throw new UnsupportedOperationException("Not implemented: \"setDebugTraceMode\" in " + this.getClass().getName());
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this;
    }

    public MockInterfaceType createInterfaceType(Class<?> type) {
        return (MockInterfaceType)this.createReferenceType(type);
    }

    public MockReferenceType createReferenceType(Class<?> type) {
        MockReferenceType refType = this.myCachedClasses.get(type);
        if (refType == null) {
            refType = type.isArray() ? new MockArrayType(MockType.createType(this, type.getComponentType())) : (type.isInterface() ? new MockInterfaceType(this, type) : new MockClassType(this, type));
            this.myCachedClasses.put(type, refType);
        }
        return refType;
    }

    public MockPsiReferenceType createReferenceType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MockVirtualMachine.$$$reportNull$$$0(0);
        }
        return this.myCachedPsiClasses.computeIfAbsent(psiClass, c -> c.isInterface() ? new MockPsiInterfaceType(this, (PsiClass)c) : new MockPsiClassType(this, (PsiClass)c));
    }

    public MockType getBooleanType() {
        return this.myBooleanType;
    }

    public MockType getIntType() {
        return this.myIntType;
    }

    public MockType getLongType() {
        return this.myLongType;
    }

    public MockType getShortType() {
        return this.myShortType;
    }

    @Override
    public boolean canGetMethodReturnValues() {
        throw new UnsupportedOperationException("Not implemented: \"canGetMethodReturnValues\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetInstanceInfo() {
        throw new UnsupportedOperationException("Not implemented: \"canGetInstanceInfo\" in " + this.getClass().getName());
    }

    @Override
    public boolean canUseSourceNameFilters() {
        throw new UnsupportedOperationException("Not implemented: \"canUseSourceNameFilters\" in " + this.getClass().getName());
    }

    @Override
    public boolean canForceEarlyReturn() {
        throw new UnsupportedOperationException("Not implemented: \"canForceEarlyReturn\" in " + this.getClass().getName());
    }

    @Override
    public boolean canRequestMonitorEvents() {
        throw new UnsupportedOperationException("Not implemented: \"canRequestMonitorEvents\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetMonitorFrameInfo() {
        throw new UnsupportedOperationException("Not implemented: \"canGetMonitorFrameInfo\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetClassFileVersion() {
        throw new UnsupportedOperationException("Not implemented: \"canGetClassFileVersion\" in " + this.getClass().getName());
    }

    @Override
    public boolean canGetConstantPool() {
        throw new UnsupportedOperationException("Not implemented: \"canGetConstantPool\" in " + this.getClass().getName());
    }

    @Override
    public long[] instanceCounts(List<? extends ReferenceType> list) {
        throw new UnsupportedOperationException("Not implemented: \"instanceCounts\" in " + this.getClass().getName());
    }

    public MockType getVoidType() {
        return this.myVoidType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/debugger/mockJDI/MockVirtualMachine", "createReferenceType"));
    }
}

