/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.editorActions.UnSelectWordHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class SelectWordTestBase
extends LightPlatformCodeInsightTestCase {
    protected void doTest(@NonNls String ext) {
        this.doTest(ext, true);
    }

    protected void doTest(@NonNls String ext, boolean unselect) {
        this.doTest(ext, unselect, false);
    }

    protected void doTest(@NonNls String ext, boolean unselect, boolean defaultFolding) {
        String fileName;
        @NonNls String path = "/codeInsight/selectWordAction/" + this.getTestName(true);
        this.configureByFile(path + "/before." + ext);
        if (defaultFolding) {
            CodeFoldingManager.getInstance((Project)this.getProject()).buildInitialFoldings(this.getEditor());
        }
        int i = 1;
        while (true) {
            fileName = "/after" + i + "." + ext;
            @NonNls String resultPath = path + fileName;
            if (!new File(this.getTestDataPath() + resultPath).exists()) break;
            SelectWordTestBase.getHandler().execute(this.getEditor(), null, (DataContext)DataManager.getInstance().getDataContextFromFocus().getResultSync());
            this.checkResultByFile(fileName, resultPath, true);
            ++i;
        }
        SelectWordTestBase.assertTrue((i > 1 ? 1 : 0) != 0);
        if (!unselect) {
            return;
        }
        --i;
        while (--i != 0) {
            fileName = "/after" + i + "." + ext;
            new UnSelectWordHandler(null).execute(this.getEditor(), null, (DataContext)DataManager.getInstance().getDataContextFromFocus().getResultSync());
            this.checkResultByFile(fileName, path + fileName, true);
        }
    }

    private static EditorActionHandler getHandler() {
        EditorAction action2 = (EditorAction)ActionManager.getInstance().getAction("EditorSelectWord");
        return action2.getHandler();
    }
}

