/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entities {
    private static final Map<String, Character> full;
    private static final Map<Character, String> xhtmlByVal;
    private static final Map<Character, String> baseByVal;
    private static final Map<Character, String> fullByVal;
    private static final Pattern unescapePattern;
    private static final Pattern strictUnescapePattern;
    private static final Object[][] xhtmlArray;

    private Entities() {
    }

    public static boolean isNamedEntity(String name) {
        return full.containsKey(name);
    }

    public static Character getCharacterByName(String name) {
        return full.get(name);
    }

    static String escape(String string2, Document.OutputSettings out) {
        return Entities.escape(string2, out.encoder(), out.escapeMode());
    }

    static String escape(String string2, CharsetEncoder encoder, EscapeMode escapeMode) {
        StringBuilder accum = new StringBuilder(string2.length() * 2);
        Map<Character, String> map2 = escapeMode.getMap();
        for (int pos = 0; pos < string2.length(); ++pos) {
            Character c = Character.valueOf(string2.charAt(pos));
            if (map2.containsKey(c)) {
                accum.append('&').append(map2.get(c)).append(';');
                continue;
            }
            if (encoder.canEncode(c.charValue())) {
                accum.append(c.charValue());
                continue;
            }
            accum.append("&#").append((int)c.charValue()).append(';');
        }
        return accum.toString();
    }

    static String unescape(String string2) {
        return Entities.unescape(string2, false);
    }

    static String unescape(String string2, boolean strict) {
        if (!string2.contains("&")) {
            return string2;
        }
        Matcher m = strict ? strictUnescapePattern.matcher(string2) : unescapePattern.matcher(string2);
        StringBuffer accum = new StringBuffer(string2.length());
        while (m.find()) {
            int charval = -1;
            String num = m.group(3);
            if (num != null) {
                try {
                    int base = m.group(2) != null ? 16 : 10;
                    charval = Integer.valueOf(num, base);
                }
                catch (NumberFormatException e) {}
            } else {
                String name = m.group(1);
                if (full.containsKey(name)) {
                    charval = full.get(name).charValue();
                }
            }
            if (charval != -1 || charval > 65535) {
                String c = Character.toString((char)charval);
                m.appendReplacement(accum, Matcher.quoteReplacement(c));
                continue;
            }
            m.appendReplacement(accum, Matcher.quoteReplacement(m.group(0)));
        }
        m.appendTail(accum);
        return accum.toString();
    }

    private static Map<String, Character> loadEntities(String filename) {
        Properties properties = new Properties();
        HashMap<String, Character> entities = new HashMap<String, Character>();
        try {
            InputStream in = Entities.class.getResourceAsStream(filename);
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new MissingResourceException("Error loading entities resource: " + e.getMessage(), "Entities", filename);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Character val = Character.valueOf((char)Integer.parseInt((String)entry.getValue(), 16));
            String name = (String)entry.getKey();
            entities.put(name, val);
        }
        return entities;
    }

    private static Map<Character, String> toCharacterKey(Map<String, Character> inMap) {
        HashMap<Character, String> outMap = new HashMap<Character, String>();
        for (Map.Entry<String, Character> entry : inMap.entrySet()) {
            Character character = entry.getValue();
            String name = entry.getKey();
            if (outMap.containsKey(character)) {
                if (!name.toLowerCase().equals(name)) continue;
                outMap.put(character, name);
                continue;
            }
            outMap.put(character, name);
        }
        return outMap;
    }

    static /* synthetic */ Map access$000() {
        return xhtmlByVal;
    }

    static /* synthetic */ Map access$100() {
        return baseByVal;
    }

    static /* synthetic */ Map access$200() {
        return fullByVal;
    }

    static {
        unescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);?");
        strictUnescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);");
        xhtmlArray = new Object[][]{{"quot", 34}, {"amp", 38}, {"apos", 39}, {"lt", 60}, {"gt", 62}};
        xhtmlByVal = new HashMap<Character, String>();
        baseByVal = Entities.toCharacterKey(Entities.loadEntities("entities-base.properties"));
        full = Entities.loadEntities("entities-full.properties");
        fullByVal = Entities.toCharacterKey(full);
        for (Object[] entity : xhtmlArray) {
            Character c = Character.valueOf((char)((Integer)entity[1]).intValue());
            xhtmlByVal.put(c, (String)entity[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeMode {
        xhtml(Entities.access$000()),
        base(Entities.access$100()),
        extended(Entities.access$200());

        private Map<Character, String> map;

        private EscapeMode(Map<Character, String> map2) {
            this.map = map2;
        }

        public Map<Character, String> getMap() {
            return this.map;
        }
    }
}

