/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.properties;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;

public class MapPropertyHolder
implements IPropertyHolder,
Serializable {
    private static final long serialVersionUID = 4507851447415709893L;
    private HashMap<IProperty<?>, Object> propertyMap;

    @Override
    public <T> MapPropertyHolder setProperty(IProperty<? super T> property, T value2) {
        if (value2 == null) {
            this.getProperties().remove(property);
        } else {
            this.getProperties().put(property, value2);
        }
        return this;
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        T defaultValue2;
        Object value2 = this.getProperties().get(property);
        if (value2 instanceof IPropertyValueProxy) {
            if ((value2 = ((IPropertyValueProxy)value2).resolveValue(property)) != null) {
                this.getProperties().put(property, value2);
                return (T)value2;
            }
        } else if (value2 != null) {
            return (T)value2;
        }
        if ((defaultValue2 = property.getDefault()) instanceof Cloneable) {
            this.setProperty(property, (Object)defaultValue2);
        }
        return defaultValue2;
    }

    @Override
    public boolean hasProperty(IProperty<?> property) {
        return this.propertyMap != null && this.propertyMap.containsKey(property);
    }

    @Override
    public MapPropertyHolder copyProperties(IPropertyHolder other) {
        if (other == null) {
            return this;
        }
        Map<IProperty<?>, Object> otherMap = other.getAllProperties();
        if (!otherMap.isEmpty()) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap(otherMap);
            } else {
                this.propertyMap.putAll(otherMap);
            }
        }
        return this;
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        if (this.propertyMap == null) {
            return Collections.emptyMap();
        }
        return this.propertyMap;
    }

    private Map<IProperty<?>, Object> getProperties() {
        if (this.propertyMap == null) {
            this.propertyMap = Maps.newHashMap();
        }
        return this.propertyMap;
    }
}

