/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IDataProvider;
import org.eclipse.elk.core.comments.IFilter;

public class SizeFilter<C>
implements IFilter<C> {
    private IBoundsProvider<C, ?> boundsProvider = null;
    private double maxArea = -1.0;

    public SizeFilter<C> withMaximumArea(double area) {
        if (area < 0.0) {
            throw new IllegalArgumentException("Maximum area must be >= 0.");
        }
        this.maxArea = area;
        return this;
    }

    public SizeFilter<C> withBoundsProvider(IBoundsProvider<C, ?> provider2) {
        Objects.requireNonNull(provider2, "Bounds provider must not be null.");
        this.boundsProvider = provider2;
        return this;
    }

    private void checkConfiguration() {
        if (this.boundsProvider == null) {
            throw new IllegalStateException("A bounds provider is required.");
        }
    }

    @Override
    public void preprocess(IDataProvider<C, ?> dataProvider, boolean includeHierarchy) {
        this.checkConfiguration();
    }

    @Override
    public boolean eligibleForAttachment(C comment) {
        Rectangle2D.Double bounds2 = this.boundsProvider.boundsForComment(comment);
        return bounds2.height * bounds2.width <= this.maxArea;
    }
}

