/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.elk.core.comments.AggregatedMatchDecider;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IDataProvider;
import org.eclipse.elk.core.comments.IDecider;
import org.eclipse.elk.core.comments.IExplicitAttachmentProvider;
import org.eclipse.elk.core.comments.IFilter;
import org.eclipse.elk.core.comments.IMatcher;
import org.eclipse.elk.core.util.Pair;

public final class CommentAttacher<C, T> {
    private boolean includeHierarchy = true;
    private boolean explicitAttachmentsDisableHeuristics = true;
    private IExplicitAttachmentProvider<C, T> explicitAttachmentProvider = a -> null;
    private IBoundsProvider<C, T> boundsProvider = null;
    private List<IFilter<C>> filters = Lists.newArrayList();
    private List<IMatcher<C, T>> matchers = Lists.newArrayList();
    private IDecider<T> decider = new AggregatedMatchDecider();

    public CommentAttacher<C, T> limitToCurrentHierarchyLevel(boolean limit) {
        this.includeHierarchy = !limit;
        return this;
    }

    public CommentAttacher<C, T> keepHeuristicsEnabledWithExplicitAttachments(boolean keepEnabled) {
        this.explicitAttachmentsDisableHeuristics = !keepEnabled;
        return this;
    }

    public CommentAttacher<C, T> withExplicitAttachmentProvider(IExplicitAttachmentProvider<C, T> provider2) {
        this.explicitAttachmentProvider = provider2 == null ? a -> null : provider2;
        return this;
    }

    public CommentAttacher<C, T> withBoundsProvider(IBoundsProvider<C, T> provider2) {
        Objects.requireNonNull(provider2, "The bounds provider must not be null.");
        this.boundsProvider = provider2;
        return this;
    }

    public CommentAttacher<C, T> addFilter(IFilter<C> filter2) {
        Objects.requireNonNull(filter2, "The filter must not be null.");
        this.filters.add(filter2);
        return this;
    }

    public CommentAttacher<C, T> addMatcher(IMatcher<C, T> matcher) {
        Objects.requireNonNull(matcher, "The matcher must not be null.");
        this.matchers.add(matcher);
        return this;
    }

    public CommentAttacher<C, T> withAttachmentDecider(IDecider<T> attachmentDecider) {
        Objects.requireNonNull(attachmentDecider, "The attachment decider must not be null.");
        this.decider = attachmentDecider;
        return this;
    }

    public void attachComments(IDataProvider<C, T> dataProvider) {
        this.preprocess(dataProvider);
        ArrayList explicitAttachments = Lists.newArrayList();
        ArrayList heuristicAttachments = Lists.newArrayList();
        LinkedList processingQueue = Lists.newLinkedList();
        processingQueue.add(dataProvider);
        while (!processingQueue.isEmpty()) {
            IDataProvider currentHierarchy = (IDataProvider)processingQueue.poll();
            for (Object comment : currentHierarchy.provideComments()) {
                T heuristicAttachment;
                T explicitAttachment = this.explicitAttachmentProvider.findExplicitAttachment(comment);
                if (explicitAttachment != null) {
                    explicitAttachments.add(Pair.of(comment, explicitAttachment));
                    continue;
                }
                if (!explicitAttachments.isEmpty() && this.explicitAttachmentsDisableHeuristics || !this.isEligibleForHeuristicAttachment(comment) || (heuristicAttachment = this.findMatch(currentHierarchy, comment)) == null) continue;
                heuristicAttachments.add(Pair.of(comment, heuristicAttachment));
            }
            if (!this.includeHierarchy) continue;
            processingQueue.addAll(currentHierarchy.provideSubHierarchies());
        }
        this.cleanup();
        this.edgeifyFoundAttachments(dataProvider, explicitAttachments, heuristicAttachments);
    }

    private void preprocess(IDataProvider<C, T> dataProvider) {
        this.explicitAttachmentProvider.preprocess(dataProvider, this.includeHierarchy);
        this.filters.stream().forEach(f -> f.preprocess(dataProvider, this.includeHierarchy));
        this.matchers.stream().forEach(h -> h.preprocess(dataProvider, this.includeHierarchy));
        if (this.boundsProvider != null) {
            this.boundsProvider.preprocess(dataProvider, this.includeHierarchy);
        }
    }

    private boolean isEligibleForHeuristicAttachment(C comment) {
        return this.filters.stream().allMatch(f -> f.eligibleForAttachment(comment));
    }

    private T findMatch(IDataProvider<C, T> dataProvider, C comment) {
        if (this.matchers.isEmpty()) {
            return null;
        }
        Collection<T> candidates = dataProvider.provideTargetsFor(comment);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        HashMap results = Maps.newHashMap();
        for (T candidate : candidates) {
            HashMap candidateResults = Maps.newHashMap();
            results.put(candidate, candidateResults);
            for (IMatcher<C, T> heuristic : this.matchers) {
                candidateResults.put(heuristic.getClass(), heuristic.normalized(comment, candidate));
            }
        }
        return this.decider.makeAttachmentDecision(results);
    }

    private void edgeifyFoundAttachments(IDataProvider<C, T> dataProvider, Collection<Pair<C, T>> explicitAttachments, Collection<Pair<C, T>> heuristicAttachments) {
        for (Pair<C, T> explicitAttachment : explicitAttachments) {
            dataProvider.attach(explicitAttachment.getFirst(), explicitAttachment.getSecond());
        }
        if (explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) {
            for (Pair<C, T> heuristicAttachment : heuristicAttachments) {
                dataProvider.attach(heuristicAttachment.getFirst(), heuristicAttachment.getSecond());
            }
        }
    }

    private void cleanup() {
        this.explicitAttachmentProvider.cleanup();
        this.filters.stream().forEach(f -> f.cleanup());
        this.matchers.stream().forEach(h -> h.cleanup());
        if (this.boundsProvider != null) {
            this.boundsProvider.cleanup();
        }
    }
}

