/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.alg;

import com.google.common.collect.Lists;
import java.util.List;

abstract class AbstractRandomListAccessor<T> {
    private List<T> list = Lists.newArrayList();

    protected AbstractRandomListAccessor() {
    }

    protected abstract T provideDefault();

    protected final T getListItem(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        this.ensureListSize(index + 1);
        return this.list.get(index);
    }

    protected final void setListItem(int index, T value2) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        if (index < this.list.size()) {
            this.list.set(index, value2);
        } else {
            this.ensureListSize(index);
            this.list.add(value2);
        }
    }

    protected final int getListSize() {
        return this.list.size();
    }

    protected void clearList() {
        this.list.clear();
    }

    private void ensureListSize(int size) {
        int i = this.list.size();
        while (i < size) {
            this.list.add(this.provideDefault());
            ++i;
        }
    }
}

