/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.GraphIssue;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.IValidatingGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;

public class LayoutOptionValidator
implements IValidatingGraphElementVisitor {
    private final List<GraphIssue> issues = new ArrayList<GraphIssue>();

    @Override
    public void visit(ElkGraphElement element) {
        for (Map.Entry entry : element.getProperties()) {
            Object value2 = entry.getValue();
            if (value2 instanceof IPropertyValueProxy && (value2 = ((IPropertyValueProxy)value2).resolveValue((IProperty)entry.getKey())) != null) {
                entry.setValue(value2);
            }
            this.issues.addAll(this.checkProperty((IProperty)entry.getKey(), value2, element));
        }
    }

    public List<GraphIssue> checkProperty(IProperty<Object> property, Object value2, ElkGraphElement element) {
        String optionName = null;
        if (property instanceof LayoutOptionData) {
            LayoutOptionData optionData = (LayoutOptionData)property;
            optionName = optionData.getName();
            if (value2 != null && !this.isValidType(optionData, value2)) {
                String message = "The assigned value " + value2.toString() + " of the option '" + optionName + "' does not match the type " + optionData.getOptionClass().getSimpleName() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        if (value2 != null) {
            String message;
            if (property.getLowerBound().compareTo(value2) > 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value2.toString() + " of the option '" + optionName + "' is less than the lower bound " + property.getLowerBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
            if (property.getUpperBound().compareTo(value2) < 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value2.toString() + " of the option '" + optionName + "' is greater than the upper bound " + property.getUpperBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        return Collections.emptyList();
    }

    protected boolean isValidType(LayoutOptionData optionData, Object value2) {
        switch (optionData.getType()) {
            case STRING: {
                return value2 instanceof String;
            }
            case BOOLEAN: {
                return value2 instanceof Boolean;
            }
            case INT: {
                return value2 instanceof Integer;
            }
            case DOUBLE: {
                return value2 instanceof Double;
            }
            case ENUMSET: {
                return value2 instanceof EnumSet;
            }
        }
        return optionData.getOptionClass().isInstance(value2);
    }

    public List<GraphIssue> getIssues() {
        return this.issues;
    }
}

