/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.splines.ConnectedSelfLoopComponent;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class SplinesMath {
    private static final double EPSILON = 1.0E-8;
    private static final String NULL_STRING = "(null)";
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUATER_PI = 0.7853981633974483;
    public static final double THREE_HALF_PI = 4.71238898038469;
    public static final double TWO_PI = Math.PI * 2;
    public static final double THREE = 3.0;
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("#0.0");

    private SplinesMath() {
        throw new AssertionError((Object)"Instantiating utility class SplinesMath.");
    }

    public static KVector intersect(KVector pt1, KVector pt2, double dirPT1, double dirPT2) {
        return SplinesMath.intersect(pt1, new KVector(dirPT1).add(pt1), pt2, new KVector(dirPT2).add(pt2));
    }

    public static KVector intersect(KVector pt1, KVector pt2, KVector pt3, KVector pt4) {
        double x1 = pt1.x;
        double x2 = pt2.x;
        double y3 = pt3.y;
        double y4 = pt4.y;
        double y1 = pt1.y;
        double y2 = pt2.y;
        double x3 = pt3.x;
        double x4 = pt4.x;
        double divisor = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (Math.abs(divisor) < 1.0E-8) {
            return null;
        }
        double first = x1 * y2 - y1 * x2;
        double second = x3 * y4 - y3 * x4;
        double newX = (first * (x3 - x4) - second * (x1 - x2)) / divisor;
        double newY = (first * (y3 - y4) - second * (y1 - y2)) / divisor;
        return new KVector(newX, newY);
    }

    public static double innerAngle(KVector vec1, KVector vec2) {
        return Math.acos((vec1.x * vec2.x + vec1.y * vec2.y) / (vec1.length() * vec2.length()));
    }

    public static double innerAngle(double dir1, double dir2) {
        double retval = Math.abs(dir1 - dir2);
        return retval % Math.PI;
    }

    public static String convertKVectorToString(KVector vector) {
        if (vector == null) {
            return NULL_STRING;
        }
        return "(" + DEC_FORMAT.format(vector.x) + "," + DEC_FORMAT.format(vector.y) + ")";
    }

    public static String convertKVectorToString(KVector ... list) {
        if (list == null || list.length == 0) {
            return NULL_STRING;
        }
        StringBuilder retVal = new StringBuilder();
        KVector[] kVectorArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            KVector vector = kVectorArray[n2];
            retVal.append(SplinesMath.convertKVectorToString(vector)).append(", ");
            ++n2;
        }
        return retVal.substring(0, retVal.length() - 2);
    }

    public static String convertKVectorToString(Iterable<KVector> list) {
        if (list == null || Iterables.size(list) == 0) {
            return NULL_STRING;
        }
        StringBuilder retVal = new StringBuilder();
        for (KVector vector : list) {
            retVal.append(SplinesMath.convertKVectorToString(vector)).append(", ");
        }
        return retVal.substring(0, retVal.length() - 2);
    }

    public static double lengthToOrthogonal(double direction, KVector point) {
        double angle = SplinesMath.innerAngle(direction, point.toRadians());
        int factor = 1;
        if (angle > 1.5707963267948966) {
            factor = -1;
            angle -= 0.7853981633974483;
        }
        return (double)factor * Math.cos(angle) * point.length();
    }

    public static double portSideToDirection(PortSide side) {
        switch (side) {
            case NORTH: {
                return 4.71238898038469;
            }
            case EAST: {
                return 0.0;
            }
            case SOUTH: {
                return 1.5707963267948966;
            }
            case WEST: {
                return Math.PI;
            }
        }
        return 0.0;
    }

    public static void printConnectedComponent(ConnectedSelfLoopComponent component) {
        System.out.print("Connected component: " + component.getLoopSide().toString() + ": ");
        for (LPort port : component.getHidablePorts()) {
            System.out.print(String.valueOf(port.toString()) + " " + port.getSide().toString() + " / ");
        }
        System.out.println();
    }

    public static double distPortToNodeEdge(LPort port, PortSide side) {
        KVector portPos = port.getPosition().clone().add(port.getAnchor());
        KVector nodeSize = port.getNode().getSize();
        switch (side) {
            case NORTH: {
                return -portPos.y;
            }
            case EAST: {
                return -portPos.x + nodeSize.x;
            }
            case SOUTH: {
                return -portPos.y + nodeSize.y;
            }
            case WEST: {
                return -portPos.x;
            }
        }
        return 0.0;
    }

    public static boolean isBetween(int value2, int boundary0, int boundary1) {
        return value2 < boundary0 ? boundary1 <= value2 : value2 <= boundary1 || value2 == boundary0;
    }

    public static boolean isBetween(double value2, double boundary0, double boundary1) {
        if (Math.abs(boundary0 - value2) < 1.0E-8 || Math.abs(boundary1 - value2) < 1.0E-8) {
            return true;
        }
        return boundary0 - value2 > 1.0E-8 ? value2 - boundary1 > 1.0E-8 : boundary1 - value2 > 1.0E-8;
    }

    public static double getMarginOnPortSide(LNode node, PortSide side) {
        switch (side) {
            case NORTH: {
                return node.getMargin().top;
            }
            case EAST: {
                return node.getMargin().right;
            }
            case SOUTH: {
                return node.getMargin().bottom;
            }
            case WEST: {
                return node.getMargin().left;
            }
        }
        return 0.0;
    }
}

