/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.FixedAlignment;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKAlignedLayout;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKAligner;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKCompactor;
import org.eclipse.elk.alg.layered.p4nodes.bk.NeighborhoodInformation;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class BKNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHY_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private LGraph lGraph;
    private final Set<LEdge> markedEdges = Sets.newHashSet();
    private NeighborhoodInformation ni;
    private boolean debugMode = false;
    private boolean produceBalancedLayout = false;
    private static final int MIN_LAYERS_FOR_CONFLICTS = 3;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        if (graph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        BKAlignedLayout balanced;
        monitor.begin("Brandes & Koepf node placement", 1.0f);
        this.lGraph = layeredGraph;
        this.ni = NeighborhoodInformation.buildFor(layeredGraph);
        this.debugMode = layeredGraph.getProperty(LayeredOptions.DEBUG_MODE);
        FixedAlignment align = layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_BK_FIXED_ALIGNMENT);
        boolean favorStraightEdges = layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES);
        this.produceBalancedLayout = align == FixedAlignment.NONE && !favorStraightEdges || align == FixedAlignment.BALANCED;
        this.markConflicts(layeredGraph);
        BKAlignedLayout rightdown = null;
        BKAlignedLayout rightup = null;
        BKAlignedLayout leftdown = null;
        BKAlignedLayout leftup = null;
        ArrayList layouts = Lists.newArrayListWithCapacity((int)4);
        switch (layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_BK_FIXED_ALIGNMENT)) {
            case LEFTDOWN: {
                leftdown = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.DOWN, BKAlignedLayout.HDirection.LEFT);
                layouts.add(leftdown);
                break;
            }
            case LEFTUP: {
                leftup = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.UP, BKAlignedLayout.HDirection.LEFT);
                layouts.add(leftup);
                break;
            }
            case RIGHTDOWN: {
                rightdown = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.DOWN, BKAlignedLayout.HDirection.RIGHT);
                layouts.add(rightdown);
                break;
            }
            case RIGHTUP: {
                rightup = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.UP, BKAlignedLayout.HDirection.RIGHT);
                layouts.add(rightup);
                break;
            }
            default: {
                leftdown = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.DOWN, BKAlignedLayout.HDirection.LEFT);
                leftup = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.UP, BKAlignedLayout.HDirection.LEFT);
                rightdown = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.DOWN, BKAlignedLayout.HDirection.RIGHT);
                rightup = new BKAlignedLayout(layeredGraph, this.ni.nodeCount, BKAlignedLayout.VDirection.UP, BKAlignedLayout.HDirection.RIGHT);
                layouts.add(rightdown);
                layouts.add(rightup);
                layouts.add(leftdown);
                layouts.add(leftup);
            }
        }
        BKAligner aligner = new BKAligner(layeredGraph, this.ni);
        for (BKAlignedLayout bal : layouts) {
            aligner.verticalAlignment(bal, this.markedEdges);
            aligner.insideBlockShift(bal);
        }
        BKCompactor compacter = new BKCompactor(layeredGraph, this.ni);
        for (BKAlignedLayout bal : layouts) {
            compacter.horizontalCompaction(bal);
        }
        if (this.debugMode) {
            for (BKAlignedLayout bal : layouts) {
                System.out.println(bal + " size is " + bal.layoutSize());
            }
        }
        BKAlignedLayout chosenLayout = null;
        if (this.produceBalancedLayout && this.checkOrderConstraint(layeredGraph, balanced = this.createBalancedLayout(layouts, this.ni.nodeCount))) {
            chosenLayout = balanced;
        }
        if (chosenLayout == null) {
            for (BKAlignedLayout bal : layouts) {
                if (!this.checkOrderConstraint(layeredGraph, bal) || chosenLayout != null && !(chosenLayout.layoutSize() > bal.layoutSize())) continue;
                chosenLayout = bal;
            }
        }
        if (chosenLayout == null) {
            chosenLayout = (BKAlignedLayout)layouts.get(0);
        }
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                node.getPosition().y = chosenLayout.y[node.id] + chosenLayout.innerShift[node.id];
            }
        }
        if (this.debugMode) {
            System.out.println("Chosen node placement: " + chosenLayout);
            System.out.println("Blocks: " + BKNodePlacer.getBlocks(chosenLayout));
            System.out.println("Classes: " + BKNodePlacer.getClasses(chosenLayout));
            System.out.println("Marked edges: " + this.markedEdges);
        }
        for (BKAlignedLayout bal : layouts) {
            bal.cleanup();
        }
        this.ni.cleanup();
        this.markedEdges.clear();
        monitor.done();
    }

    private void markConflicts(LGraph layeredGraph) {
        int numberOfLayers = layeredGraph.getLayers().size();
        if (numberOfLayers < 3) {
            return;
        }
        int[] layerSize = new int[numberOfLayers];
        int layerIndex = 0;
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize[layerIndex++] = layer.getNodes().size();
        }
        ListIterator<Layer> layerIterator = layeredGraph.getLayers().listIterator(2);
        int i = 1;
        while (i < numberOfLayers - 1) {
            Layer currentLayer = (Layer)layerIterator.next();
            Iterator<LNode> nodeIterator = currentLayer.getNodes().iterator();
            int k_0 = 0;
            int l = 0;
            int l_1 = 0;
            while (l_1 < layerSize[i + 1]) {
                LNode v_l_i = nodeIterator.next();
                if (l_1 == layerSize[i + 1] - 1 || this.incidentToInnerSegment(v_l_i, i + 1, i)) {
                    int k_1 = layerSize[i] - 1;
                    if (this.incidentToInnerSegment(v_l_i, i + 1, i)) {
                        k_1 = this.ni.nodeIndex[this.ni.leftNeighbors.get((int)v_l_i.id).get((int)0).getFirst().id];
                    }
                    while (l <= l_1) {
                        LNode v_l = currentLayer.getNodes().get(l);
                        if (!this.incidentToInnerSegment(v_l, i + 1, i)) {
                            for (Pair<LNode, LEdge> upperNeighbor : this.ni.leftNeighbors.get(v_l.id)) {
                                int k = this.ni.nodeIndex[upperNeighbor.getFirst().id];
                                if (k >= k_0 && k <= k_1) continue;
                                this.markedEdges.add(upperNeighbor.getSecond());
                            }
                        }
                        ++l;
                    }
                    k_0 = k_1;
                }
                ++l_1;
            }
            ++i;
        }
    }

    private BKAlignedLayout createBalancedLayout(List<BKAlignedLayout> layouts, int nodeCount) {
        int noOfLayouts = layouts.size();
        BKAlignedLayout balanced = new BKAlignedLayout(this.lGraph, nodeCount, null, null);
        double[] width = new double[noOfLayouts];
        double[] min = new double[noOfLayouts];
        double[] max = new double[noOfLayouts];
        int minWidthLayout = 0;
        int i = 0;
        while (i < noOfLayouts) {
            min[i] = 2.147483647E9;
            max[i] = -2.147483648E9;
            ++i;
        }
        i = 0;
        while (i < noOfLayouts) {
            BKAlignedLayout bal = layouts.get(i);
            width[i] = bal.layoutSize();
            if (width[minWidthLayout] > width[i]) {
                minWidthLayout = i;
            }
            for (Layer l : this.lGraph) {
                for (LNode n : l) {
                    double nodePosY = bal.y[n.id] + bal.innerShift[n.id];
                    min[i] = Math.min(min[i], nodePosY);
                    max[i] = Math.max(max[i], nodePosY + n.getSize().y);
                }
            }
            ++i;
        }
        double[] shift = new double[noOfLayouts];
        int i2 = 0;
        while (i2 < noOfLayouts) {
            shift[i2] = layouts.get((int)i2).vdir == BKAlignedLayout.VDirection.DOWN ? min[minWidthLayout] - min[i2] : max[minWidthLayout] - max[i2];
            ++i2;
        }
        double[] calculatedYs = new double[noOfLayouts];
        for (Layer layer : this.lGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                int i3 = 0;
                while (i3 < noOfLayouts) {
                    calculatedYs[i3] = layouts.get((int)i3).y[node.id] + layouts.get((int)i3).innerShift[node.id] + shift[i3];
                    ++i3;
                }
                Arrays.sort(calculatedYs);
                balanced.y[node.id] = (calculatedYs[1] + calculatedYs[2]) / 2.0;
                balanced.innerShift[node.id] = 0.0;
            }
        }
        return balanced;
    }

    private boolean incidentToInnerSegment(LNode node, int layer1, int layer2) {
        if (node.getType() == LNode.NodeType.BIG_NODE) {
            for (LEdge edge : node.getIncomingEdges()) {
                LNode source = edge.getSource().getNode();
                if (source.getType() != LNode.NodeType.BIG_NODE && !source.getProperty(InternalProperties.BIG_NODE_INITIAL).booleanValue() || this.ni.layerIndex[edge.getSource().getNode().getLayer().id] != layer2 || this.ni.layerIndex[node.getLayer().id] != layer1) continue;
                return true;
            }
        }
        if (node.getType() == LNode.NodeType.LONG_EDGE) {
            for (LEdge edge : node.getIncomingEdges()) {
                LNode.NodeType sourceNodeType = edge.getSource().getNode().getType();
                if (sourceNodeType != LNode.NodeType.LONG_EDGE || this.ni.layerIndex[edge.getSource().getNode().getLayer().id] != layer2 || this.ni.layerIndex[node.getLayer().id] != layer1) continue;
                return true;
            }
        }
        return false;
    }

    static LEdge getEdge(LNode source, LNode target) {
        for (LEdge edge : source.getConnectedEdges()) {
            if (!edge.getTarget().getNode().equals(target) && !edge.getSource().getNode().equals(target)) continue;
            return edge;
        }
        return null;
    }

    static Map<LNode, List<LNode>> getBlocks(BKAlignedLayout bal) {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        for (Layer layer : bal.layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                LNode root = bal.root[node.id];
                List blockContents = (List)blocks.get(root);
                if (blockContents == null) {
                    blockContents = Lists.newArrayList();
                    blocks.put(root, blockContents);
                }
                blockContents.add(node);
            }
        }
        return blocks;
    }

    static Map<LNode, List<LNode>> getClasses(BKAlignedLayout bal) {
        LinkedHashMap classes2 = Maps.newLinkedHashMap();
        LinkedHashSet roots = Sets.newLinkedHashSet(Arrays.asList(bal.root));
        for (LNode root : roots) {
            if (root == null) {
                System.out.println("There are no classes in a balanced layout.");
                break;
            }
            LNode sink = bal.sink[root.id];
            List classContents = (List)classes2.get(sink);
            if (classContents == null) {
                classContents = Lists.newArrayList();
                classes2.put(sink, classContents);
            }
            classContents.add(root);
        }
        return classes2;
    }

    private boolean checkOrderConstraint(LGraph layeredGraph, BKAlignedLayout bal) {
        boolean feasible = true;
        for (Layer layer : layeredGraph.getLayers()) {
            double pos = Double.NEGATIVE_INFINITY;
            LNode previous = null;
            for (LNode node : layer.getNodes()) {
                double top = bal.y[node.id] + bal.innerShift[node.id] - node.getMargin().top;
                double bottom2 = bal.y[node.id] + bal.innerShift[node.id] + node.getSize().y + node.getMargin().bottom;
                if (top > pos && bottom2 > pos) {
                    previous = node;
                    pos = bal.y[node.id] + bal.innerShift[node.id] + node.getSize().y + node.getMargin().bottom;
                    continue;
                }
                feasible = false;
                if (!this.debugMode) break;
                System.out.println("bk node placement breaks on " + node + " which should have been after " + previous);
                break;
            }
            if (!feasible) break;
        }
        if (this.debugMode) {
            System.out.println(bal + " is feasible: " + feasible);
        }
        return feasible;
    }
}

