/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.BarycenterHeuristic;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.core.util.Pair;

public class ForsterConstraintResolver
implements IInitializable {
    private Multimap<LNode, LNode> layoutUnits;
    private BarycenterHeuristic.BarycenterState[][] barycenterStates;
    private ConstraintGroup[][] constraintGroups;
    private static final float BARYCENTER_EQUALITY_DELTA = 1.0E-4f;

    public ForsterConstraintResolver(LNode[][] currentNodeOrder) {
        this.barycenterStates = new BarycenterHeuristic.BarycenterState[currentNodeOrder.length][];
        this.constraintGroups = new ConstraintGroup[currentNodeOrder.length][];
        this.layoutUnits = LinkedHashMultimap.create();
    }

    public void processConstraints(List<LNode> nodes) {
        ArrayList groups = Lists.newArrayList();
        for (LNode node : nodes) {
            groups.add(this.constraintGroups[node.getLayer().id][node.id]);
        }
        this.buildConstraintsGraph(groups);
        Pair<ConstraintGroup, ConstraintGroup> violatedConstraint = null;
        while ((violatedConstraint = this.findViolatedConstraint(groups)) != null) {
            this.handleViolatedConstraint(violatedConstraint.getFirst(), violatedConstraint.getSecond(), groups);
        }
        nodes.clear();
        for (ConstraintGroup group : groups) {
            LNode[] lNodeArray = group.getNodes();
            int n = lNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                nodes.add(node);
                this.stateOf((LNode)node).barycenter = group.getBarycenter();
                ++n2;
            }
        }
    }

    private void buildConstraintsGraph(List<ConstraintGroup> groups) {
        for (ConstraintGroup group : groups) {
            group.resetOutgoingConstraints();
            group.incomingConstraintsCount = 0;
        }
        LNode lastNonDummyNode = null;
        for (ConstraintGroup group : groups) {
            LNode node = group.getNode();
            for (LNode successor : node.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)) {
                group.getOutgoingConstraints().add(this.groupOf(successor));
                ConstraintGroup constraintGroup = this.groupOf(successor);
                constraintGroup.incomingConstraintsCount = constraintGroup.incomingConstraintsCount + 1;
            }
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            if (lastNonDummyNode != null) {
                for (LNode lastUnitNode : this.layoutUnits.get((Object)lastNonDummyNode)) {
                    for (LNode currentUnitNode : this.layoutUnits.get((Object)node)) {
                        this.groupOf(lastUnitNode).getOutgoingConstraints().add(this.groupOf(currentUnitNode));
                        ConstraintGroup constraintGroup = this.groupOf(currentUnitNode);
                        constraintGroup.incomingConstraintsCount = constraintGroup.incomingConstraintsCount + 1;
                    }
                }
            }
            lastNonDummyNode = node;
        }
    }

    private Pair<ConstraintGroup, ConstraintGroup> findViolatedConstraint(List<ConstraintGroup> groups) {
        List activeGroups = null;
        double lastValue = -32768.0;
        for (ConstraintGroup group : groups) {
            assert (group.getBarycenter() != null && group.getBarycenter() >= lastValue);
            lastValue = group.getBarycenter();
            group.resetIncomingConstraints();
            if (!group.hasOutgoingConstraints() || group.incomingConstraintsCount != 0) continue;
            if (activeGroups == null) {
                activeGroups = Lists.newArrayList();
            }
            activeGroups.add(group);
        }
        if (activeGroups != null) {
            while (!activeGroups.isEmpty()) {
                ConstraintGroup group;
                group = (ConstraintGroup)activeGroups.remove(0);
                if (group.hasIncomingConstraints()) {
                    for (ConstraintGroup predecessor : group.getIncomingConstraints()) {
                        if (!(predecessor.getBarycenter().floatValue() == group.getBarycenter().floatValue() ? groups.indexOf(predecessor) > groups.indexOf(group) : predecessor.getBarycenter() > group.getBarycenter())) continue;
                        return Pair.of(predecessor, group);
                    }
                }
                for (ConstraintGroup successor : group.getOutgoingConstraints()) {
                    List<ConstraintGroup> successorIncomingList = successor.getIncomingConstraints();
                    successorIncomingList.add(0, group);
                    if (successor.incomingConstraintsCount != successorIncomingList.size()) continue;
                    activeGroups.add(successor);
                }
            }
        }
        return null;
    }

    private void handleViolatedConstraint(ConstraintGroup firstNodeGroup, ConstraintGroup secondNodeGroup, List<ConstraintGroup> nodeGroups) {
        ConstraintGroup newNodeGroup = new ConstraintGroup(firstNodeGroup, secondNodeGroup);
        assert (newNodeGroup.getBarycenter() + (double)1.0E-4f >= secondNodeGroup.getBarycenter());
        assert (newNodeGroup.getBarycenter() - (double)1.0E-4f <= firstNodeGroup.getBarycenter());
        ListIterator<ConstraintGroup> nodeGroupIterator = nodeGroups.listIterator();
        boolean alreadyInserted = false;
        while (nodeGroupIterator.hasNext()) {
            ConstraintGroup nodeGroup = nodeGroupIterator.next();
            if (nodeGroup == firstNodeGroup || nodeGroup == secondNodeGroup) {
                nodeGroupIterator.remove();
                continue;
            }
            if (!alreadyInserted && nodeGroup.getBarycenter() > newNodeGroup.getBarycenter()) {
                nodeGroupIterator.previous();
                nodeGroupIterator.add(newNodeGroup);
                alreadyInserted = true;
                continue;
            }
            if (!nodeGroup.hasOutgoingConstraints()) continue;
            boolean firstNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(firstNodeGroup);
            boolean secondNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(secondNodeGroup);
            if (!firstNodeGroupConstraint && !secondNodeGroupConstraint) continue;
            nodeGroup.getOutgoingConstraints().add(newNodeGroup);
            ConstraintGroup constraintGroup = newNodeGroup;
            constraintGroup.incomingConstraintsCount = constraintGroup.incomingConstraintsCount + 1;
        }
        if (!alreadyInserted) {
            nodeGroups.add(newNodeGroup);
        }
    }

    private ConstraintGroup groupOf(LNode node) {
        return this.constraintGroups[node.getLayer().id][node.id];
    }

    private BarycenterHeuristic.BarycenterState stateOf(LNode node) {
        return this.barycenterStates[node.getLayer().id][node.id];
    }

    public BarycenterHeuristic.BarycenterState[][] getBarycenterStates() {
        return this.barycenterStates;
    }

    @Override
    public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
        this.barycenterStates[l] = new BarycenterHeuristic.BarycenterState[nodeOrder[l].length];
        this.constraintGroups[l] = new ConstraintGroup[nodeOrder[l].length];
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        this.barycenterStates[l][n] = new BarycenterHeuristic.BarycenterState(node);
        this.constraintGroups[l][n] = new ConstraintGroup(node);
        LNode layoutUnit = node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT);
        if (layoutUnit != null) {
            this.layoutUnits.put((Object)layoutUnit, (Object)node);
        }
    }

    public final class ConstraintGroup {
        private double summedWeight;
        private int degree;
        private final LNode[] nodes;
        private List<ConstraintGroup> outgoingConstraints;
        private List<ConstraintGroup> incomingConstraints;
        private int incomingConstraintsCount;

        public ConstraintGroup(LNode node) {
            this.nodes = new LNode[]{node};
        }

        public ConstraintGroup(ConstraintGroup nodeGroup1, ConstraintGroup nodeGroup2) {
            int length1 = nodeGroup1.nodes.length;
            int length2 = nodeGroup2.nodes.length;
            this.nodes = new LNode[length1 + length2];
            int i = 0;
            while (i < length1) {
                this.nodes[i] = nodeGroup1.nodes[i];
                ++i;
            }
            i = 0;
            while (i < length2) {
                this.nodes[length1 + i] = nodeGroup2.nodes[i];
                ++i;
            }
            if (nodeGroup1.outgoingConstraints != null) {
                this.outgoingConstraints = Lists.newLinkedList(nodeGroup1.outgoingConstraints);
                this.outgoingConstraints.remove(nodeGroup2);
                if (nodeGroup2.outgoingConstraints != null) {
                    for (ConstraintGroup candidate : nodeGroup2.outgoingConstraints) {
                        if (candidate == nodeGroup1) continue;
                        if (this.outgoingConstraints.contains(candidate)) {
                            --candidate.incomingConstraintsCount;
                            continue;
                        }
                        this.outgoingConstraints.add(candidate);
                    }
                }
            } else if (nodeGroup2.outgoingConstraints != null) {
                this.outgoingConstraints = Lists.newLinkedList(nodeGroup2.outgoingConstraints);
                this.outgoingConstraints.remove(nodeGroup1);
            }
            this.summedWeight = nodeGroup1.summedWeight + nodeGroup2.summedWeight;
            this.degree = nodeGroup1.degree + nodeGroup2.degree;
            if (this.degree > 0) {
                this.setBarycenter(this.summedWeight / (double)this.degree);
            } else if (nodeGroup1.getBarycenter() != null && nodeGroup2.getBarycenter() != null) {
                this.setBarycenter((nodeGroup1.getBarycenter() + nodeGroup2.getBarycenter()) / 2.0);
            } else if (nodeGroup1.getBarycenter() != null) {
                this.setBarycenter(nodeGroup1.getBarycenter());
            } else if (nodeGroup2.getBarycenter() != null) {
                this.setBarycenter(nodeGroup2.getBarycenter());
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int i = 0;
            while (i < this.nodes.length) {
                sb.append(this.nodes[i].toString());
                if (this.getBarycenter() != null) {
                    sb.append("<").append(this.getBarycenter().toString()).append(">");
                }
                if (i < this.nodes.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            return sb.append(']').toString();
        }

        public void setBarycenter(Double barycenter) {
            LNode[] lNodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                ((ForsterConstraintResolver)ForsterConstraintResolver.this).stateOf((LNode)node).barycenter = barycenter;
                ++n2;
            }
        }

        public Double getBarycenter() {
            return ((ForsterConstraintResolver)ForsterConstraintResolver.this).stateOf((LNode)this.nodes[0]).barycenter;
        }

        public List<ConstraintGroup> getOutgoingConstraints() {
            if (this.outgoingConstraints == null) {
                this.outgoingConstraints = Lists.newArrayList();
            }
            return this.outgoingConstraints;
        }

        public void resetOutgoingConstraints() {
            this.outgoingConstraints = null;
        }

        public boolean hasOutgoingConstraints() {
            return this.outgoingConstraints != null && this.outgoingConstraints.size() > 0;
        }

        public List<ConstraintGroup> getIncomingConstraints() {
            if (this.incomingConstraints == null) {
                this.incomingConstraints = Lists.newArrayList();
            }
            return this.incomingConstraints;
        }

        public void resetIncomingConstraints() {
            this.incomingConstraints = null;
        }

        public boolean hasIncomingConstraints() {
            return this.incomingConstraints != null && this.incomingConstraints.size() > 0;
        }

        public LNode[] getNodes() {
            return this.nodes;
        }

        public LNode getNode() {
            assert (this.nodes.length == 1);
            return this.nodes[0];
        }
    }
}

