/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DepthFirstCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);
    private final List<LNode> sources = Lists.newArrayList();
    private int[] mark;
    private int[] root;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Depth-first cycle removal", 1.0f);
        List<LNode> nodes = graph.getLayerlessNodes();
        int unprocessedNodeCount = nodes.size();
        this.mark = new int[unprocessedNodeCount];
        Arrays.fill(this.mark, -1);
        this.root = new int[unprocessedNodeCount];
        Arrays.fill(this.root, -1);
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            if (Iterables.isEmpty(node.getIncomingEdges())) {
                this.sources.add(node);
            }
            ++index;
        }
        for (LNode source : this.sources) {
            this.dfs(source, 0, source.id);
        }
        int i = 0;
        while (i < this.mark.length) {
            if (this.mark[i] == -1) {
                LNode n = nodes.get(i);
                assert (n.id == i);
                this.dfs(n, 0, n.id);
            }
            ++i;
        }
        for (LNode u : nodes) {
            for (LEdge e : Lists.newArrayList(u.getOutgoingEdges())) {
                if (e.isSelfLoop()) continue;
                LNode v = e.getOther(u);
                if (this.root[u.id] != this.root[v.id] || this.mark[v.id] >= this.mark[u.id]) continue;
                e.reverse(graph, true);
                graph.setProperty(InternalProperties.CYCLIC, (Object)true);
            }
        }
        this.mark = null;
        this.root = null;
        this.sources.clear();
        monitor.done();
    }

    private void dfs(LNode n, int index, int rootId) {
        if (this.mark[n.id] != -1) {
            return;
        }
        this.mark[n.id] = index;
        this.root[n.id] = rootId;
        for (LEdge out : n.getOutgoingEdges()) {
            if (out.isSelfLoop()) continue;
            LNode target = out.getTarget().getNode();
            this.dfs(target, index + 1, rootId);
        }
    }
}

