/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.eclipse.elk.alg.common.compaction.oned.CGraph;
import org.eclipse.elk.alg.common.compaction.oned.CGroup;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.CompareFuzzy;
import org.eclipse.elk.alg.common.compaction.oned.Quadruplet;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.compaction.HorizontalGraphCompactor;
import org.eclipse.elk.alg.layered.intermediate.compaction.VerticalSegment;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineSegment;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class LGraphToCGraphTransformer {
    private CGraph cGraph;
    private LGraph layeredGraph;
    private EdgeRouting edgeRouting;
    private Map<LNode, Pair<LNode, KVector>> commentOffsets = Maps.newHashMap();
    private Map<LNode, CNode> nodesMap = Maps.newHashMap();
    private Map<VerticalSegment, CNode> verticalSegmentsMap = Maps.newHashMap();
    private Map<CNode, Quadruplet> lockMap = Maps.newHashMap();
    private static final Function<CNode, String> NODE_TO_STRING_DELEGATE = n -> ((LNode)n.origin).getProperty(InternalProperties.ORIGIN).toString();
    private static final Function<CNode, String> VS_TO_STRING_DELEGATE = n -> ((VerticalSegment)n.origin).toString();

    public CGraph transform(LGraph inputGraph) {
        this.layeredGraph = inputGraph;
        this.edgeRouting = this.layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING);
        this.init();
        this.transformNodes();
        this.transformEdges();
        return this.cGraph;
    }

    public Map<CNode, Quadruplet> getLockMap() {
        return this.lockMap;
    }

    private void init() {
        boolean hasEdges = false;
        int index = 0;
        for (Layer l : this.layeredGraph) {
            l.id = index++;
            for (LNode n : l) {
                if (hasEdges || Iterables.isEmpty(n.getConnectedEdges())) continue;
                hasEdges = true;
            }
        }
        EnumSet<Direction> supportedDirections = EnumSet.of(Direction.UNDEFINED, Direction.LEFT, Direction.RIGHT);
        if (!hasEdges) {
            supportedDirections.add(Direction.UP);
            supportedDirections.add(Direction.DOWN);
        }
        this.cGraph = new CGraph(supportedDirections);
        this.nodesMap.clear();
        this.commentOffsets.clear();
        this.lockMap.clear();
        this.verticalSegmentsMap.clear();
    }

    private void transformNodes() {
        for (Layer layer : this.layeredGraph) {
            for (LNode node : layer) {
                if (node.getProperty(LayeredOptions.COMMENT_BOX).booleanValue() && !Iterables.isEmpty(node.getConnectedEdges())) {
                    LEdge e = (LEdge)Iterables.get(node.getConnectedEdges(), (int)0);
                    LNode other = e.getSource().getNode();
                    if (other == node) {
                        other = e.getTarget().getNode();
                    }
                    Pair<LNode, KVector> p = Pair.of(other, node.getPosition().clone().sub(other.getPosition()));
                    this.commentOffsets.put(node, p);
                    continue;
                }
                ElkRectangle hitbox = new ElkRectangle(node.getPosition().x - node.getMargin().left, node.getPosition().y - node.getMargin().top, node.getSize().x + node.getMargin().left + node.getMargin().right, node.getSize().y + node.getMargin().top + node.getMargin().bottom);
                CNode cNode = CNode.of().origin((Object)node).hitbox(hitbox).toStringDelegate(NODE_TO_STRING_DELEGATE).create(this.cGraph);
                CGroup.of().nodes(new CNode[]{cNode}).master(cNode).create(this.cGraph);
                Quadruplet nodeLock = new Quadruplet();
                this.lockMap.put(cNode, nodeLock);
                int difference = Iterables.size(node.getIncomingEdges()) - Iterables.size(node.getOutgoingEdges());
                if (difference < 0) {
                    nodeLock.set(true, Direction.LEFT);
                } else if (difference > 0) {
                    nodeLock.set(true, Direction.RIGHT);
                }
                if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                    nodeLock.set(false, false, false, false);
                }
                this.nodesMap.put(node, cNode);
            }
        }
    }

    private void transformEdges() {
        List<VerticalSegment> verticalSegments;
        EdgeRouting style2 = this.layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING);
        switch (style2) {
            case ORTHOGONAL: {
                verticalSegments = this.collectVerticalSegmentsOrthogonal();
                break;
            }
            case SPLINES: {
                verticalSegments = this.collectVerticalSegmentsSplines();
                break;
            }
            default: {
                throw new IllegalStateException("Compaction not supported for " + (Object)((Object)style2) + " edges.");
            }
        }
        this.mergeVerticalSegments(verticalSegments);
        this.verticalSegmentsMap.keySet().forEach(vs -> {
            CNode vsNode = this.verticalSegmentsMap.get(vs);
            vs.constraints.forEach(other -> {
                CNode otherNode = this.verticalSegmentsMap.get(other);
                this.cGraph.predefinedHorizontalConstraints.add(Pair.of(vsNode, otherNode));
            });
        });
    }

    private List<VerticalSegment> collectVerticalSegmentsOrthogonal() {
        ArrayList verticalSegments = Lists.newArrayList();
        for (Layer layer : this.layeredGraph) {
            for (LNode node : layer) {
                CNode cNode = this.nodesMap.get(node);
                for (LEdge edge : node.getOutgoingEdges()) {
                    VerticalSegment vs;
                    Iterator bends = edge.getBendPoints().iterator();
                    boolean first = true;
                    VerticalSegment lastSegment = null;
                    if (!bends.hasNext()) continue;
                    KVector bend1 = (KVector)bends.next();
                    KVector bend2 = null;
                    if (edge.getSource().getSide() == PortSide.NORTH) {
                        vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y), cNode, edge);
                        vs.ignoreSpacing.down = true;
                        vs.aPort = edge.getSource();
                        verticalSegments.add(vs);
                    }
                    if (edge.getSource().getSide() == PortSide.SOUTH) {
                        vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y + cNode.hitbox.height), cNode, edge);
                        vs.ignoreSpacing.up = true;
                        vs.aPort = edge.getSource();
                        verticalSegments.add(vs);
                    }
                    while (bends.hasNext()) {
                        bend2 = (KVector)bends.next();
                        if (!CompareFuzzy.eq((double)bend1.y, (double)bend2.y)) {
                            lastSegment = new VerticalSegment(bend1, bend2, null, edge);
                            verticalSegments.add(lastSegment);
                            if (first) {
                                first = false;
                                if (bend2.y < cNode.hitbox.y) {
                                    lastSegment.ignoreSpacing.down = true;
                                } else if (bend2.y > cNode.hitbox.y + cNode.hitbox.height) {
                                    lastSegment.ignoreSpacing.up = true;
                                } else {
                                    lastSegment.ignoreSpacing.up = true;
                                    lastSegment.ignoreSpacing.down = true;
                                }
                            }
                        }
                        if (!bends.hasNext()) continue;
                        bend1 = bend2;
                    }
                    if (lastSegment == null) continue;
                    CNode cTargetNode = this.nodesMap.get(edge.getTarget().getNode());
                    if (bend1.y < cTargetNode.hitbox.y) {
                        lastSegment.ignoreSpacing.down = true;
                        continue;
                    }
                    if (bend1.y > cTargetNode.hitbox.y + cTargetNode.hitbox.height) {
                        lastSegment.ignoreSpacing.up = true;
                        continue;
                    }
                    lastSegment.ignoreSpacing.up = true;
                    lastSegment.ignoreSpacing.down = true;
                }
                for (LEdge edge : node.getIncomingEdges()) {
                    if (edge.getBendPoints().isEmpty()) continue;
                    KVector bend1 = (KVector)edge.getBendPoints().getLast();
                    if (edge.getTarget().getSide() == PortSide.NORTH) {
                        VerticalSegment vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y), cNode, edge);
                        vs.ignoreSpacing.down = true;
                        vs.aPort = edge.getTarget();
                        verticalSegments.add(vs);
                    }
                    if (edge.getTarget().getSide() != PortSide.SOUTH) continue;
                    VerticalSegment vs = new VerticalSegment(bend1, new KVector(bend1.x, cNode.hitbox.y + cNode.hitbox.height), cNode, edge);
                    vs.ignoreSpacing.up = true;
                    vs.aPort = edge.getTarget();
                    verticalSegments.add(vs);
                }
            }
        }
        return verticalSegments;
    }

    private List<VerticalSegment> collectVerticalSegmentsSplines() {
        ArrayList verticalSegments = Lists.newArrayList();
        this.layeredGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).flatMap(n -> StreamSupport.stream(n.getOutgoingEdges().spliterator(), false)).map(out -> out.getProperty(InternalProperties.SPLINE_ROUTE_START)).filter(Objects::nonNull).forEach(spline -> {
            VerticalSegment lastVs = null;
            for (SplineSegment s : spline) {
                if (s.isStraight) continue;
                KVector leftTop = s.boundingBox.getTopLeft();
                KVector rightBottom = s.boundingBox.getBottomRight();
                VerticalSegment vs = new VerticalSegment(leftTop, rightBottom, null, s.edges.iterator().next());
                vs.affectedBoundingBoxes.add(s.boundingBox);
                verticalSegments.add(vs);
                if (lastVs != null) {
                    lastVs.constraints.add(vs);
                }
                lastVs = vs;
            }
        });
        return verticalSegments;
    }

    private void mergeVerticalSegments(List<VerticalSegment> verticalSegments) {
        if (verticalSegments.isEmpty()) {
            return;
        }
        Collections.sort(verticalSegments);
        Iterator<VerticalSegment> vsIt = verticalSegments.iterator();
        VerticalSegment survivor = vsIt.next();
        while (vsIt.hasNext()) {
            VerticalSegment next = vsIt.next();
            if (survivor.intersects(next)) {
                survivor = survivor.joinWith(next);
                continue;
            }
            this.verticalSegmentToCNode(survivor);
            survivor = next;
        }
        this.verticalSegmentToCNode(survivor);
    }

    private void verticalSegmentToCNode(VerticalSegment verticalSegment) {
        CNode cNode = CNode.of().origin((Object)verticalSegment).type("vs").hitbox(new ElkRectangle(verticalSegment.hitbox)).toStringDelegate(VS_TO_STRING_DELEGATE).create(this.cGraph);
        if (!verticalSegment.potentialGroupParents.isEmpty()) {
            verticalSegment.potentialGroupParents.get((int)0).cGroup.addCNode(cNode);
        }
        Quadruplet vsLock = new Quadruplet();
        this.lockMap.put(cNode, vsLock);
        HashSet inc = Sets.newHashSet();
        HashSet out = Sets.newHashSet();
        for (LEdge e : verticalSegment.representedLEdges) {
            inc.add(e.getSource());
            out.add(e.getTarget());
        }
        int difference = inc.size() - out.size();
        if (difference < 0) {
            vsLock.set(true, Direction.LEFT);
            vsLock.set(false, Direction.RIGHT);
        } else if (difference > 0) {
            vsLock.set(false, Direction.LEFT);
            vsLock.set(true, Direction.RIGHT);
        }
        verticalSegment.joined.forEach(other -> {
            CNode cNode2 = this.verticalSegmentsMap.put((VerticalSegment)other, cNode);
        });
        this.verticalSegmentsMap.put(verticalSegment, cNode);
    }

    public void applyLayout() {
        this.cGraph.cNodes.stream().filter(cNode -> cNode.origin instanceof LNode).forEach(cNode -> {
            LNode lNode = (LNode)cNode.origin;
            lNode.getPosition().x = cNode.hitbox.x + lNode.getMargin().left;
        });
        this.applyCommentPositions();
        this.cGraph.cNodes.stream().filter(cNode -> cNode.origin instanceof VerticalSegment).forEach(cNode -> {
            double deltaX = cNode.hitbox.x - cNode.hitboxPreCompaction.x;
            VerticalSegment vs = (VerticalSegment)cNode.origin;
            vs.affectedBends.forEach(b -> {
                double d2 = b.x = b.x + deltaX;
            });
            vs.affectedBoundingBoxes.forEach(bb -> {
                double d2 = bb.x = bb.x + deltaX;
            });
            vs.junctionPoints.forEach(jp -> {
                double d2 = jp.x = jp.x + deltaX;
            });
        });
        if (this.edgeRouting == EdgeRouting.SPLINES) {
            this.nodesMap.keySet().stream().flatMap(n -> StreamSupport.stream(n.getOutgoingEdges().spliterator(), false)).filter(e -> e.isSelfLoop()).forEach(sl -> {
                LNode lNode = sl.getSource().getNode();
                CNode cNode = this.nodesMap.get(lNode);
                double deltaX = cNode.hitbox.x - cNode.hitboxPreCompaction.x;
                sl.getBendPoints().offset(deltaX, 0.0);
            });
            this.layeredGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).flatMap(n -> StreamSupport.stream(n.getOutgoingEdges().spliterator(), false)).map(e -> e.getProperty(InternalProperties.SPLINE_ROUTE_START)).filter(chain -> chain != null && !chain.isEmpty()).forEach(spline -> this.adjustSplineControlPoints((List<SplineSegment>)spline));
        }
        KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode2 : this.cGraph.cNodes) {
            topLeft.x = Math.min(topLeft.x, cNode2.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode2.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode2.hitbox.x + cNode2.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode2.hitbox.y + cNode2.hitbox.height);
        }
        this.layeredGraph.getOffset().reset().add(topLeft.clone().negate());
        this.layeredGraph.getSize().reset().add(bottomRight.clone().sub(topLeft));
        this.applyExternalPortPositions(topLeft, bottomRight);
        this.cleanup();
    }

    private void adjustSplineControlPoints(List<SplineSegment> spline) {
        if (spline.isEmpty()) {
            return;
        }
        SplineSegment lastSeg = spline.get(0);
        if (spline.size() == 1) {
            this.adjustControlPointBetweenSegments(lastSeg, lastSeg, 1, 0, spline);
            return;
        }
        int i = 1;
        while (i < spline.size()) {
            Pair<Integer, SplineSegment> needle;
            if (!lastSeg.initialSegment && lastSeg.isStraight || (needle = this.firstNonStraightSegment(spline, i)) == null) continue;
            int j = needle.getFirst();
            SplineSegment nextSeg = needle.getSecond();
            this.adjustControlPointBetweenSegments(lastSeg, nextSeg, i, j, spline);
            i = j + 1;
            lastSeg = nextSeg;
        }
    }

    private Pair<Integer, SplineSegment> firstNonStraightSegment(List<SplineSegment> spline, int index) {
        if (index < 0 || index >= spline.size()) {
            return null;
        }
        int i = index;
        while (i < spline.size()) {
            SplineSegment seg = spline.get(i);
            if (i == spline.size() - 1 || !seg.isStraight) {
                return Pair.of(i, seg);
            }
            ++i;
        }
        return null;
    }

    private void adjustControlPointBetweenSegments(SplineSegment left, SplineSegment right2, int leftIdx, int rightIdx, List<SplineSegment> spline) {
        double endX;
        double startX;
        int idx1 = leftIdx;
        if (left.initialSegment && left.isStraight) {
            CNode n = this.nodesMap.get(left.sourceNode);
            startX = n.hitbox.x + n.hitbox.width;
            --idx1;
        } else {
            startX = left.boundingBox.x + left.boundingBox.width;
        }
        int idx2 = rightIdx;
        if (right2.lastSegment && right2.isStraight) {
            CNode n = this.nodesMap.get(right2.targetNode);
            endX = n.hitbox.x;
            ++idx2;
        } else {
            endX = right2.boundingBox.x;
        }
        double strip = endX - startX;
        int chunks = Math.max(2, idx2 - idx1);
        double chunk = strip / (double)chunks;
        double newPos = startX + chunk;
        int k = idx1;
        while (k < idx2) {
            SplineSegment adjust = spline.get(k);
            double width = adjust.boundingBox.width;
            adjust.boundingBox.x = newPos - width / 2.0;
            newPos += chunk;
            ++k;
        }
    }

    private void applyCommentPositions() {
        for (Map.Entry<LNode, Pair<LNode, KVector>> e : this.commentOffsets.entrySet()) {
            LNode comment = e.getKey();
            LNode other = e.getValue().getFirst();
            KVector offset2 = e.getValue().getSecond();
            comment.getPosition().reset().add(other.getPosition().clone().add(offset2));
        }
    }

    private void applyExternalPortPositions(KVector topLeft, KVector bottomRight) {
        for (CNode cNode : this.cGraph.cNodes) {
            LNode lNode = HorizontalGraphCompactor.getLNodeOrNull(cNode);
            if (lNode == null || lNode.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            switch (lNode.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case WEST: {
                    lNode.getPosition().x = topLeft.x;
                    break;
                }
                case EAST: {
                    lNode.getPosition().x = bottomRight.x - (lNode.getSize().x + lNode.getMargin().right);
                    break;
                }
                case NORTH: {
                    lNode.getPosition().y = topLeft.y;
                    break;
                }
                case SOUTH: {
                    lNode.getPosition().y = bottomRight.y - (lNode.getSize().y + lNode.getMargin().bottom);
                }
            }
        }
    }

    private void cleanup() {
        this.nodesMap.clear();
        this.commentOffsets.clear();
        this.verticalSegmentsMap.clear();
        this.lockMap.clear();
        this.cGraph.cGroups.clear();
        this.cGraph.cNodes.clear();
        this.cGraph = null;
        this.layeredGraph = null;
    }
}

