/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.splines.ConnectedSelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.splines.LoopSide;
import org.eclipse.elk.alg.layered.p5edges.splines.NubsSelfLoop;
import org.eclipse.elk.alg.layered.p5edges.splines.Rectangle;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SplineSelfLoopRouter
implements ILayoutProcessor<LGraph> {
    private static final double MIN_SIDE_HEIGHT = 15.0;
    private static final double MIN_CORNER_SOURCE_LENGTH = 15.0;
    private static final double MIN_CORNER_TARGET_LENGTH = 15.0;
    private static final double MIN_ACROSS_SOURCE_LENGTH = 15.0;
    private static final double MIN_ACROSS_MID_HEIGHT = 15.0;
    private static final double MIN_ACROSS_TARGET_LENGTH = 15.0;
    private static final double SPACE_FOR_EDGE = 15.0;
    private static final double LABEL_Y_DISTANCE = 0.5;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Spline SelfLoop routing", 1.0f);
        SelfLoopEdge.StepSizeComparator stepSizeComparator = new SelfLoopEdge.StepSizeComparator();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                List<LPort> ports = node.getPorts();
                LinkedHashSet loopEdges = Sets.newLinkedHashSet();
                for (ConnectedSelfLoopComponent component : node.getProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS)) {
                    loopEdges.addAll(component.getEdges());
                }
                ArrayList selfLoops = Lists.newArrayList();
                for (LEdge edge : loopEdges) {
                    LPort sourcePort = edge.getSource();
                    LPort targetPort = edge.getTarget();
                    Iterator<LPort> iter = edge.getSource().getNode().getPorts().iterator();
                    int sourceIndex = 0;
                    int targetIndex = 0;
                    int found = 0;
                    int index = 0;
                    while (found < 2) {
                        LPort currentPort = iter.next();
                        if (sourcePort.equals(currentPort)) {
                            sourceIndex = index;
                            ++found;
                        }
                        if (targetPort.equals(currentPort)) {
                            targetIndex = index;
                            ++found;
                        }
                        ++index;
                    }
                    LoopSide side = edge.getProperty(InternalProperties.SPLINE_LOOPSIDE);
                    int stepSize = side == LoopSide.NW || side == LoopSide.ENW ? ports.size() - Math.abs(targetIndex - sourceIndex) + 1 : Math.abs(targetIndex - sourceIndex);
                    selfLoops.add(new SelfLoopEdge(sourceIndex, targetIndex, stepSize, side, edge));
                }
                Collections.sort(selfLoops, stepSizeComparator);
                HashSet loopPaddings = Sets.newHashSet();
                Iterator loopIter = selfLoops.iterator();
                if (!loopIter.hasNext()) continue;
                Rectangle loopRectangle = this.processSelfLoop((SelfLoopEdge)loopIter.next(), loopPaddings);
                while (loopIter.hasNext()) {
                    loopRectangle.union(this.processSelfLoop((SelfLoopEdge)loopIter.next(), loopPaddings));
                }
                node.setProperty(InternalProperties.SPLINE_SELF_LOOP_MARGINS, loopRectangle.toNodeMargins(node));
            }
        }
        monitor.done();
    }

    private Rectangle processSelfLoop(SelfLoopEdge selfLoop, Set<LoopPadding> loopPaddings) {
        Rectangle loopRectangle = null;
        LoopPadding.EnclosingPredicate pred = new LoopPadding.EnclosingPredicate(selfLoop);
        ArrayList relevantPaddings = Lists.newArrayList((Iterable)Iterables.filter(loopPaddings, (Predicate)pred));
        Collections.sort(relevantPaddings, new LoopPadding.MarginComparator());
        LoopSide loopSide = selfLoop.loopSide;
        switch (loopSide.getType()) {
            case ACROSS: {
                LoopPadding.PortSidePredicate sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getSourceSide());
                Iterator itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double sourceHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getMiddleSide());
                itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double middleHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getTargetSide());
                itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double targetHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                loopRectangle = this.calculateAcrossSelfLoop(selfLoop, sourceHeight, middleHeight, targetHeight);
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getSourceSide()));
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getMiddleSide()));
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getTargetSide()));
                break;
            }
            case CORNER: {
                LoopPadding.PortSidePredicate sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getSourceSide());
                Iterator itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double sourceHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getTargetSide());
                itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double targetHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                loopRectangle = this.calculateCornerSelfLoop(selfLoop, sourceHeight, targetHeight);
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getSourceSide()));
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getTargetSide()));
                break;
            }
            case SIDE: {
                LoopPadding.PortSidePredicate sidePredicate = new LoopPadding.PortSidePredicate(loopSide.getSourceSide());
                Iterator itr = Iterables.filter((Iterable)relevantPaddings, (Predicate)sidePredicate).iterator();
                double sourceHeight = itr.hasNext() ? ((LoopPadding)itr.next()).padding : 15.0;
                loopRectangle = this.calculateSideSelfLoop(selfLoop, sourceHeight);
                loopPaddings.add(new LoopPadding(loopRectangle, selfLoop.sourceIndex, selfLoop.targetIndex, selfLoop.lEdge.getSource().getNode(), loopSide.getSourceSide()));
                break;
            }
            default: {
                throw new IllegalArgumentException("The loopside must be defined.");
            }
        }
        return loopRectangle;
    }

    private Rectangle calculateCornerSelfLoop(SelfLoopEdge edge, double sourcePadding, double targetPadding) {
        LoopSide side = edge.loopSide;
        double labelLength = 0.0;
        for (LLabel label : edge.lEdge.getLabels()) {
            labelLength = Math.max(labelLength, label.getSize().x);
        }
        NubsSelfLoop nubs = NubsSelfLoop.createCornerSelfLoop(edge.lEdge.getSource(), edge.lEdge.getTarget(), sourcePadding, targetPadding, labelLength);
        edge.lEdge.getBendPoints().addAll(nubs.getBezierCP());
        Rectangle labelMargins = this.placeLabels(edge.lEdge.getLabels(), nubs.getFirstLabelPosition(), side);
        Rectangle edgeMargins = new Rectangle(nubs.getOuterBox());
        edgeMargins.enlarge(15.0);
        if (labelMargins == null) {
            return edgeMargins;
        }
        return Rectangle.union(edgeMargins, labelMargins);
    }

    private Rectangle calculateSideSelfLoop(SelfLoopEdge edge, double padding) {
        LoopSide side = edge.loopSide;
        NubsSelfLoop nubs = NubsSelfLoop.createSideSelfLoop(edge.lEdge.getSource(), edge.lEdge.getTarget(), padding);
        edge.lEdge.getBendPoints().addAll(nubs.getBezierCP());
        Rectangle labelMargins = this.placeLabels(edge.lEdge.getLabels(), nubs.getFirstLabelPosition(), side);
        Rectangle edgeMargins = new Rectangle(nubs.getOuterBox());
        edgeMargins.enlarge(15.0);
        if (labelMargins == null) {
            return edgeMargins;
        }
        return Rectangle.union(edgeMargins, labelMargins);
    }

    private Rectangle calculateAcrossSelfLoop(SelfLoopEdge edge, double sourcePadding, double middlePadding, double targetPadding) {
        double textLength = 0.0;
        for (LLabel label : edge.lEdge.getLabels()) {
            textLength = Math.max(textLength, label.getSize().x);
        }
        NubsSelfLoop nubs = NubsSelfLoop.createAcrossSelfLoop(edge.lEdge.getSource(), sourcePadding, edge.lEdge.getTarget(), targetPadding, edge.loopSide.getMiddleSide(), middlePadding, textLength);
        edge.lEdge.getBendPoints().addAll(nubs.getBezierCP());
        Rectangle labelMargins = this.placeLabels(edge.lEdge.getLabels(), nubs.getFirstLabelPosition(), edge.loopSide);
        Rectangle edgeMargins = new Rectangle(nubs.getOuterBox());
        edgeMargins.enlarge(15.0);
        if (labelMargins == null) {
            return edgeMargins;
        }
        return Rectangle.union(edgeMargins, labelMargins);
    }

    private Rectangle placeLabels(List<LLabel> labels, KVector rawPosition, LoopSide side) {
        Iterator<LLabel> iter = labels.iterator();
        if (iter.hasNext()) {
            LLabel label = iter.next();
            Rectangle allLabels = this.placeLabel(label, rawPosition, side);
            while (iter.hasNext()) {
                label = iter.next();
                allLabels.union(this.placeLabel(label, rawPosition, side));
            }
            return new Rectangle(allLabels);
        }
        return null;
    }

    private Rectangle placeLabel(LLabel label, KVector rawPosition, LoopSide side) {
        KVector thisLabelPosition = new KVector(rawPosition);
        KVector labelSize = new KVector(label.getSize());
        switch (side) {
            case NW: {
                thisLabelPosition.add(-labelSize.x / 2.0, -labelSize.y);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case WS: {
                thisLabelPosition.add(-labelSize.x / 2.0, 0.0);
                rawPosition.add(0.0, 0.5 + labelSize.y);
                break;
            }
            case EN: {
                thisLabelPosition.add(-labelSize.x / 2.0, -labelSize.y);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case SE: {
                thisLabelPosition.add(-labelSize.x / 2.0, 0.0);
                rawPosition.add(0.0, 0.5 + labelSize.y);
                break;
            }
            case N: {
                thisLabelPosition.add(-labelSize.x / 2.0, -labelSize.y);
                rawPosition.add(0.0, -(0.5 + -labelSize.y));
                break;
            }
            case E: {
                thisLabelPosition.add(0.0, -labelSize.y / 2.0);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case S: {
                thisLabelPosition.add(-labelSize.x / 2.0, 0.0);
                rawPosition.add(0.0, 0.5 + labelSize.y);
                break;
            }
            case W: {
                thisLabelPosition.add(-labelSize.x, labelSize.y / 2.0);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case ENW: {
                thisLabelPosition.add(-labelSize.x / 2.0, -labelSize.y);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case ESW: {
                thisLabelPosition.add(-labelSize.x / 2.0, 0.0);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case SEN: {
                thisLabelPosition.add(0.0, -labelSize.y / 2.0);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
            case SWN: {
                thisLabelPosition.add(-labelSize.x, -labelSize.y / 2.0);
                rawPosition.add(0.0, -(0.5 + labelSize.y));
                break;
            }
        }
        label.getPosition().reset().add(thisLabelPosition);
        return new Rectangle(label);
    }

    private static final class LoopPadding {
        private final PortSide side;
        private final int startIndex;
        private final int endIndex;
        private final double padding;

        LoopPadding(Rectangle boundingBox, int sourceIndex, int targetIndex, LShape shape, PortSide side) {
            this.side = side;
            this.startIndex = sourceIndex;
            this.endIndex = targetIndex;
            switch (side) {
                case WEST: {
                    this.padding = Math.abs(boundingBox.getLeft());
                    break;
                }
                case NORTH: {
                    this.padding = Math.abs(boundingBox.getTop());
                    break;
                }
                case EAST: {
                    this.padding = Math.abs(boundingBox.getRight() - shape.getSize().x);
                    break;
                }
                case SOUTH: {
                    this.padding = Math.abs(boundingBox.getBottom() - shape.getSize().y);
                    break;
                }
                default: {
                    this.padding = 0.0;
                }
            }
        }

        public String toString() {
            return String.valueOf(this.padding) + ": " + this.startIndex + " -> " + this.endIndex + " " + this.side.toString();
        }

        private static class EnclosingPredicate
        implements Predicate<LoopPadding> {
            private final LoopSide loopSide;
            private final int startIndex;
            private final int endIndex;

            public EnclosingPredicate(SelfLoopEdge edge) {
                this.startIndex = edge.sourceIndex;
                this.endIndex = edge.targetIndex;
                this.loopSide = edge.loopSide;
            }

            public boolean apply(LoopPadding margin) {
                if (!this.loopSide.getPortSides().contains((Object)margin.side)) {
                    return false;
                }
                if (this.loopSide.viaNW()) {
                    return !SplinesMath.isBetween(margin.startIndex, this.startIndex, this.endIndex) || !SplinesMath.isBetween(margin.endIndex, this.startIndex, this.endIndex);
                }
                return SplinesMath.isBetween(margin.startIndex, this.startIndex, this.endIndex) && SplinesMath.isBetween(margin.endIndex, this.startIndex, this.endIndex);
            }
        }

        public static class MarginComparator
        implements Comparator<LoopPadding> {
            @Override
            public int compare(LoopPadding margin0, LoopPadding margin1) {
                return Double.compare(margin1.padding, margin0.padding);
            }
        }

        private static class PortSidePredicate
        implements Predicate<LoopPadding> {
            private final PortSide side;

            public PortSidePredicate(PortSide side) {
                this.side = side;
            }

            public boolean apply(LoopPadding margin) {
                return margin.side == this.side;
            }
        }
    }

    private static final class SelfLoopEdge {
        private final int sourceIndex;
        private final int targetIndex;
        private final int stepSize;
        private final LoopSide loopSide;
        private final LEdge lEdge;

        SelfLoopEdge(int sourceIndex, int targetIndex, int stepSize, LoopSide loopSide, LEdge edge) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
            this.stepSize = stepSize;
            this.loopSide = loopSide;
            this.lEdge = edge;
        }

        private static class StepSizeComparator
        implements Comparator<SelfLoopEdge> {
            private StepSizeComparator() {
            }

            @Override
            public int compare(SelfLoopEdge edge0, SelfLoopEdge edge1) {
                return edge0.stepSize - edge1.stepSize;
            }
        }
    }
}

