/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.splines.ConnectedSelfLoopComponent;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SplineSelfLoopPreProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Spline SelfLoop pre-processing.", 1.0f);
        LinkedHashSet loopEdges = Sets.newLinkedHashSet();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            this.correctPortSideConstraint(node);
            loopEdges.clear();
            for (LEdge edge : node.getOutgoingEdges()) {
                if (!edge.isSelfLoop()) continue;
                loopEdges.add(edge);
            }
            for (LEdge edge : loopEdges) {
                PortSide sourcePortSide = edge.getSource().getSide();
                PortSide targetPortSide = edge.getTarget().getSide();
                if (!(sourcePortSide == PortSide.NORTH && (targetPortSide == PortSide.EAST || targetPortSide == PortSide.SOUTH) || sourcePortSide == PortSide.EAST && targetPortSide == PortSide.SOUTH || sourcePortSide == PortSide.SOUTH && targetPortSide == PortSide.WEST) && (sourcePortSide != PortSide.WEST || targetPortSide != PortSide.NORTH && targetPortSide != PortSide.EAST)) continue;
                edge.reverse(layeredGraph, false);
            }
            List<ConnectedSelfLoopComponent> allComponents = SplineSelfLoopPreProcessor.findAllConnectedComponents(loopEdges, node);
            node.setProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS, allComponents);
            if (node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isOrderFixed()) continue;
            HashSet portsToHide = Sets.newHashSet();
            for (ConnectedSelfLoopComponent component : allComponents) {
                portsToHide.addAll(component.getHidablePorts());
                portsToHide.addAll(component.getPortsWithPortSide());
            }
            ListIterator<LPort> itr = node.getPorts().listIterator();
            while (itr.hasNext()) {
                LPort port = (LPort)itr.next();
                if (!portsToHide.contains(port)) continue;
                itr.remove();
            }
        }
        monitor.done();
    }

    private void correctPortSideConstraint(LNode node) {
        if (!node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
            for (LPort port : node.getPorts()) {
                port.setSide(PortSide.UNDEFINED);
            }
        }
    }

    private static List<ConnectedSelfLoopComponent> findAllConnectedComponents(Set<LEdge> loopEdges, LNode node) {
        ArrayList components = Lists.newArrayList();
        LinkedListMultimap portToEdge = LinkedListMultimap.create();
        for (LEdge edge : loopEdges) {
            portToEdge.put((Object)edge.getSource(), (Object)edge);
            portToEdge.put((Object)edge.getTarget(), (Object)edge);
        }
        while (!portToEdge.isEmpty()) {
            components.add(SplineSelfLoopPreProcessor.findAConnectedComponent((Multimap<LPort, LEdge>)portToEdge, node, node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isOrderFixed()));
        }
        return components;
    }

    private static ConnectedSelfLoopComponent findAConnectedComponent(Multimap<LPort, LEdge> portsToEdges, LNode node, boolean isFixedOrder) {
        ArrayListMultimap edgeToPort = ArrayListMultimap.create();
        Multimaps.invertFrom(portsToEdges, (Multimap)edgeToPort);
        ConnectedSelfLoopComponent connectedComponent = new ConnectedSelfLoopComponent(node);
        ArrayList portsToProcess = Lists.newArrayList();
        portsToProcess.add((LPort)portsToEdges.keys().iterator().next());
        ArrayList portsProcessed = Lists.newArrayList();
        while (!portsToProcess.isEmpty()) {
            LPort currentPort = (LPort)portsToProcess.iterator().next();
            portsProcessed.add(currentPort);
            Collection allEdgesOnCurrentPort = portsToEdges.removeAll((Object)currentPort);
            for (LEdge currentEdge : allEdgesOnCurrentPort) {
                if (!connectedComponent.tryAddEdge(currentEdge, isFixedOrder)) continue;
                Collection portsOfCurrentEdge = edgeToPort.removeAll((Object)currentEdge);
                for (LPort port : portsOfCurrentEdge) {
                    if (portsProcessed.contains(port)) continue;
                    portsToProcess.add(port);
                }
            }
            portsToProcess.remove(currentPort);
        }
        return connectedComponent;
    }
}

