/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SelfLoopPlacement;
import org.eclipse.elk.alg.layered.p5edges.splines.ConnectedSelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.splines.LoopSide;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SplineSelfLoopPositioner
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Spline SelfLoop positioning", 1.0f);
        SelfLoopPlacement loopPlacement = layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_PLACEMENT);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                List<ConnectedSelfLoopComponent> components = node.getProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS);
                ArrayList componentsToBePlaced = Lists.newArrayList();
                for (ConnectedSelfLoopComponent component : components) {
                    component.unhideEdges();
                    if (component.getConstrainedPorts().isEmpty()) {
                        componentsToBePlaced.add(component);
                        continue;
                    }
                    this.setPortSideByConstraint(component);
                    if (component.getNonLoopPorts().isEmpty()) continue;
                    this.addComponentWithNonLoopEdges(component);
                }
                switch (loopPlacement) {
                    case EQUALLY_DISTRIBUTED: {
                        SplineSelfLoopPositioner.setPortSideSpreadEqually(componentsToBePlaced, node);
                        break;
                    }
                    case NORTH_SEQUENCE: {
                        for (ConnectedSelfLoopComponent component : componentsToBePlaced) {
                            component.setLoopSide(LoopSide.N, true);
                        }
                        break;
                    }
                    case NORTH_STACKED: {
                        for (ConnectedSelfLoopComponent component : componentsToBePlaced) {
                            component.setLoopSide(LoopSide.N, true);
                        }
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                switch (loopPlacement) {
                    case EQUALLY_DISTRIBUTED: 
                    case NORTH_STACKED: {
                        this.portStackedPositioning(components);
                        break;
                    }
                    case NORTH_SEQUENCE: {
                        this.portLinedPositioning(components);
                        break;
                    }
                }
            }
        }
        monitor.done();
    }

    public void addComponentWithNonLoopEdges(ConnectedSelfLoopComponent component) {
        LNode node = component.getNode();
        HashSet hiddenPorts = Sets.newHashSet(component.getHidablePorts());
        ListIterator<LPort> portsWithSideIter = Lists.newLinkedList(component.getNonLoopPorts()).listIterator();
        while (portsWithSideIter.hasNext()) {
            LPort portOnNode;
            ListIterator<LPort> nodePortIter;
            LPort hiddenPort;
            LPort portWithSide = (LPort)portsWithSideIter.next();
            if (portWithSide.getOutgoingEdges().isEmpty()) {
                for (LEdge edgeWithHiddenPort : portWithSide.getIncomingEdges()) {
                    hiddenPort = edgeWithHiddenPort.getSource();
                    if (!hiddenPorts.contains(hiddenPort)) continue;
                    nodePortIter = node.getPorts().listIterator();
                    portOnNode = nodePortIter.next();
                    while (!portOnNode.equals(portWithSide)) {
                        portOnNode = nodePortIter.next();
                    }
                    nodePortIter.add(hiddenPort);
                    portsWithSideIter.add(hiddenPort);
                    SplineSelfLoopPositioner.setSideOfPort(hiddenPort, portWithSide.getSide());
                    portsWithSideIter.previous();
                    portsWithSideIter.previous();
                    hiddenPorts.remove(hiddenPort);
                }
                continue;
            }
            for (LEdge edgeWithHiddenPort : portWithSide.getOutgoingEdges()) {
                hiddenPort = edgeWithHiddenPort.getTarget();
                if (!hiddenPorts.contains(hiddenPort)) continue;
                nodePortIter = node.getPorts().listIterator();
                portOnNode = nodePortIter.next();
                while (!portOnNode.equals(portWithSide)) {
                    portOnNode = nodePortIter.next();
                }
                nodePortIter.previous();
                nodePortIter.add(hiddenPort);
                portsWithSideIter.add(hiddenPort);
                SplineSelfLoopPositioner.setSideOfPort(hiddenPort, portWithSide.getSide());
                portsWithSideIter.previous();
                portsWithSideIter.previous();
                hiddenPorts.remove(hiddenPort);
            }
        }
    }

    private void portLinedPositioning(List<ConnectedSelfLoopComponent> components) {
        if (components.isEmpty()) {
            return;
        }
        LNode node = components.get(0).getNode();
        PortReadder compHolder = new PortReadder(components);
        ListIterator<LPort> itr = node.getPorts().listIterator();
        compHolder.addSourcePortsReversed(LoopSide.NW, itr);
        compHolder.addTargetPorts(LoopSide.SWN, itr);
        this.findNextSide(PortSide.NORTH, itr);
        compHolder.addInlineTargetsFirst(LoopSide.N, itr);
        compHolder.addTargetPorts(LoopSide.SEN, itr);
        compHolder.addAllPorts(LoopSide.EN, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.ENW, itr);
        this.findNextSide(PortSide.EAST, itr);
        compHolder.addInlineTargetsFirst(LoopSide.E, itr);
        compHolder.addSourcePortsReversed(LoopSide.ESW, itr);
        compHolder.addAllPorts(LoopSide.SE, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.SEN, itr);
        this.findNextSide(PortSide.SOUTH, itr);
        compHolder.addInlineTargetsFirst(LoopSide.S, itr);
        compHolder.addSourcePortsReversed(LoopSide.SWN, itr);
        compHolder.addAllPorts(LoopSide.WS, itr, false);
        compHolder.addTargetPorts(LoopSide.ESW, itr);
        while (itr.hasNext()) {
            itr.next();
        }
        compHolder.addInlineTargetsFirst(LoopSide.W, itr);
        compHolder.addTargetPorts(LoopSide.ENW, itr);
        compHolder.addTargetPorts(LoopSide.NW, itr);
    }

    private void portStackedPositioning(List<ConnectedSelfLoopComponent> components) {
        if (components.isEmpty()) {
            return;
        }
        LNode node = components.get(0).getNode();
        PortReadder compHolder = new PortReadder(components);
        ListIterator<LPort> itr = node.getPorts().listIterator();
        compHolder.addSourcePortsReversed(LoopSide.NW, itr);
        compHolder.addTargetPorts(LoopSide.SWN, itr);
        this.findNextSide(PortSide.NORTH, itr);
        compHolder.addAllPorts(LoopSide.N, itr, false);
        compHolder.addTargetPorts(LoopSide.SEN, itr);
        compHolder.addAllPorts(LoopSide.EN, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.ENW, itr);
        this.findNextSide(PortSide.EAST, itr);
        compHolder.addAllPorts(LoopSide.E, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.ESW, itr);
        compHolder.addAllPorts(LoopSide.SE, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.SEN, itr);
        this.findNextSide(PortSide.SOUTH, itr);
        compHolder.addAllPorts(LoopSide.S, itr, false);
        compHolder.addSourcePortsReversed(LoopSide.SWN, itr);
        compHolder.addAllPorts(LoopSide.WS, itr, false);
        compHolder.addTargetPorts(LoopSide.ESW, itr);
        while (itr.hasNext()) {
            itr.next();
        }
        compHolder.addAllPorts(LoopSide.W, itr, false);
        compHolder.addTargetPorts(LoopSide.ENW, itr);
        compHolder.addTargetPorts(LoopSide.NW, itr);
    }

    private void findNextSide(PortSide startSide, ListIterator<LPort> itr) {
        PortSide currentSide = startSide;
        while (itr.hasNext() && currentSide.equals((Object)startSide)) {
            currentSide = itr.next().getSide();
        }
        if (!currentSide.equals((Object)startSide)) {
            itr.previous();
        }
    }

    private LoopSide setPortSideByConstraint(ConnectedSelfLoopComponent component) {
        Iterator iter = Iterators.cycle((Iterable)Lists.newArrayList(component.getEdges()));
        EnumSet<LoopSide> loopSidesInComponent = EnumSet.noneOf(LoopSide.class);
        while (iter.hasNext()) {
            LoopSide side;
            LEdge edge = (LEdge)iter.next();
            PortSide sourceSide = edge.getSource().getSide();
            PortSide targetSide = edge.getTarget().getSide();
            if (sourceSide == PortSide.UNDEFINED) {
                if (targetSide == PortSide.UNDEFINED) continue;
                side = LoopSide.fromPortSides(targetSide);
                edge.setProperty(InternalProperties.SPLINE_LOOPSIDE, (Object)side);
                edge.getSource().setSide(targetSide);
                loopSidesInComponent.add(side);
                iter.remove();
                continue;
            }
            if (targetSide == PortSide.UNDEFINED) {
                side = LoopSide.fromPortSides(sourceSide);
                edge.setProperty(InternalProperties.SPLINE_LOOPSIDE, (Object)side);
                edge.getTarget().setSide(sourceSide);
                loopSidesInComponent.add(side);
                iter.remove();
                continue;
            }
            side = LoopSide.fromPortSide(sourceSide, targetSide);
            edge.setProperty(InternalProperties.SPLINE_LOOPSIDE, (Object)side);
            loopSidesInComponent.add(side);
            iter.remove();
        }
        LoopSide side = loopSidesInComponent.size() == 1 ? (LoopSide)((Object)loopSidesInComponent.iterator().next()) : LoopSide.UNDEFINED;
        component.setLoopSide(side, false);
        return side;
    }

    private static void setSideOfPort(LPort port, PortSide side) {
        switch (side) {
            case EAST: {
                port.setSide(PortSide.EAST);
                port.getAnchor().x = port.getSize().x;
                port.getAnchor().y = port.getSize().y / 2.0;
                break;
            }
            case WEST: {
                port.setSide(PortSide.WEST);
                port.getAnchor().x = 0.0;
                port.getAnchor().y = port.getSize().y / 2.0;
                break;
            }
            case NORTH: {
                port.setSide(PortSide.NORTH);
                port.getAnchor().x = port.getSize().x / 2.0;
                port.getAnchor().y = 0.0;
                break;
            }
            case SOUTH: {
                port.setSide(PortSide.SOUTH);
                port.getAnchor().x = port.getSize().x / 2.0;
                port.getAnchor().y = port.getSize().y;
            }
        }
    }

    private static void setSideOfPorts(Iterable<LPort> ports, PortSide side) {
        for (LPort port : ports) {
            SplineSelfLoopPositioner.setSideOfPort(port, side);
        }
    }

    private static void setPortSideSpreadEqually(List<ConnectedSelfLoopComponent> components, LNode node) {
        DistributedLoopSidesCalculator loopSideCalculator = new DistributedLoopSidesCalculator(node);
        loopSideCalculator.removeOccupiedSides();
        loopSideCalculator.calculate(components);
    }

    private static class DistributedLoopSidesCalculator {
        private static final int MAX_TEXT_LENGTH = 50;
        private final SortedLoopSides loopSides = new SortedLoopSides();
        private final LNode node;

        public DistributedLoopSidesCalculator(LNode node) {
            this.node = node;
        }

        public void removeOccupiedSides() {
            for (LPort port : this.node.getPorts()) {
                this.loopSides.removeSide(LoopSide.fromPortSides(port.getSide()));
            }
        }

        public void calculate(List<ConnectedSelfLoopComponent> components) {
            ArrayList withLongText = Lists.newArrayList();
            ArrayList withShortText = Lists.newArrayList();
            ArrayList withoutText = Lists.newArrayList();
            for (ConnectedSelfLoopComponent component : components) {
                if (component.getTextWidth() > 50.0) {
                    withLongText.add(component);
                    continue;
                }
                if (component.getTextWidth() > 0.0) {
                    withShortText.add(component);
                    continue;
                }
                withoutText.add(component);
            }
            if (withShortText.size() == 1 && withLongText.isEmpty()) {
                withLongText.addAll(withShortText);
                withShortText.clear();
            }
            if (!withLongText.isEmpty() && this.loopSides.availableSides().contains((Object)LoopSide.N) && this.loopSides.availableSides().contains((Object)LoopSide.S)) {
                this.assignAcrossSide(withLongText);
            } else {
                withShortText.addAll(withLongText);
            }
            if (!withShortText.isEmpty()) {
                this.assignCornerSide(withShortText);
            }
            if (!withoutText.isEmpty()) {
                EnumSet availableStraights = this.loopSides.availableStraightSides();
                if (!availableStraights.isEmpty()) {
                    Iterator itrComponent = withoutText.iterator();
                    Iterator itrAvailable = Iterables.cycle((Iterable)availableStraights).iterator();
                    while (itrComponent.hasNext()) {
                        ConnectedSelfLoopComponent component = (ConnectedSelfLoopComponent)itrComponent.next();
                        while (itrComponent.hasNext() && component.getEdges().size() < 2) {
                            component = (ConnectedSelfLoopComponent)itrComponent.next();
                        }
                        if (component.getEdges().size() <= 1) continue;
                        LoopSide side = (LoopSide)((Object)itrAvailable.next());
                        component.setLoopSide(side, true);
                        itrComponent.remove();
                        this.loopSides.removeSide(side);
                    }
                }
                int number = withoutText.size();
                LoopSide center = this.findCenter();
                ArrayList portSides = Lists.newArrayList();
                int fullSets = number / this.loopSides.availableNotAcrossSides().size();
                int i = 0;
                while (i < fullSets) {
                    portSides.addAll(this.loopSides.availableNotAcrossSides());
                    ++i;
                }
                int remainer = number % this.loopSides.availableNotAcrossSides().size();
                if (remainer > 3) {
                    portSides.addAll(LoopSide.getAllCornerSides());
                    remainer -= 4;
                }
                switch (remainer) {
                    case 3: {
                        portSides.add(center.opposite());
                    }
                    case 2: {
                        LoopSide tmpSide = center.opposite().left();
                        do {
                            tmpSide = tmpSide.left();
                        } while (!this.loopSides.availableSides().contains((Object)tmpSide));
                        portSides.add(tmpSide);
                        tmpSide = center.opposite().right();
                        do {
                            tmpSide = tmpSide.right();
                        } while (!this.loopSides.availableSides().contains((Object)tmpSide));
                        portSides.add(tmpSide);
                        break;
                    }
                    case 1: {
                        portSides.add(center.opposite());
                        break;
                    }
                }
                Iterator itrSides = portSides.iterator();
                Iterator itrComponent = withoutText.iterator();
                while (itrSides.hasNext() && itrComponent.hasNext()) {
                    ((ConnectedSelfLoopComponent)itrComponent.next()).setLoopSide((LoopSide)((Object)itrSides.next()), true);
                }
            }
        }

        private void assignAcrossSide(List<ConnectedSelfLoopComponent> components) {
            for (ConnectedSelfLoopComponent component : components) {
                LoopSide side = this.loopSides.getLeastCrowdedHorizontalCrossing();
                this.loopSides.addSize(side, component.getTextWidth(), component.getTextHeight());
                component.setLoopSide(side, true);
            }
        }

        private void assignCornerSide(List<ConnectedSelfLoopComponent> components) {
            for (ConnectedSelfLoopComponent component : components) {
                LoopSide side = this.loopSides.getLeastCrowdedCorner();
                this.loopSides.addSize(side, component.getTextWidth(), component.getTextHeight());
                component.setLoopSide(side, true);
            }
        }

        private LoopSide findCenter() {
            switch (this.loopSides.availableStraightSides().size()) {
                case 4: {
                    return LoopSide.S;
                }
                case 3: {
                    return (LoopSide)((Object)this.loopSides.allRemovedStraightSides().iterator().next());
                }
                case 2: {
                    EnumSet retVal = this.loopSides.availableStraightSides();
                    Iterator itr = retVal.iterator();
                    LoopSide first = (LoopSide)((Object)itr.next());
                    LoopSide second = (LoopSide)((Object)itr.next());
                    if (first.opposite() == second) {
                        if (retVal.contains((Object)LoopSide.S)) {
                            return LoopSide.E;
                        }
                        return LoopSide.S;
                    }
                    if (first.left().left() == second) {
                        return first.left();
                    }
                    return first.right();
                }
                case 1: {
                    EnumSet retVal = this.loopSides.availableStraightSides();
                    return ((LoopSide)((Object)retVal.iterator().next())).opposite();
                }
                case 0: {
                    return LoopSide.SE;
                }
            }
            return null;
        }

        private static final class SortedLoopSides {
            private static final double EPSILON = 1.0E-8;
            private final Map<LoopSide, SizeOfSide> sizeMap = Maps.newLinkedHashMap();
            private boolean sideRemovedOrChanged = true;
            private final EnumSet<LoopSide> availableSides = EnumSet.noneOf(LoopSide.class);
            private final EnumSet<LoopSide> availableStraightSides = EnumSet.noneOf(LoopSide.class);
            private final EnumSet<LoopSide> availableNotAcrossSides = EnumSet.noneOf(LoopSide.class);

            public SortedLoopSides() {
                for (LoopSide side : LoopSide.getAllDefinedSides()) {
                    this.sizeMap.put(side, new SizeOfSide(0.0, 0.0));
                }
            }

            private void addSize(LoopSide side, double addedWidth, double addedHeight) {
                SizeOfSide size = this.sizeMap.get((Object)side);
                size.addWidth(addedWidth);
                size.addHeight(addedHeight);
                this.sizeMap.put(side, size);
                this.sideRemovedOrChanged = true;
            }

            private LoopSide getLeastCrowdedCorner() {
                double minHeight = Double.POSITIVE_INFINITY;
                double minWidth = Double.POSITIVE_INFINITY;
                LoopSide minSide = null;
                for (Map.Entry<LoopSide, SizeOfSide> entry : this.sizeMap.entrySet()) {
                    boolean isNotHigherAndLessWide;
                    if (!entry.getKey().isCorner()) continue;
                    double height = entry.getValue().getHeight();
                    double width = entry.getValue().getWidth();
                    boolean isLessHigh = minHeight - height > 1.0E-8;
                    boolean bl = isNotHigherAndLessWide = height - minHeight < 1.0E-8 && minWidth - width > 1.0E-8;
                    if (!isLessHigh && !isNotHigherAndLessWide) continue;
                    minWidth = entry.getValue().getWidth();
                    minHeight = entry.getValue().getHeight();
                    minSide = entry.getKey();
                    if (minWidth != 0.0 || minHeight != 0.0) continue;
                    return minSide;
                }
                return minSide;
            }

            private LoopSide getLeastCrowdedHorizontalCrossing() {
                double minHeight = Double.POSITIVE_INFINITY;
                double minWidth = Double.POSITIVE_INFINITY;
                LoopSide minSide = null;
                for (Map.Entry<LoopSide, SizeOfSide> entry : this.sizeMap.entrySet()) {
                    boolean isNotHigherAndLessWide;
                    if (entry.getKey() != LoopSide.ENW && entry.getKey() != LoopSide.ESW) continue;
                    double height = entry.getValue().getHeight();
                    double width = entry.getValue().getWidth();
                    boolean isLessHigh = minHeight - height > 1.0E-8;
                    boolean bl = isNotHigherAndLessWide = height - minHeight < 1.0E-8 && minWidth - width > 1.0E-8;
                    if (!isLessHigh && !isNotHigherAndLessWide) continue;
                    minWidth = entry.getValue().getWidth();
                    minHeight = entry.getValue().getHeight();
                    minSide = entry.getKey();
                    if (minWidth != 0.0 || minHeight != 0.0) continue;
                    return minSide;
                }
                return minSide;
            }

            private void removeSide(LoopSide side) {
                SizeOfSide wasRemoved = this.sizeMap.remove((Object)side);
                if (wasRemoved != null) {
                    this.sideRemovedOrChanged = true;
                }
            }

            private EnumSet<LoopSide> availableStraightSides() {
                if (this.sideRemovedOrChanged) {
                    this.updateAvailableSides();
                }
                return this.availableStraightSides;
            }

            private EnumSet<LoopSide> availableSides() {
                if (this.sideRemovedOrChanged) {
                    this.updateAvailableSides();
                }
                return this.availableSides;
            }

            private EnumSet<LoopSide> availableNotAcrossSides() {
                if (this.sideRemovedOrChanged) {
                    this.updateAvailableSides();
                }
                return this.availableNotAcrossSides;
            }

            private void updateAvailableSides() {
                this.availableStraightSides.clear();
                this.availableSides.clear();
                this.availableNotAcrossSides.clear();
                for (LoopSide side : this.sizeMap.keySet()) {
                    if (!side.isAcross()) {
                        this.availableNotAcrossSides.add(side);
                        if (side.isStraight()) {
                            this.availableStraightSides.add(side);
                        }
                    }
                    this.availableSides.add(side);
                }
                this.sideRemovedOrChanged = false;
            }

            private Set<LoopSide> allRemovedStraightSides() {
                Set<LoopSide> retVal = LoopSide.getAllStraightSides();
                retVal.removeAll(this.availableStraightSides());
                return retVal;
            }

            private static class SizeOfSide {
                private double width;
                private double height;

                SizeOfSide(double width, double height) {
                    this.width = width;
                    this.height = height;
                }

                void addWidth(double w) {
                    this.width += w;
                }

                double getWidth() {
                    return this.width;
                }

                void addHeight(double h) {
                    this.height += h;
                }

                double getHeight() {
                    return this.height;
                }
            }
        }
    }

    private static final class PortReadder {
        private final Comparator<? super ConnectedSelfLoopComponent> loopSorter = new TextWidthComparator();
        private static final Map<LoopSide, List<ConnectedSelfLoopComponent>> LISTS_OF_COMPONENTS = new EnumMap<LoopSide, List<ConnectedSelfLoopComponent>>(LoopSide.class);
        private final List<ConnectedSelfLoopComponent> withNonSelfLoop = Lists.newArrayList();
        private final List<LPort> allHiddenPorts = Lists.newArrayList();

        static {
            LoopSide[] loopSideArray = LoopSide.values();
            int n = loopSideArray.length;
            int n2 = 0;
            while (n2 < n) {
                LoopSide side = loopSideArray[n2];
                LISTS_OF_COMPONENTS.put(side, null);
                ++n2;
            }
        }

        PortReadder(List<ConnectedSelfLoopComponent> components) {
            LoopSide[] loopSideArray = LoopSide.values();
            int n = loopSideArray.length;
            int n2 = 0;
            while (n2 < n) {
                LoopSide loopSide = loopSideArray[n2];
                LISTS_OF_COMPONENTS.put(loopSide, new ArrayList());
                ++n2;
            }
            for (ConnectedSelfLoopComponent connectedSelfLoopComponent : components) {
                this.allHiddenPorts.addAll(connectedSelfLoopComponent.getHidablePorts());
                if (connectedSelfLoopComponent.getNonLoopPorts().isEmpty()) {
                    LISTS_OF_COMPONENTS.get((Object)connectedSelfLoopComponent.getLoopSide()).add(connectedSelfLoopComponent);
                    continue;
                }
                this.withNonSelfLoop.add(connectedSelfLoopComponent);
            }
            for (List list : LISTS_OF_COMPONENTS.values()) {
                Collections.sort(list, this.loopSorter);
            }
            Collections.reverse(LISTS_OF_COMPONENTS.get((Object)LoopSide.NW));
        }

        public void addAllPorts(LoopSide loopSide, ListIterator<LPort> itr, boolean sourceFirst) {
            ArrayList secondPart = Lists.newArrayList();
            PortSide secondPartSide = null;
            if (sourceFirst) {
                for (ConnectedSelfLoopComponent component : LISTS_OF_COMPONENTS.get((Object)loopSide)) {
                    for (LPort port : component.getSourceLoopPorts()) {
                        itr.add(port);
                        SplineSelfLoopPositioner.setSideOfPort(port, loopSide.getSourceSide());
                    }
                    secondPart.addAll(component.getTargetLoopPorts());
                    secondPartSide = loopSide.getTargetSide();
                }
            } else {
                for (ConnectedSelfLoopComponent component : LISTS_OF_COMPONENTS.get((Object)loopSide)) {
                    for (LPort port : component.getTargetLoopPorts()) {
                        itr.add(port);
                        SplineSelfLoopPositioner.setSideOfPort(port, loopSide.getTargetSide());
                    }
                    secondPart.addAll(component.getSourceLoopPorts());
                    secondPartSide = loopSide.getSourceSide();
                }
            }
            Collections.reverse(secondPart);
            SplineSelfLoopPositioner.setSideOfPorts(secondPart, secondPartSide);
            for (LPort port : secondPart) {
                itr.add(port);
            }
        }

        public void addSourcePortsReversed(LoopSide loopSide, ListIterator<LPort> itr) {
            ArrayList sourcePorts = Lists.newArrayList();
            for (ConnectedSelfLoopComponent component : LISTS_OF_COMPONENTS.get((Object)loopSide)) {
                sourcePorts.addAll(component.getSourceLoopPorts());
            }
            Collections.reverse(sourcePorts);
            SplineSelfLoopPositioner.setSideOfPorts(sourcePorts, loopSide.getSourceSide());
            for (LPort port : sourcePorts) {
                itr.add(port);
            }
        }

        public void addTargetPorts(LoopSide loopSide, ListIterator<LPort> itr) {
            PortSide portSide = loopSide.getTargetSide();
            for (ConnectedSelfLoopComponent component : LISTS_OF_COMPONENTS.get((Object)loopSide)) {
                for (LPort port : component.getTargetLoopPorts()) {
                    itr.add(port);
                    SplineSelfLoopPositioner.setSideOfPort(port, portSide);
                }
            }
        }

        public void addInlineSourcesFirst(LoopSide loopSide, ListIterator<LPort> itr) {
            ArrayList firstPart = Lists.newArrayList();
            ArrayList secondPart = Lists.newArrayList();
            Iterator<ConnectedSelfLoopComponent> compItr = LISTS_OF_COMPONENTS.get((Object)loopSide).iterator();
            while (compItr.hasNext()) {
                ConnectedSelfLoopComponent component = compItr.next();
                firstPart.addAll(0, component.getTargetLoopPorts());
                firstPart.addAll(0, component.getSourceLoopPortsReversed());
                if (!compItr.hasNext()) continue;
                component = compItr.next();
                secondPart.addAll(component.getSourceLoopPortsReversed());
                secondPart.addAll(component.getTargetLoopPorts());
            }
            SplineSelfLoopPositioner.setSideOfPorts(firstPart, loopSide.getSourceSide());
            SplineSelfLoopPositioner.setSideOfPorts(secondPart, loopSide.getTargetSide());
            for (LPort port : firstPart) {
                itr.add(port);
            }
            for (LPort port : secondPart) {
                itr.add(port);
            }
        }

        public void addInlineTargetsFirst(LoopSide loopSide, ListIterator<LPort> itr) {
            ArrayList firstPart = Lists.newArrayList();
            ArrayList secondPart = Lists.newArrayList();
            Iterator<ConnectedSelfLoopComponent> compItr = LISTS_OF_COMPONENTS.get((Object)loopSide).iterator();
            while (compItr.hasNext()) {
                ConnectedSelfLoopComponent component = compItr.next();
                firstPart.addAll(0, component.getSourceLoopPorts());
                firstPart.addAll(0, component.getTargetLoopPortsReversed());
                if (!compItr.hasNext()) continue;
                component = compItr.next();
                secondPart.addAll(component.getTargetLoopPortsReversed());
                secondPart.addAll(component.getSourceLoopPorts());
            }
            SplineSelfLoopPositioner.setSideOfPorts(firstPart, loopSide.getTargetSide());
            SplineSelfLoopPositioner.setSideOfPorts(secondPart, loopSide.getSourceSide());
            for (LPort port : firstPart) {
                itr.add(port);
            }
            for (LPort port : secondPart) {
                itr.add(port);
            }
        }
    }

    private static final class TextWidthComparator
    implements Comparator<ConnectedSelfLoopComponent> {
        private TextWidthComparator() {
        }

        @Override
        public int compare(ConnectedSelfLoopComponent loop0, ConnectedSelfLoopComponent loop1) {
            return Double.compare(loop1.getTextWidth(), loop0.getTextWidth());
        }
    }
}

