/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Iterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InLayerConstraint;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class InteractiveExternalPortPositioner
implements ILayoutProcessor<LGraph> {
    private static final int ARBITRARY_SPACING = 10;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        if (!layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return;
        }
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            ElkMargin margins = node.getProperty(LayeredOptions.MARGINS);
            this.minX = Math.min(this.minX, node.getPosition().x - margins.left);
            this.maxX = Math.max(this.maxX, node.getPosition().x + node.getSize().x + margins.right);
            this.minY = Math.min(this.minY, node.getPosition().y - margins.top);
            this.maxY = Math.max(this.maxY, node.getPosition().y + node.getSize().y + margins.bottom);
        }
        block4: for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getType() == LNode.NodeType.NORMAL) continue;
            switch (node.getType()) {
                case EXTERNAL_PORT: {
                    LayerConstraint lc = node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
                    if (lc == LayerConstraint.FIRST_SEPARATE) {
                        node.getPosition().x = this.minX - 10.0;
                        this.findYCoordinate(node, (Function<LEdge, LNode>)((Function)e -> e.getTarget().getNode())).transform(d -> {
                            lNode.getPosition().y = d;
                            return lNode.getPosition().y;
                        });
                        break;
                    }
                    if (lc == LayerConstraint.LAST_SEPARATE) {
                        node.getPosition().x = this.maxX + 10.0;
                        this.findYCoordinate(node, (Function<LEdge, LNode>)((Function)e -> e.getSource().getNode())).transform(d -> {
                            lNode.getPosition().y = d;
                            return lNode.getPosition().y;
                        });
                        break;
                    }
                    InLayerConstraint ilc = node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT);
                    if (ilc == InLayerConstraint.TOP) {
                        this.findNorthSouthPortXCoordinate(node).transform(x -> {
                            lNode.getPosition().x = x + 10.0;
                            return lNode.getPosition().x;
                        });
                        node.getPosition().y = this.minY - 10.0;
                        break;
                    }
                    if (ilc != InLayerConstraint.BOTTOM) continue block4;
                    this.findNorthSouthPortXCoordinate(node).transform(x -> {
                        lNode.getPosition().x = x + 10.0;
                        return lNode.getPosition().x;
                    });
                    node.getPosition().y = this.maxY + 10.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The node type " + (Object)((Object)node.getType()) + " is not supported by the " + this.getClass());
                }
            }
        }
    }

    private Optional<Double> findYCoordinate(LNode dummy, Function<LEdge, LNode> funGetOtherNode) {
        Iterator<LEdge> iterator = dummy.getConnectedEdges().iterator();
        if (iterator.hasNext()) {
            LEdge e = iterator.next();
            LNode other = (LNode)funGetOtherNode.apply((Object)e);
            return Optional.of((Object)(other.getPosition().y + other.getSize().y / 2.0));
        }
        return Optional.absent();
    }

    private Optional<Double> findNorthSouthPortXCoordinate(LNode dummy) {
        assert (dummy.getPorts().size() == 1);
        LPort port = dummy.getPorts().get(0);
        if (!port.getOutgoingEdges().isEmpty() && !port.getIncomingEdges().isEmpty()) {
            throw new IllegalStateException("Interactive layout does not support NORTH/SOUTH ports with incoming _and_ outgoing edges.");
        }
        if (!port.getOutgoingEdges().isEmpty()) {
            double min = Double.POSITIVE_INFINITY;
            for (LEdge e : port.getOutgoingEdges()) {
                LNode n = e.getTarget().getNode();
                ElkMargin margins = n.getProperty(LayeredOptions.MARGINS);
                min = Math.min(min, n.getPosition().x - margins.left);
            }
            return Optional.of((Object)min);
        }
        if (!port.getIncomingEdges().isEmpty()) {
            double max = Double.NEGATIVE_INFINITY;
            for (LEdge e : port.getIncomingEdges()) {
                LNode n = e.getSource().getNode();
                ElkMargin margins = n.getProperty(LayeredOptions.MARGINS);
                max = Math.max(max, n.getPosition().x + n.getSize().x + margins.right);
            }
            return Optional.of((Object)max);
        }
        return Optional.absent();
    }
}

