/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphAdapters;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.PortListSorter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.nodespacing.LabelSide;
import org.eclipse.elk.core.util.nodespacing.cellsystem.HorizontalLabelAlignment;
import org.eclipse.elk.core.util.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.VerticalLabelAlignment;
import org.eclipse.elk.core.util.overlaps.RectangleStripOverlapRemover;

public final class EndLabelPreprocessor
implements ILayoutProcessor<LGraph> {
    private static final double NO_INCIDENT_EDGE_THICKNESS = -1.0;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label pre-processing", 1.0f);
        double edgeLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
        double labelLabelSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        boolean verticalLayout = layeredGraph.getProperty(LayeredOptions.DIRECTION).isVertical();
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).forEach(node -> this.processNode((LNode)node, edgeLabelSpacing, labelLabelSpacing, verticalLayout));
        monitor.done();
    }

    private void processNode(LNode node, double edgeLabelSpacing, double labelLabelSpacing, boolean verticalLayout) {
        assert (Ordering.from((Comparator)new PortListSorter.PortComparator()).isOrdered(node.getPorts()));
        int portCount = node.getPorts().size();
        LabelCell[] portLabelCells = new LabelCell[portCount];
        int portIndex = 0;
        while (portIndex < portCount) {
            LPort port = node.getPorts().get(portIndex);
            port.id = portIndex;
            portLabelCells[portIndex] = this.createConfiguredLabelCell(EndLabelPreprocessor.gatherLabels(port), labelLabelSpacing, verticalLayout);
            ++portIndex;
        }
        this.placeLabels(node, portLabelCells, labelLabelSpacing, edgeLabelSpacing, verticalLayout);
        List<LabelCell> portLabelCellList = Arrays.stream(portLabelCells).filter(cell -> cell != null).collect(Collectors.toList());
        if (!portLabelCellList.isEmpty()) {
            node.setProperty(InternalProperties.END_LABELS, portLabelCellList);
            this.updateNodeMargins(node, portLabelCellList);
        }
    }

    private LabelCell createConfiguredLabelCell(List<LLabel> labels, double labelLabelSpacing, boolean verticalLayout) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        LabelCell labelCell = new LabelCell(labelLabelSpacing, !verticalLayout);
        for (LLabel label : labels) {
            labelCell.addLabel(LGraphAdapters.adapt(label));
        }
        ElkRectangle labelCellRect = labelCell.getCellRectangle();
        labelCellRect.height = labelCell.getMinimumHeight();
        labelCellRect.width = labelCell.getMinimumWidth();
        return labelCell;
    }

    static List<LLabel> gatherLabels(LPort port) {
        ArrayList labels = Lists.newArrayList();
        double maxEdgeThickness = EndLabelPreprocessor.gatherLabels(port, labels);
        LNode dummyNode = port.getProperty(InternalProperties.PORT_DUMMY);
        if (dummyNode != null) {
            for (LPort dummyPort : dummyNode.getPorts()) {
                if (dummyPort.getProperty(InternalProperties.ORIGIN) != port) continue;
                maxEdgeThickness = Math.max(maxEdgeThickness, EndLabelPreprocessor.gatherLabels(dummyPort, labels));
            }
        }
        if (!labels.isEmpty()) {
            port.setProperty(InternalProperties.MAX_EDGE_THICKNESS, (Object)maxEdgeThickness);
        }
        return maxEdgeThickness != -1.0 ? labels : null;
    }

    private static double gatherLabels(LPort port, List<LLabel> targetList) {
        double maxEdgeThickness = -1.0;
        for (LEdge incidentEdge : port.getConnectedEdges()) {
            maxEdgeThickness = Math.max(maxEdgeThickness, incidentEdge.getProperty(LayeredOptions.EDGE_THICKNESS));
            if (incidentEdge.getSource() == port) {
                incidentEdge.getLabels().stream().filter(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.TAIL).forEach(label -> {
                    boolean bl = targetList.add((LLabel)label);
                });
                continue;
            }
            incidentEdge.getLabels().stream().filter(label -> label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.HEAD).forEach(label -> {
                boolean bl = targetList.add((LLabel)label);
            });
        }
        return maxEdgeThickness;
    }

    private void placeLabels(LNode node, LabelCell[] portLabelCells, double labelLabelSpacing, double edgeLabelSpacing, boolean verticalLayout) {
        EnumSet<PortSide> portSidesWithLabels = EnumSet.noneOf(PortSide.class);
        for (LPort port : node.getPorts()) {
            if (portLabelCells[port.id] == null) continue;
            this.placeLabels(port, portLabelCells[port.id], edgeLabelSpacing);
            portSidesWithLabels.add(port.getSide());
        }
        if (verticalLayout) {
            this.removeLabelOverlaps(node, portLabelCells, PortSide.EAST, 2.0 * labelLabelSpacing, edgeLabelSpacing);
            this.removeLabelOverlaps(node, portLabelCells, PortSide.WEST, 2.0 * labelLabelSpacing, edgeLabelSpacing);
        } else {
            this.removeLabelOverlaps(node, portLabelCells, PortSide.NORTH, 2.0 * labelLabelSpacing, edgeLabelSpacing);
            this.removeLabelOverlaps(node, portLabelCells, PortSide.SOUTH, 2.0 * labelLabelSpacing, edgeLabelSpacing);
        }
    }

    private void placeLabels(LPort port, LabelCell labelCell, double edgeLabelSpacing) {
        ElkRectangle labelCellRect = labelCell.getCellRectangle();
        KVector nodeSize = port.getNode().getSize();
        LMargin nodeMargin = port.getNode().getMargin();
        KVector portPos = port.getPosition();
        KVector portAnchor = KVector.sum(portPos, port.getAnchor());
        switch (port.getSide()) {
            case NORTH: {
                labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                labelCellRect.y = -nodeMargin.top - edgeLabelSpacing - labelCellRect.height;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    labelCellRect.x = portAnchor.x - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.width;
                    break;
                }
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = portAnchor.x + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case EAST: {
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = nodeSize.x + nodeMargin.right + edgeLabelSpacing;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    labelCellRect.y = portAnchor.y - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.height;
                    break;
                }
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = portAnchor.y + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case SOUTH: {
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = nodeSize.y + nodeMargin.bottom + edgeLabelSpacing;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    labelCellRect.x = portAnchor.x - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.width;
                    break;
                }
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                labelCellRect.x = portAnchor.x + this.maxEdgeThickness(port) + edgeLabelSpacing;
                break;
            }
            case WEST: {
                labelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                labelCellRect.x = -nodeMargin.left - edgeLabelSpacing - labelCellRect.width;
                if (this.getLabelSide(labelCell) == LabelSide.ABOVE) {
                    labelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    labelCellRect.y = portAnchor.y - this.maxEdgeThickness(port) - edgeLabelSpacing - labelCellRect.height;
                    break;
                }
                labelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                labelCellRect.y = portAnchor.y + this.maxEdgeThickness(port) + edgeLabelSpacing;
            }
        }
    }

    private void removeLabelOverlaps(LNode node, LabelCell[] portLabelCells, PortSide portSide, double labelLabelSpacing, double edgeLabelSpacing) {
        RectangleStripOverlapRemover overlapRemover = RectangleStripOverlapRemover.createForDirection(this.portSideToOverlapRemovalDirection(portSide)).withGap(labelLabelSpacing).withStartCoordinate(this.calculateOverlapStartCoordinate(node, portSide, edgeLabelSpacing));
        for (LPort port : node.getPorts(portSide)) {
            if (portLabelCells[port.id] == null) continue;
            ElkRectangle labelCellRect = portLabelCells[port.id].getCellRectangle();
            assert (labelCellRect.height > 0.0 && labelCellRect.width > 0.0);
            overlapRemover.addRectangle(labelCellRect);
        }
        overlapRemover.removeOverlaps();
    }

    private double calculateOverlapStartCoordinate(LNode node, PortSide portSide, double edgeLabelSpacing) {
        KVector nodeSize = node.getSize();
        LMargin nodeMargin = node.getMargin();
        switch (portSide) {
            case NORTH: {
                return -nodeMargin.top - edgeLabelSpacing;
            }
            case SOUTH: {
                return nodeSize.y + nodeMargin.bottom + edgeLabelSpacing;
            }
            case EAST: {
                return nodeSize.x + nodeMargin.right + edgeLabelSpacing;
            }
            case WEST: {
                return -nodeMargin.left - edgeLabelSpacing;
            }
        }
        assert (false);
        return 0.0;
    }

    private void updateNodeMargins(LNode node, List<LabelCell> labelCells) {
        LMargin nodeMargin = node.getMargin();
        KVector nodeSize = node.getSize();
        ElkRectangle nodeMarginRectangle = new ElkRectangle(-nodeMargin.left, -nodeMargin.top, nodeMargin.left + nodeSize.x + nodeMargin.right, nodeMargin.top + nodeSize.y + nodeMargin.bottom);
        for (LabelCell labelCell : labelCells) {
            nodeMarginRectangle.union(labelCell.getCellRectangle());
        }
        nodeMargin.left = -nodeMarginRectangle.x;
        nodeMargin.top = -nodeMarginRectangle.y;
        nodeMargin.right = nodeMarginRectangle.width - nodeMargin.left - nodeSize.x;
        nodeMargin.bottom = nodeMarginRectangle.height - nodeMargin.top - nodeSize.y;
    }

    private LabelSide getLabelSide(LabelCell labelCell) {
        assert (labelCell != null);
        assert (labelCell.hasLabels());
        return labelCell.getLabels().get(0).getProperty(InternalProperties.LABEL_SIDE);
    }

    private double maxEdgeThickness(LPort port) {
        return port.getProperty(InternalProperties.MAX_EDGE_THICKNESS);
    }

    private RectangleStripOverlapRemover.OverlapRemovalDirection portSideToOverlapRemovalDirection(PortSide portSide) {
        switch (portSide) {
            case NORTH: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.UP;
            }
            case SOUTH: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.DOWN;
            }
            case EAST: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.RIGHT;
            }
            case WEST: {
                return RectangleStripOverlapRemover.OverlapRemovalDirection.LEFT;
            }
        }
        assert (false);
        return null;
    }
}

