/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.EdgeConstraint;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class EdgeAndLayerConstraintEdgeReverser
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Edge and layer constraint edge reversal", 1.0f);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            LayerConstraint layerConstraint = node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
            EdgeConstraint edgeConstraint = null;
            switch (layerConstraint) {
                case FIRST: 
                case FIRST_SEPARATE: {
                    edgeConstraint = EdgeConstraint.OUTGOING_ONLY;
                    break;
                }
                case LAST: 
                case LAST_SEPARATE: {
                    edgeConstraint = EdgeConstraint.INCOMING_ONLY;
                }
            }
            if (edgeConstraint != null) {
                node.setProperty(InternalProperties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                if (edgeConstraint == EdgeConstraint.INCOMING_ONLY) {
                    this.reverseEdges(layeredGraph, node, layerConstraint, PortType.OUTPUT);
                    continue;
                }
                if (edgeConstraint != EdgeConstraint.OUTGOING_ONLY) continue;
                this.reverseEdges(layeredGraph, node, layerConstraint, PortType.INPUT);
                continue;
            }
            if (!node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed() || node.getPorts().isEmpty()) continue;
            boolean allPortsReversed = true;
            block5: for (LPort port : node.getPorts()) {
                LayerConstraint lc;
                if (!(port.getSide() == PortSide.EAST && port.getNetFlow() > 0 || port.getSide() == PortSide.WEST && port.getNetFlow() < 0)) {
                    allPortsReversed = false;
                    break;
                }
                if (port.getSide() == PortSide.WEST) {
                    for (LEdge e : port.getOutgoingEdges()) {
                        lc = e.getTarget().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
                        if (lc != LayerConstraint.LAST && lc != LayerConstraint.LAST_SEPARATE) continue;
                        allPortsReversed = false;
                        break;
                    }
                }
                if (port.getSide() != PortSide.EAST) continue;
                for (LEdge e : port.getIncomingEdges()) {
                    lc = e.getSource().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
                    if (lc != LayerConstraint.FIRST && lc != LayerConstraint.FIRST_SEPARATE) continue;
                    allPortsReversed = false;
                    continue block5;
                }
            }
            if (!allPortsReversed) continue;
            this.reverseEdges(layeredGraph, node, layerConstraint, PortType.UNDEFINED);
        }
        monitor.done();
    }

    private void reverseEdges(LGraph layeredGraph, LNode node, LayerConstraint nodeLayerConstraint, PortType type) {
        LPort[] ports;
        LPort[] lPortArray = ports = node.getPorts().toArray(new LPort[node.getPorts().size()]);
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge edge;
            int n3;
            int n4;
            LEdge[] lEdgeArray;
            LPort port = lPortArray[n2];
            if (type != PortType.INPUT) {
                LEdge[] outgoing;
                lEdgeArray = outgoing = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                n4 = outgoing.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    if (this.canReverseOutgoingEdge(nodeLayerConstraint, edge)) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            if (type != PortType.OUTPUT) {
                LEdge[] incoming = port.getIncomingEdges().toArray(new LEdge[port.getIncomingEdges().size()]);
                lEdgeArray = incoming;
                n4 = incoming.length;
                n3 = 0;
                while (n3 < n4) {
                    edge = lEdgeArray[n3];
                    if (this.canReverseIncomingEdge(nodeLayerConstraint, edge)) {
                        edge.reverse(layeredGraph, true);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private boolean canReverseOutgoingEdge(LayerConstraint nodeLayerConstraint, LEdge edge) {
        assert (nodeLayerConstraint == edge.getSource().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
        if (edge.getProperty(InternalProperties.REVERSED).booleanValue()) {
            return false;
        }
        if (nodeLayerConstraint == LayerConstraint.LAST) {
            LNode targetNode = edge.getTarget().getNode();
            if (targetNode.getType() == LNode.NodeType.LABEL) {
                return false;
            }
            LayerConstraint targetLayerConstraint = targetNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
            if (targetLayerConstraint == LayerConstraint.LAST_SEPARATE) {
                return false;
            }
        }
        return true;
    }

    private boolean canReverseIncomingEdge(LayerConstraint nodeLayerConstraint, LEdge edge) {
        assert (nodeLayerConstraint == edge.getTarget().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
        if (edge.getProperty(InternalProperties.REVERSED).booleanValue()) {
            return false;
        }
        if (nodeLayerConstraint == LayerConstraint.FIRST) {
            LNode sourceNode = edge.getSource().getNode();
            if (sourceNode.getType() == LNode.NodeType.LABEL) {
                return false;
            }
            LayerConstraint sourceLayerConstraint = sourceNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
            if (sourceLayerConstraint == LayerConstraint.FIRST_SEPARATE) {
                return false;
            }
        }
        return true;
    }
}

